/*
 * Decompiled with CFR 0.152.
 */
package com.toomasr.sgf4j.util;

import com.toomasr.sgf4j.util.SgfCompare;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;

public class FindDuplicates {
    public static void main(String[] args) throws Exception {
        Path root;
        if (args.length != 1) {
            System.exit(0);
        }
        if (!Files.exists(root = Paths.get(args[0], new String[0]), new LinkOption[0])) {
            System.out.println(root.toString() + " does not exist");
            System.exit(0);
        }
        System.out.println("Starting searching " + root.toRealPath(new LinkOption[0]).toString());
        Path[] sgfFiles = FindDuplicates.findSgfFiles(root.toRealPath(new LinkOption[0]));
        FindDuplicates.findDuplicateGames(sgfFiles);
    }

    private static void findDuplicateGames(Path[] sgfFiles) throws Exception {
        int bMatches = 0;
        int gMatches = 0;
        for (int i = 0; i < sgfFiles.length; ++i) {
            for (int j = i + 1; j < sgfFiles.length; ++j) {
                if (SgfCompare.binaryCompare(sgfFiles[i], sgfFiles[j])) {
                    System.out.println("Binary match:");
                    System.out.println("\t" + sgfFiles[i]);
                    System.out.println("\t" + sgfFiles[j]);
                    ++bMatches;
                    continue;
                }
                if (!SgfCompare.compareSgf(sgfFiles[i], sgfFiles[j])) continue;
                System.out.println("Game match:");
                System.out.println("\t" + sgfFiles[i]);
                System.out.println("\t" + sgfFiles[j]);
                ++gMatches;
            }
        }
        System.out.println("Found " + bMatches + " binary matches");
        System.out.println("Found " + gMatches + " game matches");
    }

    private static Path[] findSgfFiles(Path root) throws Exception {
        final ArrayList rtrn = new ArrayList();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
                if (attr.isRegularFile() && path.getFileName().toString().toLowerCase().endsWith("sgf")) {
                    rtrn.add(path);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return rtrn.toArray(new Path[0]);
    }
}

