/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Builder;
import redis.clients.jedis.Tuple;
import redis.clients.util.SafeEncoder;

public class BuilderFactory {
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        public Double build(Object object) {
            String string = (String)STRING.build(object);
            return string == null ? null : Double.valueOf(string);
        }

        public String toString() {
            return "double";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        public Boolean build(Object object) {
            return (Long)object == 1L;
        }

        public String toString() {
            return "boolean";
        }
    };
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        public byte[] build(Object object) {
            return (byte[])object;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        public Long build(Object object) {
            return (Long)object;
        }

        public String toString() {
            return "long";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        public String build(Object object) {
            return object == null ? null : SafeEncoder.encode((byte[])((byte[])object));
        }

        public String toString() {
            return "string";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        public List<String> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (byte[] byArray : list) {
                if (byArray == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(SafeEncoder.encode((byte[])byArray));
            }
            return arrayList;
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        public Map<String, String> build(Object object) {
            List list = (List)object;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashMap.put(SafeEncoder.encode((byte[])((byte[])iterator.next())), SafeEncoder.encode((byte[])((byte[])iterator.next())));
            }
            return hashMap;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        public Set<String> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            HashSet<String> hashSet = new HashSet<String>(list.size());
            for (byte[] byArray : list) {
                if (byArray == null) {
                    hashSet.add(null);
                    continue;
                }
                hashSet.add(SafeEncoder.encode((byte[])byArray));
            }
            return hashSet;
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        public List<byte[]> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            return list;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BYTE_ARRAY_ZSET = new Builder<Set<byte[]>>(){

        public Set<byte[]> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            LinkedHashSet<byte[]> linkedHashSet = new LinkedHashSet<byte[]>(list);
            return linkedHashSet;
        }

        public String toString() {
            return "ZSet<byte[]>";
        }
    };
    public static final Builder<Set<String>> STRING_ZSET = new Builder<Set<String>>(){

        public Set<String> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size());
            for (byte[] byArray : list) {
                if (byArray == null) {
                    linkedHashSet.add(null);
                    continue;
                }
                linkedHashSet.add(SafeEncoder.encode((byte[])byArray));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "ZSet<String>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        public Set<Tuple> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            LinkedHashSet<Tuple> linkedHashSet = new LinkedHashSet<Tuple>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                linkedHashSet.add(new Tuple(SafeEncoder.encode((byte[])((byte[])iterator.next())), Double.valueOf(SafeEncoder.encode((byte[])((byte[])iterator.next())))));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET_BINARY = new Builder<Set<Tuple>>(){

        public Set<Tuple> build(Object object) {
            if (null == object) {
                return null;
            }
            List list = (List)object;
            LinkedHashSet<Tuple> linkedHashSet = new LinkedHashSet<Tuple>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                linkedHashSet.add(new Tuple((byte[])iterator.next(), Double.valueOf(SafeEncoder.encode((byte[])((byte[])iterator.next())))));
            }
            return linkedHashSet;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
}

