/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Queable;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;

public class ShardedJedisPipeline
extends Queable {
    private BinaryShardedJedis jedis;
    private List<FutureResult> results = new ArrayList<FutureResult>();
    private Queue<Client> clients = new LinkedList<Client>();

    public void setShardedJedis(BinaryShardedJedis binaryShardedJedis) {
        this.jedis = binaryShardedJedis;
    }

    public Response<String> set(String string, String string2) {
        Client client = this.getClient(string);
        client.set(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> get(String string) {
        Client client = this.getClient(string);
        client.get(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> del(String string) {
        Client client = this.getClient(string);
        client.del(new String[]{string});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> exists(String string) {
        Client client = this.getClient(string);
        client.exists(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Boolean> type(String string) {
        Client client = this.getClient(string);
        client.type(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> expire(String string, int n) {
        Client client = this.getClient(string);
        client.expire(string, n);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> expireAt(String string, long l) {
        Client client = this.getClient(string);
        client.expireAt(string, l);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> ttl(String string) {
        Client client = this.getClient(string);
        client.ttl(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> getSet(String string, String string2) {
        Client client = this.getClient(string);
        client.getSet(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> setnx(String string, String string2) {
        Client client = this.getClient(string);
        client.setnx(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> setex(String string, int n, String string2) {
        Client client = this.getClient(string);
        client.setex(string, n, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decrBy(String string, long l) {
        Client client = this.getClient(string);
        client.decrBy(string, l);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> decr(String string) {
        Client client = this.getClient(string);
        client.decr(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incrBy(String string, int n) {
        Client client = this.getClient(string);
        client.incrBy(string, (long)n);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> incr(String string) {
        Client client = this.getClient(string);
        client.incr(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> append(String string, String string2) {
        Client client = this.getClient(string);
        client.append(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> substr(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.substr(string, n, n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hset(String string, String string2, String string3) {
        Client client = this.getClient(string);
        client.hset(string, string2, string3);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> hget(String string, String string2) {
        Client client = this.getClient(string);
        client.hget(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> hsetnx(String string, String string2, String string3) {
        Client client = this.getClient(string);
        client.hsetnx(string, string2, string3);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> hmset(String string, Map<String, String> map) {
        Client client = this.getClient(string);
        client.hmset(string, map);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<String>> hmget(String string, String ... stringArray) {
        Client client = this.getClient(string);
        client.hmget(string, stringArray);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> hincrBy(String string, String string2, int n) {
        Client client = this.getClient(string);
        client.hincrBy(string, string2, (long)n);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> hexists(String string, String string2) {
        Client client = this.getClient(string);
        client.hexists(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> hdel(String string, String string2) {
        Client client = this.getClient(string);
        client.hdel(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> hlen(String string) {
        Client client = this.getClient(string);
        client.hlen(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> hkeys(String string) {
        Client client = this.getClient(string);
        client.hkeys(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Set<String>> hvals(String string) {
        Client client = this.getClient(string);
        client.hvals(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Map<String, String>> hgetAll(String string) {
        Client client = this.getClient(string);
        client.hgetAll(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    public Response<Long> rpush(String string, String string2) {
        Client client = this.getClient(string);
        client.rpush(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> lpush(String string, String string2) {
        Client client = this.getClient(string);
        client.lpush(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> llen(String string) {
        Client client = this.getClient(string);
        client.llen(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<List<String>> lrange(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.lrange(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<String> ltrim(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.ltrim(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> lindex(String string, int n) {
        Client client = this.getClient(string);
        client.lindex(string, (long)n);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> lset(String string, int n, String string2) {
        Client client = this.getClient(string);
        client.lset(string, (long)n, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> lrem(String string, int n, String string2) {
        Client client = this.getClient(string);
        client.lrem(string, (long)n, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> lpop(String string) {
        Client client = this.getClient(string);
        client.lpop(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> rpop(String string) {
        Client client = this.getClient(string);
        client.rpop(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> sadd(String string, String string2) {
        Client client = this.getClient(string);
        client.sadd(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> smembers(String string) {
        Client client = this.getClient(string);
        client.smembers(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    public Response<Long> srem(String string, String string2) {
        Client client = this.getClient(string);
        client.srem(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<String> spop(String string) {
        Client client = this.getClient(string);
        client.spop(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> scard(String string) {
        Client client = this.getClient(string);
        client.scard(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> sismember(String string, String string2) {
        Client client = this.getClient(string);
        client.sismember(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<String> srandmember(String string) {
        Client client = this.getClient(string);
        client.srandmember(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Long> zadd(String string, double d, String string2) {
        Client client = this.getClient(string);
        client.zadd(string, d, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrange(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.zrange(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Long> zrem(String string, String string2) {
        Client client = this.getClient(string);
        client.zrem(string, new String[]{string2});
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zincrby(String string, double d, String string2) {
        Client client = this.getClient(string);
        client.zincrby(string, d, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Long> zrank(String string, String string2) {
        Client client = this.getClient(string);
        client.zrank(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zrevrank(String string, String string2) {
        Client client = this.getClient(string);
        client.zrevrank(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrevrange(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.zrevrange(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeWithScores(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.zrangeWithScores(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrevrangeWithScores(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.zrevrangeWithScores(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zcard(String string) {
        Client client = this.getClient(string);
        client.zcard(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Double> zscore(String string, String string2) {
        Client client = this.getClient(string);
        client.zscore(string, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<Double> sort(String string) {
        Client client = this.getClient(string);
        client.sort(string);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.DOUBLE);
    }

    public Response<List<String>> sort(String string, SortingParams sortingParams) {
        Client client = this.getClient(string);
        client.sort(string, sortingParams);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Long> zcount(String string, double d, double d2) {
        Client client = this.getClient(string);
        client.zcount(string, d, d2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Set<String>> zrangeByScore(String string, double d, double d2) {
        Client client = this.getClient(string);
        client.zrangeByScore(string, d, d2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<String>> zrangeByScore(String string, double d, double d2, int n, int n2) {
        Client client = this.getClient(string);
        client.zrangeByScore(string, d, d2, n, n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.STRING_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String string, double d, double d2) {
        Client client = this.getClient(string);
        client.zrangeByScoreWithScores(string, d, d2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String string, double d, double d2, int n, int n2) {
        Client client = this.getClient(string);
        client.zrangeByScoreWithScores(string, d, d2, n, n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.TUPLE_ZSET);
    }

    public Response<Long> zremrangeByRank(String string, int n, int n2) {
        Client client = this.getClient(string);
        client.zremrangeByRank(string, (long)n, (long)n2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> zremrangeByScore(String string, double d, double d2) {
        Client client = this.getClient(string);
        client.zremrangeByScore(string, d, d2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> linsert(String string, BinaryClient.LIST_POSITION lIST_POSITION, String string2, String string3) {
        Client client = this.getClient(string);
        client.linsert(string, lIST_POSITION, string2, string3);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Boolean> getbit(String string, long l) {
        Client client = this.getClient(string);
        client.getbit(string, l);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Boolean> setbit(String string, long l, boolean bl) {
        Client client = this.getClient(string);
        client.setbit(string, l, bl);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.BOOLEAN);
    }

    public Response<Long> setrange(String string, long l, String string2) {
        Client client = this.getClient(string);
        client.setrange(string, l, string2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public Response<Long> getrange(String string, long l, long l2) {
        Client client = this.getClient(string);
        client.getrange(string, l, l2);
        this.results.add(new FutureResult(client));
        return this.getResponse(BuilderFactory.LONG);
    }

    public List<Object> getResults() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (FutureResult futureResult : this.results) {
            arrayList.add(futureResult.get());
        }
        return arrayList;
    }

    public void sync() {
        for (Client client : this.clients) {
            this.generateResponse(client.getOne());
        }
    }

    public List<Object> syncAndReturnAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Client client : this.clients) {
            arrayList.add(this.generateResponse(client.getOne()).get());
        }
        return arrayList;
    }

    @Deprecated
    public void execute() {
    }

    private Client getClient(String string) {
        Client client = ((Jedis)this.jedis.getShard(string)).getClient();
        this.clients.add(client);
        return client;
    }

    private static class FutureResult {
        private Client client;

        public FutureResult(Client client) {
            this.client = client;
        }

        public Object get() {
            return this.client.getOne();
        }
    }
}

