/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import redis.clients.util.Hashing;
import redis.clients.util.SafeEncoder;
import redis.clients.util.ShardInfo;

public class Sharded<R, S extends ShardInfo<R>> {
    public static final int DEFAULT_WEIGHT = 1;
    private TreeMap<Long, S> nodes;
    private final Hashing algo;
    private final Map<ShardInfo<R>, R> resources = new LinkedHashMap<ShardInfo<R>, R>();
    private Pattern tagPattern = null;
    public static final Pattern DEFAULT_KEY_TAG_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public Sharded(List<S> list) {
        this(list, Hashing.MURMUR_HASH);
    }

    public Sharded(List<S> list, Hashing hashing) {
        this.algo = hashing;
        this.initialize(list);
    }

    public Sharded(List<S> list, Pattern pattern) {
        this(list, Hashing.MURMUR_HASH, pattern);
    }

    public Sharded(List<S> list, Hashing hashing, Pattern pattern) {
        this.algo = hashing;
        this.tagPattern = pattern;
        this.initialize(list);
    }

    private void initialize(List<S> list) {
        this.nodes = new TreeMap();
        for (int i = 0; i != list.size(); ++i) {
            int n;
            ShardInfo shardInfo = (ShardInfo)list.get(i);
            if (shardInfo.getName() == null) {
                for (n = 0; n < 128 * shardInfo.getWeight(); ++n) {
                    this.nodes.put(this.algo.hash("SHARD-" + i + "-NODE-" + n), shardInfo);
                }
            } else {
                for (n = 0; n < 128 * shardInfo.getWeight(); ++n) {
                    this.nodes.put(this.algo.hash(shardInfo.getName() + ":" + n), shardInfo);
                }
            }
            this.resources.put(shardInfo, shardInfo.createResource());
        }
    }

    public R getShard(byte[] byArray) {
        return this.resources.get(this.getShardInfo(byArray));
    }

    public R getShard(String string) {
        return this.resources.get(this.getShardInfo(string));
    }

    public S getShardInfo(byte[] byArray) {
        Long l = this.algo.hash(byArray);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.addAll(this.nodes.keySet());
        int n = arrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = n2 + n >> 1;
            Long l2 = (Long)arrayList.get(n3);
            if (l2 > l) {
                n = n3 - 1;
                continue;
            }
            if (l2 < l) {
                n2 = n3 + 1;
                continue;
            }
            return (S)((ShardInfo)this.nodes.get(l2));
        }
        return (S)((ShardInfo)this.nodes.get(arrayList.get(this.wrapAroundStrategy(n, n2, arrayList.size()))));
    }

    protected int wrapAroundStrategy(int n, int n2, int n3) {
        return n >= 0 ? n : n3 - 1;
    }

    public S getShardInfo(String string) {
        return this.getShardInfo(SafeEncoder.encode((String)this.getKeyTag(string)));
    }

    public String getKeyTag(String string) {
        Matcher matcher;
        if (this.tagPattern != null && (matcher = this.tagPattern.matcher(string)).find()) {
            return matcher.group(1);
        }
        return string;
    }

    public Collection<S> getAllShardInfo() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public Collection<R> getAllShards() {
        return Collections.unmodifiableCollection(this.resources.values());
    }
}

