/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.d2r;

import com.google.common.base.Function;
import com.torodb.kvdocument.values.KVBoolean;
import com.torodb.kvdocument.values.KVDocument;
import com.torodb.kvdocument.values.KVDouble;
import com.torodb.kvdocument.values.KVInteger;
import com.torodb.kvdocument.values.KVLong;
import com.torodb.kvdocument.values.KVNull;
import com.torodb.kvdocument.values.KVValue;
import com.torodb.kvdocument.values.heap.ByteArrayKVMongoObjectId;
import com.torodb.kvdocument.values.heap.ByteSourceKVBinary;
import com.torodb.kvdocument.values.heap.DefaultKVMongoTimestamp;
import com.torodb.kvdocument.values.heap.ListKVArray;
import com.torodb.kvdocument.values.heap.LocalDateKVDate;
import com.torodb.kvdocument.values.heap.LocalTimeKVTime;
import com.torodb.kvdocument.values.heap.LongKVInstant;
import com.torodb.kvdocument.values.heap.MapKVDocument;
import com.torodb.kvdocument.values.heap.StringKVString;
import com.torodb.torod.core.config.DocumentBuilderFactory;
import com.torodb.torod.core.d2r.D2RTranslator;
import com.torodb.torod.core.dbMetaInf.DbMetaInformationCache;
import com.torodb.torod.core.executor.SessionExecutor;
import com.torodb.torod.core.subdocument.SplitDocument;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.core.subdocument.SubDocument;
import com.torodb.torod.core.subdocument.ToroDocument;
import com.torodb.torod.core.subdocument.structure.ArrayStructure;
import com.torodb.torod.core.subdocument.structure.DocStructure;
import com.torodb.torod.core.subdocument.structure.StructureElement;
import com.torodb.torod.core.subdocument.values.ScalarArray;
import com.torodb.torod.core.subdocument.values.ScalarBinary;
import com.torodb.torod.core.subdocument.values.ScalarBoolean;
import com.torodb.torod.core.subdocument.values.ScalarDate;
import com.torodb.torod.core.subdocument.values.ScalarDouble;
import com.torodb.torod.core.subdocument.values.ScalarInstant;
import com.torodb.torod.core.subdocument.values.ScalarInteger;
import com.torodb.torod.core.subdocument.values.ScalarLong;
import com.torodb.torod.core.subdocument.values.ScalarMongoObjectId;
import com.torodb.torod.core.subdocument.values.ScalarMongoTimestamp;
import com.torodb.torod.core.subdocument.values.ScalarNull;
import com.torodb.torod.core.subdocument.values.ScalarString;
import com.torodb.torod.core.subdocument.values.ScalarTime;
import com.torodb.torod.core.subdocument.values.ScalarValue;
import com.torodb.torod.core.subdocument.values.ScalarValueVisitor;
import com.torodb.torod.d2r.DocumentSplitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;

public class DefaultD2RTranslator
implements D2RTranslator {
    private final DbMetaInformationCache cache;
    private final DocumentSplitter splitter;
    private final Function<SplitDocument, ToroDocument> toDocFunction;

    @Inject
    public DefaultD2RTranslator(DbMetaInformationCache cache, DocumentBuilderFactory documentBuilderFactory, Provider<SubDocType.Builder> subDocTypeBuilderProvider) {
        this.cache = cache;
        this.splitter = new DocumentSplitter(cache, subDocTypeBuilderProvider);
        this.toDocFunction = new ToDocFunction(documentBuilderFactory);
    }

    public void initialize() {
    }

    public void shutdown() {
    }

    public void shutdownNow() {
    }

    public Function<SplitDocument, ToroDocument> getToDocumentFunction() {
        return this.toDocFunction;
    }

    public Function<ToroDocument, SplitDocument> getToRelationalFunction(final SessionExecutor sessionExecutor, final String collection) {
        return new Function<ToroDocument, SplitDocument>(){

            public SplitDocument apply(@Nonnull ToroDocument input) {
                DefaultD2RTranslator.this.cache.createCollection(sessionExecutor, collection, null);
                SplitDocument splitDocument = DefaultD2RTranslator.this.splitter.split(sessionExecutor, collection, input);
                return splitDocument;
            }
        };
    }

    private static class ToDocFunction
    implements Function<SplitDocument, ToroDocument> {
        private static final SubDocValueToDocValueTranslator VALUE_TRANSLATOR = new SubDocValueToDocValueTranslator();
        private final DocumentBuilderFactory documentBuilderFactory;

        private ToDocFunction(DocumentBuilderFactory documentBuilderFactory) {
            this.documentBuilderFactory = documentBuilderFactory;
        }

        public ToroDocument apply(@Nonnull SplitDocument input) {
            ToroDocument.DocumentBuilder docBuilder = this.documentBuilderFactory.newDocBuilder();
            SubDocValueToDocValueTranslator.Argument arg = new SubDocValueToDocValueTranslator.Argument(input, (StructureElement)input.getRoot());
            docBuilder.setRoot(ToDocFunction.translateDocStructure(arg));
            return docBuilder.build();
        }

        private static KVDocument translateDocStructure(SubDocValueToDocValueTranslator.Argument arg) {
            StructureElement childStructure;
            DocStructure structure = (DocStructure)arg.structure;
            SplitDocument splitDocument = arg.splitDoc;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            SubDocument subDoc = (SubDocument)splitDocument.getSubDocuments().get((Object)structure.getType(), (Object)structure.getIndex());
            for (String string : subDoc.getType().getAttributeKeys()) {
                childStructure = (StructureElement)structure.getElements().get(string);
                arg.structure = childStructure;
                map.put(string, subDoc.getValue(string).accept((ScalarValueVisitor)VALUE_TRANSLATOR, (Object)arg));
            }
            for (Map.Entry entry : structure.getElements().entrySet()) {
                if (!(entry.getValue() instanceof DocStructure)) continue;
                childStructure = (StructureElement)structure.getElements().get(entry.getKey());
                arg.structure = childStructure;
                map.put((String)entry.getKey(), ToDocFunction.translateDocStructure(arg));
            }
            return new MapKVDocument(map);
        }

        private static class SubDocValueToDocValueTranslator
        implements ScalarValueVisitor<KVValue<?>, Argument> {
            private SubDocValueToDocValueTranslator() {
            }

            public KVValue<?> visit(ScalarBoolean value, Argument arg) {
                if (value.getValue().booleanValue()) {
                    return KVBoolean.TRUE;
                }
                return KVBoolean.FALSE;
            }

            public KVValue<?> visit(ScalarNull value, Argument arg) {
                return KVNull.getInstance();
            }

            public KVValue<?> visit(ScalarArray value, Argument arg) {
                ArrayList<Object> list = new ArrayList<Object>(value.size());
                ArrayStructure structure = (ArrayStructure)arg.structure;
                for (ScalarValue e : value.getValue()) {
                    if (e instanceof ScalarArray) {
                        list.add(KVNull.getInstance());
                        continue;
                    }
                    list.add((KVValue)e.accept((ScalarValueVisitor)this, (Object)arg));
                }
                for (Map.Entry entry : structure.getElements().entrySet()) {
                    StructureElement element = (StructureElement)entry.getValue();
                    arg.structure = element;
                    int index = (Integer)entry.getKey();
                    if (element instanceof DocStructure) {
                        assert (value.get(index) instanceof ScalarNull);
                        KVDocument translated = ToDocFunction.translateDocStructure(arg);
                        list.set(index, translated);
                        continue;
                    }
                    if (element instanceof ArrayStructure) {
                        assert (value.get(index) instanceof ScalarArray);
                        ScalarArray childValue = (ScalarArray)value.get(index);
                        list.set(index, this.visit(childValue, arg));
                        continue;
                    }
                    throw new AssertionError((Object)(this.getClass() + " doesn't recognizes " + element + " as a structure"));
                }
                ListKVArray result = new ListKVArray(list);
                assert (result.size() == value.size());
                return result;
            }

            public KVValue<?> visit(ScalarInteger value, Argument arg) {
                return KVInteger.of((int)value.getValue());
            }

            public KVValue<?> visit(ScalarLong value, Argument arg) {
                return KVLong.of((long)value.getValue());
            }

            public KVValue<?> visit(ScalarDouble value, Argument arg) {
                return KVDouble.of((double)value.getValue());
            }

            public KVValue<?> visit(ScalarString value, Argument arg) {
                return new StringKVString((String)value.getValue());
            }

            public KVValue<?> visit(ScalarMongoObjectId value, Argument arg) {
                return new ByteArrayKVMongoObjectId(value.getArrayValue());
            }

            public KVValue<?> visit(ScalarMongoTimestamp value, Argument arg) {
                return new DefaultKVMongoTimestamp(value.getSecondsSinceEpoch(), value.getOrdinal());
            }

            public KVValue<?> visit(ScalarInstant value, Argument arg) {
                return new LongKVInstant(value.getMillisFromUnix());
            }

            public KVValue<?> visit(ScalarDate value, Argument arg) {
                return new LocalDateKVDate((LocalDate)value.getValue());
            }

            public KVValue<?> visit(ScalarTime value, Argument arg) {
                return new LocalTimeKVTime((LocalTime)value.getValue());
            }

            public KVValue<?> visit(ScalarBinary value, Argument arg) {
                return new ByteSourceKVBinary(value.getSubtype(), value.getCategory(), value.getByteSource());
            }

            public static class Argument {
                private final SplitDocument splitDoc;
                private StructureElement structure;

                public Argument(SplitDocument splitDoc, StructureElement structure) {
                    this.splitDoc = splitDoc;
                    this.structure = structure;
                }
            }
        }
    }
}

