/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.d2r;

import com.google.common.collect.Maps;
import com.torodb.kvdocument.types.KVType;
import com.torodb.kvdocument.values.KVArray;
import com.torodb.kvdocument.values.KVBinary;
import com.torodb.kvdocument.values.KVBoolean;
import com.torodb.kvdocument.values.KVDate;
import com.torodb.kvdocument.values.KVDocument;
import com.torodb.kvdocument.values.KVDouble;
import com.torodb.kvdocument.values.KVInstant;
import com.torodb.kvdocument.values.KVInteger;
import com.torodb.kvdocument.values.KVLong;
import com.torodb.kvdocument.values.KVMongoObjectId;
import com.torodb.kvdocument.values.KVMongoTimestamp;
import com.torodb.kvdocument.values.KVNull;
import com.torodb.kvdocument.values.KVString;
import com.torodb.kvdocument.values.KVTime;
import com.torodb.kvdocument.values.KVValue;
import com.torodb.kvdocument.values.KVValueDFW;
import com.torodb.kvdocument.values.KVValueVisitor;
import com.torodb.torod.core.dbMetaInf.DbMetaInformationCache;
import com.torodb.torod.core.executor.SessionExecutor;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.core.subdocument.SplitDocument;
import com.torodb.torod.core.subdocument.SubDocAttribute;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.core.subdocument.SubDocument;
import com.torodb.torod.core.subdocument.ToroDocument;
import com.torodb.torod.core.subdocument.structure.ArrayStructure;
import com.torodb.torod.core.subdocument.structure.DocStructure;
import com.torodb.torod.core.subdocument.structure.StructureElement;
import com.torodb.torod.core.subdocument.values.ScalarNull;
import com.torodb.torod.core.subdocument.values.ScalarValue;
import com.torodb.torod.core.subdocument.values.heap.ListScalarArray;
import com.torodb.torod.core.utils.KVValueToScalarValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import javax.inject.Provider;

public class DocumentSplitter {
    private final DbMetaInformationCache cache;
    private final TypesCollector typesCollector = new TypesCollector();
    private final Provider<SubDocType.Builder> subDocTypeBuilderProvider;

    @Inject
    public DocumentSplitter(DbMetaInformationCache cache, Provider<SubDocType.Builder> subDocTypeBuilderProvider) {
        this.cache = cache;
        this.subDocTypeBuilderProvider = subDocTypeBuilderProvider;
    }

    public SplitDocument split(SessionExecutor sessionExecutor, String collection, ToroDocument doc) {
        int docId = this.cache.reserveDocIds(sessionExecutor, collection, 1);
        Map<KVDocument, SubDocType> collectedTypes = this.typesCollector.collectTypes(doc.getRoot());
        this.prepareValueTypesTables(sessionExecutor, collection, collectedTypes);
        return this.translate(doc, docId, collectedTypes);
    }

    private void prepareValueTypesTables(SessionExecutor sessionExecutor, String collection, Map<KVDocument, SubDocType> collectedTypes) {
        for (SubDocType subDocType : collectedTypes.values()) {
            this.cache.createSubDocTypeTable(sessionExecutor, collection, subDocType);
        }
    }

    private SubDocType getSubDocType(KVDocument value) {
        SubDocType.Builder builder = (SubDocType.Builder)this.subDocTypeBuilderProvider.get();
        for (KVDocument.DocEntry entry : value) {
            if (entry.getValue() instanceof KVDocument) continue;
            ScalarType type = ScalarType.fromDocType((KVType)entry.getValue().getType());
            SubDocAttribute att = new SubDocAttribute(entry.getKey(), type);
            builder.add(att);
        }
        return builder.build();
    }

    private SplitDocument translate(ToroDocument doc, int docId, Map<KVDocument, SubDocType> collectedTypes) {
        SplitDocument.Builder splitDocBuilder = new SplitDocument.Builder();
        ValueTranslator translator = new ValueTranslator(docId, splitDocBuilder, collectedTypes);
        RootTranslatorConsumer consumer = new RootTranslatorConsumer();
        doc.getRoot().accept((KVValueVisitor)translator, (Object)consumer);
        splitDocBuilder.setId(docId);
        splitDocBuilder.setRoot(consumer.getRoot());
        return splitDocBuilder.build();
    }

    private static class RootTranslatorConsumer
    implements TranslatorConsumer {
        private DocStructure root = null;

        private RootTranslatorConsumer() {
        }

        @Override
        public void consume(ScalarValue value) {
            throw new UnsupportedOperationException("A doc structure was expected.");
        }

        @Override
        public void consume(ArrayStructure arrayStructure) {
            throw new UnsupportedOperationException("A doc structure was expected.");
        }

        @Override
        public void consume(DocStructure structure) {
            if (this.root != null) {
                throw new AssertionError((Object)"More than one root has been detected, but only one was expected");
            }
            this.root = structure;
        }

        public DocStructure getRoot() {
            return this.root;
        }
    }

    private static class ObjectTranslatorConsumer
    implements TranslatorConsumer {
        private final SubDocument.Builder subDocBuilder;
        private final DocStructure.Builder structureBuilder;
        private String attributeName;

        private ObjectTranslatorConsumer(SubDocument.Builder subDocBuilder, DocStructure.Builder structureBuilder) {
            this.subDocBuilder = subDocBuilder;
            this.structureBuilder = structureBuilder;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public void consume(ScalarValue value) {
            this.subDocBuilder.add(this.attributeName, value);
        }

        @Override
        public void consume(DocStructure structure) {
            this.structureBuilder.add(this.attributeName, (StructureElement)structure);
        }

        @Override
        public void consume(ArrayStructure arrayStructure) {
            this.structureBuilder.add(this.attributeName, (StructureElement)arrayStructure);
        }
    }

    private static class ArrayTranslatorConsumer
    implements TranslatorConsumer {
        private final List<ScalarValue<?>> valueListBuilder;
        private final ArrayStructure.Builder structureBuilder;
        private int index;

        public ArrayTranslatorConsumer(List<ScalarValue<?>> valueListBuilder, ArrayStructure.Builder structureBuilder) {
            this.valueListBuilder = valueListBuilder;
            this.structureBuilder = structureBuilder;
            this.index = 0;
        }

        @Override
        public void consume(ScalarValue value) {
            this.valueListBuilder.add(value);
        }

        @Override
        public void consume(DocStructure structure) {
            this.valueListBuilder.add((ScalarValue<?>)ScalarNull.getInstance());
            this.structureBuilder.add(this.index, (StructureElement)structure);
        }

        @Override
        public void consume(ArrayStructure arrayStructure) {
            this.structureBuilder.add(this.index, (StructureElement)arrayStructure);
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static interface TranslatorConsumer {
        public void consume(ScalarValue var1);

        public void consume(DocStructure var1);

        public void consume(ArrayStructure var1);
    }

    @NotThreadSafe
    private static class ValueTranslator
    implements KVValueVisitor<Void, TranslatorConsumer> {
        private final int docId;
        private final SplitDocument.Builder splitDocBuilder;
        private final Map<KVDocument, SubDocType> collectedTypes;
        private final Map<SubDocType, Integer> indixes;

        public ValueTranslator(int docId, SplitDocument.Builder splitDocBuilder, Map<KVDocument, SubDocType> collectedTypes) {
            this.docId = docId;
            this.splitDocBuilder = splitDocBuilder;
            this.collectedTypes = collectedTypes;
            this.indixes = Maps.newHashMapWithExpectedSize((int)collectedTypes.size());
        }

        public int consumeIndex(SubDocType type) {
            Integer index = this.indixes.get(type);
            if (index == null) {
                index = 0;
            }
            this.indixes.put(type, index + 1);
            return index;
        }

        public Void visit(KVDocument value, TranslatorConsumer arg) {
            SubDocType type = this.collectedTypes.get(value);
            DocStructure.Builder structureBuilder = new DocStructure.Builder();
            SubDocument.Builder subDocBuilder = SubDocument.Builder.withKnownType((SubDocType)type);
            int index = this.consumeIndex(type);
            structureBuilder.setIndex(index);
            structureBuilder.setType(type);
            subDocBuilder.setIndex(index);
            subDocBuilder.setDocumentId(this.docId);
            ObjectTranslatorConsumer consumer = new ObjectTranslatorConsumer(subDocBuilder, structureBuilder);
            for (KVDocument.DocEntry entry : value) {
                consumer.setAttributeName(entry.getKey());
                entry.getValue().accept((KVValueVisitor)this, (Object)consumer);
            }
            this.splitDocBuilder.add(subDocBuilder.build());
            arg.consume(structureBuilder.built());
            return null;
        }

        public Void visit(KVArray value, TranslatorConsumer arg) {
            ArrayList valueBuilder = new ArrayList(value.size());
            ArrayStructure.Builder structureBuilder = new ArrayStructure.Builder();
            ArrayTranslatorConsumer consumer = new ArrayTranslatorConsumer(valueBuilder, structureBuilder);
            int i = 0;
            for (KVValue child : value) {
                consumer.setIndex(i);
                child.accept((KVValueVisitor)this, (Object)consumer);
                ++i;
            }
            arg.consume((ScalarValue)new ListScalarArray(valueBuilder));
            arg.consume(structureBuilder.built());
            return null;
        }

        public Void visit(KVBoolean value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVNull value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVInteger value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVLong value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVDouble value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVString value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVMongoObjectId value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVMongoTimestamp value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVInstant value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVDate value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVTime value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }

        public Void visit(KVBinary value, TranslatorConsumer arg) {
            arg.consume((ScalarValue)KVValueToScalarValue.AS_VISITOR.visit(value, null));
            return null;
        }
    }

    private class TypesCollector
    extends KVValueDFW<Map<KVDocument, SubDocType>> {
        private TypesCollector() {
        }

        public Map<KVDocument, SubDocType> collectTypes(KVDocument value) {
            HashMap calculatedTypes = Maps.newHashMap();
            value.accept((KVValueVisitor)this, (Object)calculatedTypes);
            return calculatedTypes;
        }

        protected void preDoc(KVDocument value, Map<KVDocument, SubDocType> types) {
            SubDocType subDocType = DocumentSplitter.this.getSubDocType(value);
            types.put(value, subDocType);
        }
    }
}

