/*
 * Decompiled with CFR 0.152.
 */
package com.tourapp.tour.acctrec.report.cashplan;

import com.tourapp.tour.acctrec.db.ArTrx;
import com.tourapp.tour.acctrec.report.cashplan.CalcPlanTotals;
import com.tourapp.tour.acctrec.report.cashplan.CashPlanHeading;
import com.tourapp.tour.acctrec.report.cashplan.CashPlanScreenRecord;
import com.tourapp.tour.acctrec.report.cashplan.CashPlanToolbar;
import com.tourapp.tour.acctrec.report.cashplan.ValidBookingHandler;
import com.tourapp.tour.base.db.event.CalcStartDateHandler;
import com.tourapp.tour.booking.db.Booking;
import com.tourapp.tour.booking.detail.db.BookingLine;
import java.util.Map;
import org.jbundle.base.db.Record;
import org.jbundle.base.db.ScreenRecord;
import org.jbundle.base.db.event.RecountOnValidHandler;
import org.jbundle.base.db.event.SubCountHandler;
import org.jbundle.base.db.filter.SubFileFilter;
import org.jbundle.base.field.BaseField;
import org.jbundle.base.field.BaseListener;
import org.jbundle.base.model.RecordOwner;
import org.jbundle.base.screen.model.BasePanel;
import org.jbundle.base.screen.model.BaseScreen;
import org.jbundle.base.screen.model.ToolScreen;
import org.jbundle.base.screen.model.report.AnalysisScreen;
import org.jbundle.base.screen.model.util.ScreenLocation;
import org.jbundle.model.screen.ComponentParent;
import org.jbundle.model.screen.ScreenLoc;
import org.jbundle.thin.base.db.Converter;
import org.jbundle.thin.base.db.FieldInfo;

public class CashPlanReport
extends AnalysisScreen {
    public CashPlanReport() {
    }

    public CashPlanReport(Record record, ScreenLocation itsLocation, BasePanel parentScreen, Converter fieldConverter, int iDisplayFieldDesc, Map<String, Object> properties) {
        this();
        this.init(record, itsLocation, parentScreen, fieldConverter, iDisplayFieldDesc, properties);
    }

    public void init(Record record, ScreenLocation itsLocation, BasePanel parentScreen, Converter fieldConverter, int iDisplayFieldDesc, Map<String, Object> properties) {
        super.init(record, itsLocation, parentScreen, fieldConverter, iDisplayFieldDesc, properties);
    }

    public String getTitle() {
        return "Cash Receipts Planning Report";
    }

    public Record openMainRecord() {
        return new Booking((RecordOwner)this);
    }

    public void openOtherRecords() {
        super.openOtherRecords();
        new ArTrx((RecordOwner)this);
        new BookingLine((RecordOwner)this);
    }

    public Record addScreenRecord() {
        return new CashPlanScreenRecord((RecordOwner)this);
    }

    public void addListeners() {
        super.addListeners();
        this.getMainRecord().setKeyArea("BookingDate");
        this.getMainRecord().addListener((BaseListener)new ValidBookingHandler(null));
        Record recBooking = this.getRecord("Booking");
        Record recArTrx = this.getRecord("ArTrx");
        Record recBookingLine = this.getRecord("BookingLine");
        recArTrx.addListener((BaseListener)new SubFileFilter(recBooking));
        recBooking.addListener((BaseListener)new RecountOnValidHandler(recArTrx));
        recArTrx.addListener((BaseListener)new SubCountHandler(recBooking.getField("Balance"), "AmountLocal", true, true));
        recBookingLine.addListener((BaseListener)new SubFileFilter(recBooking));
        recBooking.addListener((BaseListener)new RecountOnValidHandler(recBookingLine));
        recBookingLine.addListener((BaseListener)new SubCountHandler(recBooking.getField("Gross"), "Gross", true, true));
        recBookingLine.addListener((BaseListener)new SubCountHandler(recBooking.getField("Net"), "Net", true, true));
        recBooking.addListener((BaseListener)new CalcPlanTotals((ScreenRecord)this.getScreenRecord()));
        recBooking.addListener((BaseListener)new CalcStartDateHandler(this.getScreenRecord().getField("DepositPeriodDate"), recBooking.getField("DepositDueDate"), this.getScreenRecord().getField("StartDate"), this.getScreenRecord().getField("PeriodType"), this.getScreenRecord().getField("PeriodLength")));
        recBooking.addListener((BaseListener)new CalcStartDateHandler(this.getScreenRecord().getField("FinalPeriodDate"), recBooking.getField("FinalPaymentDueDate"), this.getScreenRecord().getField("StartDate"), this.getScreenRecord().getField("PeriodType"), this.getScreenRecord().getField("PeriodLength")));
    }

    public ToolScreen addToolbars() {
        return new CashPlanToolbar(null, (BasePanel)this, null, 2, null);
    }

    public void setupSFields() {
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("FromDate").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("Deposits").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("Receipts").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("FinalPayments").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("FinalReceipts").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
        this.getRecord(CashPlanScreenRecord.CASH_PLAN_SCREEN_RECORD_FILE).getField("Balance").setupDefaultView((ScreenLoc)this.getNextLocation((short)1, (short)1), (ComponentParent)this, 4);
    }

    public BaseScreen addReportHeading() {
        return new CashPlanHeading(null, null, (BasePanel)this, null, 2, null);
    }

    public void addSummary(Record recSummary, BaseField[][] mxKeyFields, BaseField[][] mxDataFields) {
        this.getScreenRecord().getField("FromDate").moveFieldToThis((FieldInfo)this.getScreenRecord().getField("DepositPeriodDate"));
        this.getScreenRecord().getField("Deposits").moveFieldToThis((FieldInfo)this.getRecord("Booking").getField("Deposit"));
        this.getScreenRecord().getField("Receipts").moveFieldToThis((FieldInfo)this.getScreenRecord().getField("DepositDueBalance"));
        this.getScreenRecord().getField("FinalPayments").initField(true);
        this.getScreenRecord().getField("FinalReceipts").initField(true);
        this.getScreenRecord().getField("Balance").initField(true);
        super.addSummary(recSummary, mxKeyFields, mxDataFields);
        this.getScreenRecord().getField("FromDate").moveFieldToThis((FieldInfo)this.getScreenRecord().getField("FinalPeriodDate"));
        this.getScreenRecord().getField("Deposits").initField(true);
        this.getScreenRecord().getField("Receipts").initField(true);
        this.getScreenRecord().getField("FinalPayments").moveFieldToThis((FieldInfo)this.getRecord("Booking").getField("FinalPaymentDueDate"));
        this.getScreenRecord().getField("FinalReceipts").moveFieldToThis((FieldInfo)this.getScreenRecord().getField("FinalDueLessDeposit"));
        this.getScreenRecord().getField("Balance").moveFieldToThis((FieldInfo)this.getScreenRecord().getField("FinalDueLessDepPymt"));
        super.addSummary(recSummary, mxKeyFields, mxDataFields);
    }
}

