/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.autoconfigure;

import com.rabbitmq.client.Channel;
import com.tradeshift.amqp.annotation.EnableRabbitRetryAndDlqAspect;
import com.tradeshift.amqp.rabbit.annotation.TunedRabbitListenerAnnotationBeanPostProcessor;
import com.tradeshift.amqp.rabbit.components.QueueFactory;
import com.tradeshift.amqp.rabbit.components.RabbitComponentsFactory;
import com.tradeshift.amqp.rabbit.handlers.RabbitAdminHandler;
import com.tradeshift.amqp.rabbit.handlers.RabbitTemplateHandler;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitPropertiesBindHandlerAdvisor;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitPropertiesMap;
import com.tradeshift.amqp.rabbit.retry.QueueRetryComponent;
import com.tradeshift.amqp.resolvers.RabbitBeanNameResolver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={TunedRabbitPropertiesMap.class})
@Configuration
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class})
@Import(value={RabbitPostProcessorConfiguration.class, TunedRabbitPropertiesBindHandlerAdvisor.class})
public class TunedRabbitAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TunedRabbitAutoConfiguration.class);
    private Set<String> virtualHosts = new HashSet<String>();
    private Set<String> portAndHost = new HashSet<String>();
    private final ApplicationContext applicationContext;
    private final ConfigurableListableBeanFactory beanFactory;

    @Autowired
    public TunedRabbitAutoConfiguration(ApplicationContext applicationContext, ConfigurableListableBeanFactory beanFactory) {
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"tsRabbitConnectionFactory"})
    public RabbitTemplateHandler rabbitTemplateHandler(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new RabbitTemplateHandler(this.applicationContext, rabbitCustomPropertiesMap);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @DependsOn(value={"tsRabbitConnectionFactory"})
    public RabbitAdminHandler rabbitAdminHandler(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new RabbitAdminHandler(this.applicationContext, rabbitCustomPropertiesMap);
    }

    @Bean(value={"rabbitTemplateHandler"})
    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="false")
    public RabbitTemplateHandler rabbitTemplateHandlerWithoutAutoConfig(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new RabbitTemplateHandler(this.applicationContext, rabbitCustomPropertiesMap);
    }

    @Bean(value={"rabbitAdminHandler"})
    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="false")
    public RabbitAdminHandler rabbitAdminHandlerWithoutAutoConfig(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new RabbitAdminHandler(this.applicationContext, rabbitCustomPropertiesMap);
    }

    @Bean
    @DependsOn(value={"rabbitTemplateHandler"})
    public QueueRetryComponent queueRetryComponent(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new QueueRetryComponent(this.rabbitTemplateHandler(rabbitCustomPropertiesMap));
    }

    @Bean
    @DependsOn(value={"queueRetryComponent"})
    public EnableRabbitRetryAndDlqAspect enableRabbitRetryAndDlqAspect(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        return new EnableRabbitRetryAndDlqAspect(this.queueRetryComponent(rabbitCustomPropertiesMap), rabbitCustomPropertiesMap);
    }

    @Bean
    public RabbitComponentsFactory rabbitComponentsFactory() {
        return new RabbitComponentsFactory();
    }

    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @Bean
    @DependsOn(value={"rabbitComponentsFactory"})
    public MessageConverter producerJackson2MessageConverter() {
        return this.rabbitComponentsFactory().createJackson2MessageConverter();
    }

    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @Primary
    @Bean(value={"tsRabbitConnectionFactory"})
    @DependsOn(value={"producerJackson2MessageConverter", "rabbitComponentsFactory"})
    public ConnectionFactory routingConnectionFactory(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        this.validateSinglePrimaryConnection(rabbitCustomPropertiesMap);
        AtomicReference<ConnectionFactory> defaultConnectionFactory = new AtomicReference<ConnectionFactory>();
        HashMap<Object, ConnectionFactory> connectionFactoryHashMap = new HashMap<Object, ConnectionFactory>();
        rabbitCustomPropertiesMap.forEach((eventName, properties) -> {
            properties.setEventName((String)eventName);
            ConnectionFactory connectionFactory = this.createRabbitMQArch((TunedRabbitProperties)properties);
            connectionFactoryHashMap.put(RabbitBeanNameResolver.getConnectionFactoryBeanName(properties.getVirtualHost(), properties.getHost(), properties.getPort()), connectionFactory);
            if (properties.isPrimary()) {
                defaultConnectionFactory.set(connectionFactory);
            }
        });
        if (Objects.isNull(defaultConnectionFactory.get())) {
            Optional first = connectionFactoryHashMap.values().stream().findFirst();
            first.ifPresent(defaultConnectionFactory::set);
        }
        return this.rabbitComponentsFactory().createSimpleRoutingConnectionFactory(defaultConnectionFactory, connectionFactoryHashMap);
    }

    private void validateSinglePrimaryConnection(TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        long primary = rabbitCustomPropertiesMap.stream().filter(stringQueuePropertiesEntry -> ((TunedRabbitProperties)stringQueuePropertiesEntry.getValue()).isPrimary()).count();
        if (primary > 1L) {
            throw new IllegalArgumentException("Only one primary RabbitMQ architecture is allowed!");
        }
    }

    private ConnectionFactory createRabbitMQArch(TunedRabbitProperties property) {
        String virtualHost = RabbitBeanNameResolver.treatVirtualHostName(property.getVirtualHost());
        if (!this.portAndHost.contains(property.getPort() + property.getHost())) {
            this.applyAutoConfiguration(property);
        } else if (!this.virtualHosts.contains(virtualHost)) {
            this.applyAutoConfiguration(property);
        } else {
            this.applyAutoConfigurationOnlyForBinding(property);
        }
        return (CachingConnectionFactory)this.applicationContext.getBean(RabbitBeanNameResolver.getConnectionFactoryBeanName(property.getVirtualHost(), property.getHost(), property.getPort()));
    }

    private void applyAutoConfiguration(TunedRabbitProperties property) {
        RabbitComponentsFactory rabbitComponentsFactory = this.rabbitComponentsFactory();
        String virtualHost = RabbitBeanNameResolver.treatVirtualHostName(property.getVirtualHost());
        CachingConnectionFactory connectionsFactoryBean = rabbitComponentsFactory.createCachingConnectionFactory(property, virtualHost);
        Optional.ofNullable(connectionsFactoryBean).ifPresent(connectionFactory -> {
            String connectionFactoryBeanName = RabbitBeanNameResolver.getConnectionFactoryBeanName(virtualHost, property.getHost(), property.getPort());
            this.beanFactory.registerSingleton(connectionFactoryBeanName, connectionFactory);
            log.info("ConnectionFactory Bean with name {} was created for the event {} and virtual host {}", new Object[]{connectionFactoryBeanName, property.getEventName(), virtualHost});
            String listenerContainerFactoryBeanName = RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(virtualHost, property.getHost(), property.getPort());
            SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactoryBeanDef = rabbitComponentsFactory.createSimpleRabbitListenerContainerFactoryBean(property, (CachingConnectionFactory)connectionFactory);
            this.beanFactory.registerSingleton(listenerContainerFactoryBeanName, (Object)simpleRabbitListenerContainerFactoryBeanDef);
            log.info("SimpleRabbitListenerContainerFactory Bean with name {} was created for the event {} and virtual host {}", new Object[]{listenerContainerFactoryBeanName, property.getEventName(), virtualHost});
            RabbitAdmin beanDefinitionRabbitAdmin = rabbitComponentsFactory.createRabbitAdminBean((CachingConnectionFactory)connectionFactory);
            String rabbitAdminBeanName = RabbitBeanNameResolver.getRabbitAdminBeanName(virtualHost, property.getHost(), property.getPort());
            this.beanFactory.registerSingleton(rabbitAdminBeanName, (Object)beanDefinitionRabbitAdmin);
            log.info("RabbitAdmin Bean with name {} was created for the event {} and virtual host {}", new Object[]{rabbitAdminBeanName, property.getEventName(), virtualHost});
            RabbitTemplate beanDefinitionRabbitTemplate = rabbitComponentsFactory.createRabbitTemplateBean((CachingConnectionFactory)connectionFactory, property);
            String rabbitTemplateBeanName = RabbitBeanNameResolver.getRabbitTemplateBeanName(virtualHost, property.getHost(), property.getPort());
            this.beanFactory.registerSingleton(rabbitTemplateBeanName, (Object)beanDefinitionRabbitTemplate);
            log.info("RabbitTemplate Bean with name {} was created for the event {} and virtual host {}", new Object[]{rabbitTemplateBeanName, property.getEventName(), virtualHost});
            this.virtualHosts.add(virtualHost);
            this.portAndHost.add(property.getPort() + property.getHost());
            if (property.isAutoCreate() || property.isAutoCreateOnlyForTest() && this.isTestProfile()) {
                this.autoCreateQueues(property, beanDefinitionRabbitAdmin);
            }
        });
    }

    private void applyAutoConfigurationOnlyForBinding(TunedRabbitProperties properties) {
        String virtualHost = RabbitBeanNameResolver.treatVirtualHostName(properties.getVirtualHost());
        String rabbitAdminBeanName = RabbitBeanNameResolver.getRabbitAdminBeanName(virtualHost, properties.getHost(), properties.getPort());
        log.info("Getting RabbitAdmin Bean with name {} for the event {} and virtual host {}", new Object[]{rabbitAdminBeanName, properties.getEventName(), virtualHost});
        RabbitAdmin rabbitAdmin = (RabbitAdmin)this.beanFactory.getBean(rabbitAdminBeanName, RabbitAdmin.class);
        if (properties.isAutoCreate() || properties.isAutoCreateOnlyForTest() && this.isTestProfile()) {
            this.autoCreateQueues(properties, rabbitAdmin);
        }
    }

    private void autoCreateQueues(TunedRabbitProperties properties, RabbitAdmin rabbitAdmin) {
        QueueFactory queueFactory = new QueueFactory(properties, rabbitAdmin);
        queueFactory.create();
    }

    private boolean isTestProfile() {
        return Arrays.asList(this.applicationContext.getEnvironment().getActiveProfiles()).contains("test");
    }

    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @Configuration
    @EnableRabbit
    static class EnableRabbitConfiguration {
        EnableRabbitConfiguration() {
        }

        @Bean(name={"org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor"})
        public static RabbitListenerAnnotationBeanPostProcessor rabbitListenerAnnotationProcessor() {
            return new TunedRabbitListenerAnnotationBeanPostProcessor();
        }
    }

    @ConditionalOnProperty(value={"spring.rabbitmq.enable.custom.autoconfiguration"}, havingValue="true", matchIfMissing=true)
    @Configuration
    static class RabbitPostProcessorConfiguration {
        RabbitPostProcessorConfiguration() {
        }

        @Bean(name={"org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor"})
        @DependsOn(value={"tsRabbitConnectionFactory"})
        public static RabbitListenerAnnotationBeanPostProcessor rabbitListenerAnnotationProcessor() {
            return new TunedRabbitListenerAnnotationBeanPostProcessor();
        }
    }
}

