/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.components;

import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;

public class QueueFactory {
    private static final String DIRECT = "direct";
    private static final String FANOUT = "fanout";
    private static final String TOPIC = "topic";
    private TunedRabbitProperties properties;
    private RabbitAdmin rabbitAdmin;

    public QueueFactory(TunedRabbitProperties properties, RabbitAdmin rabbitAdmin) {
        this.properties = properties;
        this.rabbitAdmin = rabbitAdmin;
    }

    public void create() {
        TopicExchange exchange = new TopicExchange(this.properties.getExchange(), true, false);
        if (this.isADirectExchange(this.properties)) {
            exchange = new DirectExchange(this.properties.getExchange(), true, false);
        } else if (this.isAFanoutExchange(this.properties)) {
            exchange = new FanoutExchange(this.properties.getExchange(), true, false);
        }
        Queue queue = QueueBuilder.durable((String)this.properties.getQueue()).build();
        this.rabbitAdmin.declareExchange((Exchange)exchange);
        this.rabbitAdmin.declareQueue(queue);
        this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to((Exchange)exchange).with(this.properties.getQueueRoutingKey()).noargs());
        if (this.properties.isAutoCreateForRetryDlq() && this.isAValidExchange(this.properties)) {
            Queue dlq = QueueBuilder.durable((String)this.properties.getQueueDlq()).build();
            Queue retry = QueueBuilder.durable((String)this.properties.getQueueRetry()).withArgument("x-dead-letter-exchange", (Object)this.properties.getExchange()).withArgument("x-dead-letter-routing-key", (Object)this.properties.getQueueRoutingKey()).build();
            this.rabbitAdmin.declareQueue(dlq);
            this.rabbitAdmin.declareQueue(retry);
            this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)retry).to((Exchange)exchange).with(this.properties.getQueueRetry()).noargs());
            this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)dlq).to((Exchange)exchange).with(this.properties.getQueueDlq()).noargs());
        }
    }

    private boolean isAValidExchange(TunedRabbitProperties properties) {
        return this.isADirectExchange(properties) || this.isATopicExchange(properties);
    }

    private boolean isATopicExchange(TunedRabbitProperties properties) {
        return TOPIC.equals(properties.getExchangeType());
    }

    private boolean isADirectExchange(TunedRabbitProperties properties) {
        return DIRECT.equals(properties.getExchangeType());
    }

    private boolean isAFanoutExchange(TunedRabbitProperties properties) {
        return FANOUT.equals(properties.getExchangeType());
    }
}

