/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.properties;

import org.springframework.boot.context.properties.ConfigurationPropertiesBindHandlerAdvisor;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.validation.ValidationBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.stereotype.Component;
import org.springframework.validation.Validator;

@Component
public class TunedRabbitPropertiesBindHandlerAdvisor
implements ConfigurationPropertiesBindHandlerAdvisor {
    public BindHandler apply(final BindHandler bindHandler) {
        return new ValidationBindHandler(new Validator[0]){

            public <T> Bindable<T> onStart(ConfigurationPropertyName name, Bindable<T> target, BindContext context) {
                BindResult result;
                ConfigurationPropertyName defaultName = TunedRabbitPropertiesBindHandlerAdvisor.this.findDefaultName(name);
                if (defaultName != null && (result = context.getBinder().bind(defaultName, target)).isBound()) {
                    return target.withExistingValue(result.get());
                }
                return bindHandler.onStart(name, target, context);
            }
        };
    }

    private ConfigurationPropertyName findDefaultName(ConfigurationPropertyName name) {
        ConfigurationPropertyName from = ConfigurationPropertyName.of((CharSequence)"spring.rabbitmq.custom");
        ConfigurationPropertyName to = ConfigurationPropertyName.of((CharSequence)"spring.rabbitmq.custom.shared");
        if (from.isAncestorOf(name) && name.getNumberOfElements() > from.getNumberOfElements()) {
            ConfigurationPropertyName defaultName = to;
            for (int i = from.getNumberOfElements() + 1; i < name.getNumberOfElements(); ++i) {
                defaultName = defaultName.append(name.getElement(i, ConfigurationPropertyName.Form.UNIFORM));
            }
            return defaultName;
        }
        return null;
    }
}

