/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.resolvers;

import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import java.util.Optional;
import java.util.stream.Stream;

public class RabbitBeanNameResolver {
    private RabbitBeanNameResolver() {
    }

    public static String getConnectionFactoryBeanNameForDefaultVirtualHost(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getConnectionFactoryBeanName(null, customRabbitProperties.getHost(), customRabbitProperties.getPort());
    }

    public static String getConnectionFactoryBeanNameForDefaultVirtualHost(String host, int port) {
        return RabbitBeanNameResolver.getConnectionFactoryBeanName(null, host, port);
    }

    public static String getConnectionFactoryBeanName(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getConnectionFactoryBeanName(customRabbitProperties.getVirtualHost(), customRabbitProperties.getHost() + customRabbitProperties.getPort());
    }

    public static String getConnectionFactoryBeanName(String virtualHost, String host, int port) {
        return RabbitBeanNameResolver.getConnectionFactoryBeanName(virtualHost, host + port);
    }

    public static String getConnectionFactoryBeanName(String virtualHost, String hostAndPort) {
        return RabbitBeanNameResolver.getConnectionFactoryBeanName(RabbitBeanNameResolver.treatVirtualHostName(virtualHost) + "_" + hostAndPort);
    }

    protected static String getConnectionFactoryBeanName(String virtualHostHostAndPort) {
        return "connectionFactory" + RabbitBeanNameResolver.convertSnakeCaseToCamelCase(virtualHostHostAndPort);
    }

    public static String getRabbitTemplateBeanNameForDefaultVirtualHost(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getRabbitTemplateBeanName(null, customRabbitProperties.getHost(), customRabbitProperties.getPort());
    }

    public static String getRabbitTemplateBeanNameForDefaultVirtualHost(String host, int port) {
        return RabbitBeanNameResolver.getRabbitTemplateBeanName(null, host, port);
    }

    public static String getRabbitTemplateBeanName(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getRabbitTemplateBeanName(customRabbitProperties.getVirtualHost(), customRabbitProperties.getHost() + customRabbitProperties.getPort());
    }

    public static String getRabbitTemplateBeanName(String virtualHost, String host, int port) {
        return RabbitBeanNameResolver.getRabbitTemplateBeanName(virtualHost, host + port);
    }

    public static String getRabbitTemplateBeanName(String virtualHost, String hostAndPort) {
        return RabbitBeanNameResolver.getRabbitTemplateBeanName(RabbitBeanNameResolver.treatVirtualHostName(virtualHost) + "_" + hostAndPort);
    }

    protected static String getRabbitTemplateBeanName(String virtualHostHostAndPort) {
        return "rabbitTemplate" + RabbitBeanNameResolver.convertSnakeCaseToCamelCase(virtualHostHostAndPort);
    }

    public static String getRabbitAdminBeanNameForDefaultVirtualHost(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getRabbitAdminBeanName(null, customRabbitProperties.getHost(), customRabbitProperties.getPort());
    }

    public static String getRabbitAdminBeanNameForDefaultVirtualHost(String host, int port) {
        return RabbitBeanNameResolver.getRabbitAdminBeanName(null, host, port);
    }

    public static String getRabbitAdminBeanName(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getRabbitAdminBeanName(customRabbitProperties.getVirtualHost(), customRabbitProperties.getHost() + customRabbitProperties.getPort());
    }

    public static String getRabbitAdminBeanName(String virtualHost, String host, int port) {
        return RabbitBeanNameResolver.getRabbitAdminBeanName(virtualHost, host + port);
    }

    public static String getRabbitAdminBeanName(String virtualHost, String hostAndPort) {
        return RabbitBeanNameResolver.getRabbitAdminBeanName(RabbitBeanNameResolver.treatVirtualHostName(virtualHost) + "_" + hostAndPort, true);
    }

    public static String getRabbitAdminBeanName(String virtualHostHostAndPort, boolean convertFromSnakeCase) {
        if (convertFromSnakeCase) {
            return "rabbitAdmin" + RabbitBeanNameResolver.convertSnakeCaseToCamelCase(virtualHostHostAndPort);
        }
        return "rabbitAdmin" + virtualHostHostAndPort;
    }

    public static String getSimpleRabbitListenerContainerFactoryBeanForDefaultVirtualHost(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(null, customRabbitProperties.getHost(), customRabbitProperties.getPort());
    }

    public static String getSimpleRabbitListenerContainerFactoryBeanForDefaultVirtualHost(String host, int port) {
        return RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(null, host, port);
    }

    public static String getSimpleRabbitListenerContainerFactoryBean(TunedRabbitProperties customRabbitProperties) {
        return RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(customRabbitProperties.getVirtualHost(), customRabbitProperties.getHost() + customRabbitProperties.getPort());
    }

    public static String getSimpleRabbitListenerContainerFactoryBean(String virtualHost, String host, int port) {
        return RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(virtualHost, host + port);
    }

    protected static String getSimpleRabbitListenerContainerFactoryBean(String virtualHost, String hostAndPort) {
        return RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(RabbitBeanNameResolver.treatVirtualHostName(virtualHost) + "_" + hostAndPort);
    }

    protected static String getSimpleRabbitListenerContainerFactoryBean(String virtualHostHostAndPort) {
        return "containerFactory" + RabbitBeanNameResolver.convertSnakeCaseToCamelCase(virtualHostHostAndPort);
    }

    public static String treatVirtualHostName(String virtualHost) {
        return Optional.ofNullable(virtualHost).orElse("Default");
    }

    protected static String convertSnakeCaseToCamelCase(String text) {
        StringBuilder sb = new StringBuilder();
        Stream.of(text.split("_")).forEach(s -> {
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1) {
                sb.append(s.substring(1, s.length()).toLowerCase());
            }
        });
        return sb.toString();
    }
}

