/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.annotation;

import com.tradeshift.amqp.annotation.TunedRabbitListener;
import com.tradeshift.amqp.rabbit.handlers.RabbitAdminHandler;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitPropertiesMap;
import com.tradeshift.amqp.resolvers.RabbitBeanNameResolver;
import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TunedRabbitListenerAnnotationBeanPostProcessor
extends RabbitListenerAnnotationBeanPostProcessor
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    protected Collection<Declarable> processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        TunedRabbitPropertiesMap tunedRabbitPropertiesMap = (TunedRabbitPropertiesMap)this.applicationContext.getBean(TunedRabbitPropertiesMap.class);
        TunedRabbitProperties tunedRabbitProperties = (TunedRabbitProperties)tunedRabbitPropertiesMap.get(rabbitListener.containerFactory());
        TunedRabbitListener tunedRabbitListener = new TunedRabbitListener(rabbitListener);
        tunedRabbitListener.setContainerFactory(RabbitBeanNameResolver.getSimpleRabbitListenerContainerFactoryBean(tunedRabbitProperties));
        Collection declarable = super.processAmqpListener((RabbitListener)tunedRabbitListener, method, bean, beanName);
        this.enhanceBeansWithReferenceToRabbitAdmin(tunedRabbitProperties);
        return declarable;
    }

    private void enhanceBeansWithReferenceToRabbitAdmin(TunedRabbitProperties tunedRabbitProperties) {
        RabbitAdmin rabbitAdmin = this.getRabbitAdminBean(tunedRabbitProperties);
        this.applicationContext.getBeansOfType(AbstractExchange.class).values().stream().filter(this::isNotProcessed).forEach(exchange -> exchange.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
        this.applicationContext.getBeansOfType(Queue.class).values().stream().filter(this::isNotProcessed).forEach(queue -> queue.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
        this.applicationContext.getBeansOfType(Binding.class).values().stream().filter(this::isNotProcessed).forEach(binding -> binding.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin != null ? rabbitAdmin : this}));
    }

    private RabbitAdmin getRabbitAdminBean(TunedRabbitProperties tunedRabbitProperties) {
        return ((RabbitAdminHandler)this.applicationContext.getBean("rabbitAdminHandler")).getRabbitAdmin(tunedRabbitProperties);
    }

    private boolean isNotProcessed(Declarable declarable) {
        return declarable.getDeclaringAdmins() == null || declarable.getDeclaringAdmins().stream().noneMatch(item -> item == this) && declarable.getDeclaringAdmins().stream().noneMatch(item -> item instanceof RabbitAdmin);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

