/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.handlers;

import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitPropertiesMap;
import com.tradeshift.amqp.resolvers.RabbitBeanNameResolver;
import java.util.Map;
import java.util.Objects;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RabbitTemplateHandler {
    private final ApplicationContext context;
    private final TunedRabbitPropertiesMap rabbitCustomPropertiesMap;

    @Autowired
    public RabbitTemplateHandler(ApplicationContext context, TunedRabbitPropertiesMap rabbitCustomPropertiesMap) {
        this.context = context;
        this.rabbitCustomPropertiesMap = rabbitCustomPropertiesMap;
    }

    public RabbitTemplate getRabbitTemplate(String eventName) {
        TunedRabbitProperties customRabbitProperties = (TunedRabbitProperties)this.rabbitCustomPropertiesMap.get(eventName);
        if (Objects.isNull(customRabbitProperties)) {
            throw new NoSuchBeanDefinitionException("No bean available for property " + eventName);
        }
        return this.getRabbitTemplate(customRabbitProperties);
    }

    public RabbitTemplate getRabbitTemplate(TunedRabbitProperties customRabbitProperties) {
        String property = this.context.getEnvironment().getProperty("spring.rabbitmq.enable.custom.autoconfiguration");
        if (Objects.nonNull(property) && !Boolean.getBoolean(property)) {
            Map beansOfType = this.context.getBeansOfType(RabbitTemplate.class);
            if (beansOfType.size() == 0) {
                throw new NoSuchBeanDefinitionException("No RabbitTemplate bean available. Are you sure that you want to disable the autoconfiguration?");
            }
            if (beansOfType.size() > 1) {
                if (StringUtils.isEmpty((Object)customRabbitProperties.getRabbitTemplateBeanName())) {
                    throw new BeanDefinitionValidationException("There are more than 1 RabbitTemplate available. You need to specify the name of the RabbitTemplate that we will use for this event");
                }
                return (RabbitTemplate)this.context.getBean(customRabbitProperties.getRabbitTemplateBeanName());
            }
            return (RabbitTemplate)beansOfType.entrySet().iterator().next().getValue();
        }
        String beanName = RabbitBeanNameResolver.getRabbitTemplateBeanName(customRabbitProperties);
        return (RabbitTemplate)this.context.getBean(beanName);
    }
}

