/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.properties;

import java.util.Objects;
import org.springframework.core.io.Resource;

public class TunedRabbitProperties {
    private boolean clusterMode = false;
    private String hosts = null;
    private String host = "localhost";
    private int port = 5672;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost;
    private String eventName;
    private Integer ttlRetryMessage = 5000;
    private Integer maxRetriesAttempts = 3;
    private Integer ttlMultiply = 0;
    private String queueRoutingKey;
    private String exchange;
    private String exchangeType;
    private String queue;
    private String queueRetry;
    private String queueDlq;
    private boolean defaultRetryDlq = true;
    private boolean autoCreate;
    private boolean autoCreateForRetryDlq = true;
    private boolean automaticRecovery;
    private Integer concurrentConsumers = 1;
    private Integer maxConcurrentConsumers = 1;
    private Resource tlsKeystoreLocation;
    private String tlsKeystorePassword;
    private boolean primary;
    private boolean sslConnection;
    private boolean autoCreateOnlyForTest;
    private boolean enableJsonMessageConverter;
    private boolean enableSnakeCaseForQueuesAndExchangeNames;
    private String rabbitTemplateBeanName;
    private boolean enableLogs = true;

    public String getQueueRetry() {
        return this.validateSnakeCase(this.defaultRetryDlq && Objects.isNull(this.queueRetry) ? this.queue + ".retry" : this.queueRetry);
    }

    public String getQueueDlq() {
        return this.validateSnakeCase(this.defaultRetryDlq && Objects.isNull(this.queueDlq) ? this.queue + ".dlq" : this.queueDlq);
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Integer getTtlRetryMessage() {
        return this.ttlRetryMessage;
    }

    public void setTtlRetryMessage(Integer ttlRetryMessage) {
        this.ttlRetryMessage = ttlRetryMessage;
    }

    public Integer getMaxRetriesAttempts() {
        return this.maxRetriesAttempts;
    }

    public void setMaxRetriesAttempts(Integer maxRetriesAttempts) {
        this.maxRetriesAttempts = maxRetriesAttempts;
    }

    public String getQueueRoutingKey() {
        return this.queueRoutingKey;
    }

    public void setQueueRoutingKey(String queueRoutingKey) {
        this.queueRoutingKey = queueRoutingKey;
    }

    public String getExchange() {
        return this.validateSnakeCase(this.exchange);
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getQueue() {
        return this.validateSnakeCase(this.queue);
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setQueueRetry(String queueRetry) {
        this.queueRetry = queueRetry;
    }

    public void setQueueDlq(String queueDlq) {
        this.queueDlq = queueDlq;
    }

    public boolean isDefaultRetryDlq() {
        return this.defaultRetryDlq;
    }

    public void setDefaultRetryDlq(boolean defaultRetryDlq) {
        this.defaultRetryDlq = defaultRetryDlq;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isAutomaticRecovery() {
        return this.automaticRecovery;
    }

    public void setAutomaticRecovery(boolean automaticRecovery) {
        this.automaticRecovery = automaticRecovery;
    }

    public Integer getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Integer getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public Resource getTlsKeystoreLocation() {
        return this.tlsKeystoreLocation;
    }

    public void setTlsKeystoreLocation(Resource tlsKeystoreLocation) {
        this.tlsKeystoreLocation = tlsKeystoreLocation;
    }

    public String getTlsKeystorePassword() {
        return this.tlsKeystorePassword;
    }

    public void setTlsKeystorePassword(String tlsKeystorePassword) {
        this.tlsKeystorePassword = tlsKeystorePassword;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean isSslConnection() {
        return this.sslConnection;
    }

    public void setSslConnection(boolean sslConnection) {
        this.sslConnection = sslConnection;
    }

    public boolean isAutoCreateOnlyForTest() {
        return this.autoCreateOnlyForTest;
    }

    public void setAutoCreateOnlyForTest(boolean autoCreateOnlyForTest) {
        this.autoCreateOnlyForTest = autoCreateOnlyForTest;
    }

    public Integer getTtlMultiply() {
        return this.ttlMultiply;
    }

    public void setTtlMultiply(Integer ttlMultiply) {
        this.ttlMultiply = ttlMultiply;
    }

    public boolean isEnableJsonMessageConverter() {
        return this.enableJsonMessageConverter;
    }

    public void setEnableJsonMessageConverter(boolean enableJsonMessageConverter) {
        this.enableJsonMessageConverter = enableJsonMessageConverter;
    }

    public boolean isEnableSnakeCaseForQueuesAndExchangeNames() {
        return this.enableSnakeCaseForQueuesAndExchangeNames;
    }

    public void setEnableSnakeCaseForQueuesAndExchangeNames(boolean enableSnakeCaseForQueuesAndExchangeNames) {
        this.enableSnakeCaseForQueuesAndExchangeNames = enableSnakeCaseForQueuesAndExchangeNames;
    }

    public boolean isAutoCreateForRetryDlq() {
        return this.autoCreateForRetryDlq;
    }

    public void setAutoCreateForRetryDlq(boolean autoCreateForRetryDlq) {
        this.autoCreateForRetryDlq = autoCreateForRetryDlq;
    }

    public String getRabbitTemplateBeanName() {
        return this.rabbitTemplateBeanName;
    }

    public void setRabbitTemplateBeanName(String rabbitTemplateBeanName) {
        this.rabbitTemplateBeanName = rabbitTemplateBeanName;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    private String validateSnakeCase(String string) {
        return this.enableSnakeCaseForQueuesAndExchangeNames ? string.replace('.', '_') : string.replace('_', '.');
    }

    public boolean isEnableLogs() {
        return this.enableLogs;
    }

    public void setEnableLogs(boolean enableLogs) {
        this.enableLogs = enableLogs;
    }
}

