/*
 * Decompiled with CFR 0.152.
 */
package com.tradeshift.amqp.rabbit.retry;

import com.tradeshift.amqp.log.TunedLogger;
import com.tradeshift.amqp.rabbit.handlers.RabbitTemplateHandler;
import com.tradeshift.amqp.rabbit.properties.TunedRabbitProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueueRetryComponent {
    private static final TunedLogger log = TunedLogger.init(QueueRetryComponent.class);
    private static final String X_DEATH = "x-death";
    private final RabbitTemplateHandler rabbitTemplateHandler;

    @Autowired
    public QueueRetryComponent(RabbitTemplateHandler rabbitTemplateHandler) {
        this.rabbitTemplateHandler = rabbitTemplateHandler;
    }

    public void sendToRetryOrDlq(Message message, TunedRabbitProperties properties) {
        Integer qtyRetry = this.countDeath(message);
        if (qtyRetry > properties.getMaxRetriesAttempts()) {
            this.sendToDlq(message, properties);
        } else {
            this.sendToRetry(message, properties, qtyRetry);
        }
    }

    public void sendToRetry(Message message, TunedRabbitProperties properties, Integer qtdRetry) {
        message.getMessageProperties().setExpiration(String.valueOf(this.calculateTtl(properties.getTtlRetryMessage(), qtdRetry, properties.getTtlMultiply())));
        this.rabbitTemplateHandler.getRabbitTemplate(properties).send(properties.getExchange(), properties.getQueueRetry(), message);
        log.info(properties, "M=sendToRetry, Message={}", message);
    }

    public void sendToDlq(Message message, TunedRabbitProperties properties) {
        message.getMessageProperties().getHeaders().remove(X_DEATH);
        this.rabbitTemplateHandler.getRabbitTemplate(properties).send(properties.getExchange(), properties.getQueueDlq(), message);
        log.info(properties, "M=sendToDlq, Message={}", message);
    }

    public int countDeath(Message message) {
        int count = 0;
        Map headers = message.getMessageProperties().getHeaders();
        if (headers.containsKey(X_DEATH)) {
            count = Integer.parseInt(this.getXDeath(headers).get("count").toString());
        }
        return ++count;
    }

    protected Map getXDeath(Map<String, Object> headers) {
        List list = (List)Collections.singletonList(headers.get(X_DEATH)).get(0);
        return (Map)list.get(0);
    }

    public int calculateTtl(Integer ttlRetry, Integer qtdRetry, Integer ttlMultiply) {
        AtomicInteger expiration = new AtomicInteger(ttlRetry);
        if (!ttlMultiply.equals(0) && qtdRetry > 1) {
            IntStream.range(1, qtdRetry).forEach(value -> expiration.set(expiration.get() * ttlMultiply));
        }
        return expiration.get();
    }
}

