/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.util.TestDeviceUtil;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PangleInitManager
extends TPInitMediation {
    private static final String TAG = "Pangle";
    private static PangleInitManager sInstance;
    private String appId;
    private int ischild = 0;
    private boolean ccpa = true;

    public static synchronized PangleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new PangleInitManager();
        }
        return sInstance;
    }

    private void setPrivacyLaws(Map<String, Object> userParams) {
        if (userParams.containsKey("COPPA")) {
            boolean coppa = (Boolean)userParams.get("COPPA");
            if (coppa) {
                this.ischild = 1;
            }
            Log.i((String)"privacylaws", (String)("coppa: " + coppa));
        }
        if (userParams.containsKey("CCPA")) {
            this.ccpa = (Boolean)userParams.get("CCPA");
            Log.i((String)"privacylaws", (String)("ccpa: " + this.ccpa));
        }
    }

    private PAGConfig buildNewConfig(Map<String, Object> userParams, String appId) {
        if (userParams != null && userParams.size() > 0) {
            this.setPrivacyLaws(userParams);
        }
        String mediationName = null;
        String adapterVersion = null;
        mediationName = "tradplus";
        adapterVersion = "19.0.0";
        PAGConfig.Builder builder = new PAGConfig.Builder();
        builder.appId(appId);
        builder.useTextureView(true);
        builder.titleBarTheme(1);
        builder.supportMultiProcess(false);
        builder.needClearTaskReset(new String[0]);
        Boolean userConsent = this.updateUserConsent(userParams);
        if (userConsent != null) {
            builder.setGDPRConsent(userConsent != false ? 1 : 0);
        }
        builder.setChildDirected(this.ischild);
        builder.setDoNotSell(this.ccpa ? 0 : 1);
        builder.setUserData(PangleInitManager.getDataString(mediationName, adapterVersion));
        builder.debugLog(TestDeviceUtil.getInstance().isNeedTestDevice());
        if (userParams.containsKey("app_icon")) {
            try {
                int appIcon = (Integer)userParams.get("app_icon");
                if (appIcon != 0) {
                    builder.appIcon(appIcon);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return builder.build();
    }

    private static String getDataString(String mediationName, String adapterVersion) {
        if (TextUtils.isEmpty((CharSequence)mediationName) || TextUtils.isEmpty((CharSequence)adapterVersion)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject mediationJson = new JSONObject();
        JSONObject versionJson = new JSONObject();
        try {
            mediationJson.put("name", (Object)"mediation");
            mediationJson.put("value", (Object)mediationName);
            versionJson.put("name", (Object)"adapter_version");
            versionJson.put("value", (Object)adapterVersion);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        jsonArray.put((Object)mediationJson);
        jsonArray.put((Object)versionJson);
        return jsonArray.toString();
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        if (tpParams != null && tpParams.size() > 0) {
            this.appId = tpParams.get("appId");
        }
        this.suportGDPR(context, userParams);
        if (PangleInitManager.isInited((String)this.appId)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(this.appId, initCallback)) {
            return;
        }
        Log.d((String)"InitNetworkSDK", (String)("initSDK: appId :" + this.appId));
        if (PAGSdk.isInitSuccess()) {
            this.sendResult(this.appId, true);
            return;
        }
        PAGConfig pAGInitConfig = this.buildNewConfig(userParams, this.appId);
        PAGSdk.init((Context)context, (PAGConfig)pAGInitConfig, (PAGSdk.PAGInitCallback)new PAGSdk.PAGInitCallback(){

            public void success() {
                Log.i((String)PangleInitManager.TAG, (String)"success: ");
                PangleInitManager.this.sendResult(PangleInitManager.this.appId, true);
            }

            public void fail(int code, String msg) {
                Log.i((String)PangleInitManager.TAG, (String)("fail: code :" + code + ",msg :" + code));
                PangleInitManager.this.sendResult(PangleInitManager.this.appId, false, code + "", msg);
            }
        });
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (!PAGSdk.isInitSuccess()) {
            return;
        }
        if (userParams != null && userParams.size() > 0) {
            this.setPrivacyLaws(userParams);
            Boolean userConsent = this.updateUserConsent(userParams);
            if (userConsent != null) {
                PAGConfig.setGDPRConsent((int)(userConsent != false ? 1 : 0));
            }
            PAGConfig.setChildDirected((int)this.ischild);
            PAGConfig.setDoNotSell((int)(this.ccpa ? 0 : 1));
        }
    }

    public String getNetworkVersionCode() {
        return PAGSdk.getSDKVersion();
    }

    public String getNetworkVersionName() {
        return TAG;
    }
}

