/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAd;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialAdLoadListener;
import com.bytedance.sdk.openadsdk.api.interstitial.PAGInterstitialRequest;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class ToutiaoInterstitialAdapter
extends TPInterstitialAdapter {
    public static final String TAG = "PangleInterstitial";
    public static final float EXPRESSVIEW_WIDTH1 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT1 = 300.0f;
    public static final float EXPRESSVIEW_WIDTH2 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT2 = 450.0f;
    public static final float EXPRESSVIEW_WIDTH3 = 450.0f;
    public static final float EXPRESSVIEW_HEIGHT3 = 300.0f;
    private ToutiaoInterstitialCallbackRouter mCallbackRouter;
    private String placementId;
    private PAGInterstitialAd mPAGInterstitialAd;

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = serverExtras.get("placementId");
        final String payload = serverExtras.get("Bidding-Payload");
        this.mCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        this.mCallbackRouter.addListener(this.placementId, this.mLoadAdapterListener);
        PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                ToutiaoInterstitialAdapter.this.intFullScreen(payload);
            }

            public void onFailed(String code, String msg) {
                if (ToutiaoInterstitialAdapter.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    ToutiaoInterstitialAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void intFullScreen(String payload) {
        PAGInterstitialRequest pagInterstitialRequest = new PAGInterstitialRequest();
        if (!TextUtils.isEmpty((CharSequence)payload)) {
            pagInterstitialRequest.setAdString(payload);
        }
        PAGInterstitialAd.loadAd((String)this.placementId, (PAGInterstitialRequest)pagInterstitialRequest, (PAGInterstitialAdLoadListener)new PAGInterstitialAdLoadListener(){

            public void onError(int code, String message) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)("onError: code \uff1a" + code + ", message \uff1a" + message));
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(code, message));
                }
            }

            public void onAdLoaded(PAGInterstitialAd pagInterstitialAd) {
                if (pagInterstitialAd == null) {
                    if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                        ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoadFailed(new TPError("Unspecified error."));
                    }
                    Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdLoaded ,but pagInterstitialAd == null");
                    return;
                }
                ToutiaoInterstitialAdapter.this.mPAGInterstitialAd = pagInterstitialAd;
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.setNetworkObjectAd(pagInterstitialAd);
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getListener(ToutiaoInterstitialAdapter.this.placementId).loadAdapterLoaded(null);
                }
            }
        });
    }

    public void showAd() {
        Activity activity;
        if (this.mCallbackRouter != null && this.mShowListener != null) {
            this.mCallbackRouter.addShowListener(this.placementId, this.mShowListener);
        }
        if ((activity = GlobalTradPlus.getInstance().getActivity()) == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            Log.i((String)TAG, (String)"showAd, activity == null");
            return;
        }
        if (this.mPAGInterstitialAd == null) {
            if (this.mCallbackRouter.getShowListener(this.placementId) != null) {
                this.mCallbackRouter.getShowListener(this.placementId).onAdVideoError(new TPError("Unspecified error."));
            }
            Log.i((String)TAG, (String)"showAd, PAGInterstitialAd == null");
            return;
        }
        this.mPAGInterstitialAd.setAdInteractionListener(new PAGInterstitialAdInteractionListener(){

            public void onAdShowed() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShowed: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdShown();
                }
            }

            public void onAdClicked() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClicked: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClicked();
                }
            }

            public void onAdDismissed() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdDismissed: ");
                if (ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId) != null) {
                    ToutiaoInterstitialAdapter.this.mCallbackRouter.getShowListener(ToutiaoInterstitialAdapter.this.placementId).onAdClosed();
                }
            }
        });
        this.mPAGInterstitialAd.show(activity);
    }

    public void clean() {
        super.clean();
        if (this.mPAGInterstitialAd != null) {
            this.mPAGInterstitialAd.setAdInteractionListener(null);
            this.mPAGInterstitialAd = null;
        }
        if (this.placementId != null) {
            this.mCallbackRouter.removeListeners(this.placementId);
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return PAGSdk.getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        PangleInitManager.getInstance().setInitState("2");
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onSuccess: ");
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult(PAGSdk.getBiddingToken(), null);
                }
            }

            public void onFailed(String code, String msg) {
                if (onS2STokenListener != null) {
                    onS2STokenListener.onTokenResult("", null);
                }
            }
        });
    }
}

