// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/extensions/http/header_validators/envoy_default/v3/header_validator.proto

package io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3;

/**
 * <pre>
 * This extension validates that HTTP request and response headers are well formed according to respective RFCs.
 * #. HTTP/1 header map validity according to `RFC 7230 section 3.2 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.2&gt;`_
 * #. Syntax of HTTP/1 request target URI and response status
 * #. HTTP/2 header map validity according to `RFC 7540 section 8.1.2 &lt;https://datatracker.ietf.org/doc/html/rfc7540#section-8.1.2&gt;`_
 * #. Syntax of HTTP/2 pseudo headers
 * #. HTTP/3 header map validity according to `RFC 9114 section 4.3  &lt;https://www.rfc-editor.org/rfc/rfc9114.html&gt;`_
 * #. Syntax of HTTP/3 pseudo headers
 * #. Syntax of Content-Length and Transfer-Encoding
 * #. Validation of HTTP/1 requests with both ``Content-Length`` and ``Transfer-Encoding`` headers
 * #. Normalization of the URI path according to `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
 *    without `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
 * </pre>
 *
 * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig}
 */
public final class HeaderValidatorConfig extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)
    HeaderValidatorConfigOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HeaderValidatorConfig.newBuilder() to construct.
  private HeaderValidatorConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HeaderValidatorConfig() {
    headersWithUnderscoresAction_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new HeaderValidatorConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private HeaderValidatorConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder subBuilder = null;
            if (http1ProtocolOptions_ != null) {
              subBuilder = http1ProtocolOptions_.toBuilder();
            }
            http1ProtocolOptions_ = input.readMessage(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(http1ProtocolOptions_);
              http1ProtocolOptions_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder subBuilder = null;
            if (uriPathNormalizationOptions_ != null) {
              subBuilder = uriPathNormalizationOptions_.toBuilder();
            }
            uriPathNormalizationOptions_ = input.readMessage(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(uriPathNormalizationOptions_);
              uriPathNormalizationOptions_ = subBuilder.buildPartial();
            }

            break;
          }
          case 24: {

            restrictHttpMethods_ = input.readBool();
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            headersWithUnderscoresAction_ = rawValue;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Builder.class);
  }

  /**
   * <pre>
   * Action to take when Envoy receives client request with header names containing underscore
   * characters.
   * Underscore character is allowed in header names by the RFC-7230 and this behavior is implemented
   * as a security measure due to systems that treat '_' and '-' as interchangeable. Envoy by default allows client request headers with underscore
   * characters.
   * </pre>
   *
   * Protobuf enum {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction}
   */
  public enum HeadersWithUnderscoresAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Allow headers with underscores. This is the default behavior.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    ALLOW(0),
    /**
     * <pre>
     * Reject client request. HTTP/1 requests are rejected with the 400 status. HTTP/2 requests
     * end with the stream reset. The
     * :ref:`httpN.requests_rejected_with_underscores_in_headers &lt;config_http_conn_man_stats_per_codec&gt;` counter
     * is incremented for each rejected request.
     * </pre>
     *
     * <code>REJECT_REQUEST = 1;</code>
     */
    REJECT_REQUEST(1),
    /**
     * <pre>
     * Drop the client header with name containing underscores. The header is dropped before the filter chain is
     * invoked and as such filters will not see dropped headers. The
     * :ref:`httpN.dropped_headers_with_underscores &lt;config_http_conn_man_stats_per_codec&gt;` is incremented for
     * each dropped header.
     * </pre>
     *
     * <code>DROP_HEADER = 2;</code>
     */
    DROP_HEADER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Allow headers with underscores. This is the default behavior.
     * </pre>
     *
     * <code>ALLOW = 0;</code>
     */
    public static final int ALLOW_VALUE = 0;
    /**
     * <pre>
     * Reject client request. HTTP/1 requests are rejected with the 400 status. HTTP/2 requests
     * end with the stream reset. The
     * :ref:`httpN.requests_rejected_with_underscores_in_headers &lt;config_http_conn_man_stats_per_codec&gt;` counter
     * is incremented for each rejected request.
     * </pre>
     *
     * <code>REJECT_REQUEST = 1;</code>
     */
    public static final int REJECT_REQUEST_VALUE = 1;
    /**
     * <pre>
     * Drop the client header with name containing underscores. The header is dropped before the filter chain is
     * invoked and as such filters will not see dropped headers. The
     * :ref:`httpN.dropped_headers_with_underscores &lt;config_http_conn_man_stats_per_codec&gt;` is incremented for
     * each dropped header.
     * </pre>
     *
     * <code>DROP_HEADER = 2;</code>
     */
    public static final int DROP_HEADER_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HeadersWithUnderscoresAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HeadersWithUnderscoresAction forNumber(int value) {
      switch (value) {
        case 0: return ALLOW;
        case 1: return REJECT_REQUEST;
        case 2: return DROP_HEADER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HeadersWithUnderscoresAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        HeadersWithUnderscoresAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HeadersWithUnderscoresAction>() {
            public HeadersWithUnderscoresAction findValueByNumber(int number) {
              return HeadersWithUnderscoresAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final HeadersWithUnderscoresAction[] VALUES = values();

    public static HeadersWithUnderscoresAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HeadersWithUnderscoresAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction)
  }

  public interface UriPathNormalizationOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Should paths be normalized according to RFC 3986?
     * This operation overwrites the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * Envoy will respond with 400 to requests with malformed paths that fail path normalization.
     * The default behavior is to normalize the path.
     * This value may be overridden by the runtime variable
     * :ref:`http_connection_manager.normalize_path&lt;config_http_conn_man_runtime_normalize_path&gt;`.
     * See `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
     * for details of normalization.
     * Note that Envoy does not perform
     * `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
     * URI path normalization can be applied to a portion of requests by setting the
     * ``envoy_default_header_validator.path_normalization`` runtime value.
     * </pre>
     *
     * <code>bool skip_path_normalization = 1;</code>
     * @return The skipPathNormalization.
     */
    boolean getSkipPathNormalization();

    /**
     * <pre>
     * Determines if adjacent slashes in the path are merged into one.
     * This operation overwrites the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * Setting this option to true will cause incoming requests with path ``//dir///file`` to not match against
     * route with ``prefix`` match set to ``/dir``. Defaults to ``false``. Note that slash merging is not part of
     * `HTTP spec &lt;https://datatracker.ietf.org/doc/html/rfc3986&gt;`_ and is provided for convenience.
     * Merging of slashes in URI path can be applied to a portion of requests by setting the
     * ``envoy_default_header_validator.merge_slashes`` runtime value.
     * </pre>
     *
     * <code>bool skip_merging_slashes = 2;</code>
     * @return The skipMergingSlashes.
     */
    boolean getSkipMergingSlashes();

    /**
     * <pre>
     * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
     * This operation may overwrite the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
     * @return The enum numeric value on the wire for pathWithEscapedSlashesAction.
     */
    int getPathWithEscapedSlashesActionValue();
    /**
     * <pre>
     * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
     * This operation may overwrite the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
     * @return The pathWithEscapedSlashesAction.
     */
    io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction getPathWithEscapedSlashesAction();
  }
  /**
   * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions}
   */
  public static final class UriPathNormalizationOptions extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)
      UriPathNormalizationOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use UriPathNormalizationOptions.newBuilder() to construct.
    private UriPathNormalizationOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private UriPathNormalizationOptions() {
      pathWithEscapedSlashesAction_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new UriPathNormalizationOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private UriPathNormalizationOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {

              skipPathNormalization_ = input.readBool();
              break;
            }
            case 16: {

              skipMergingSlashes_ = input.readBool();
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              pathWithEscapedSlashesAction_ = rawValue;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_UriPathNormalizationOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_UriPathNormalizationOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder.class);
    }

    /**
     * <pre>
     * Determines the action for requests that contain ``%2F``, ``%2f``, ``%5C`` or ``%5c`` sequences in the URI path.
     * This operation occurs before URL normalization and the merge slashes transformations if they were enabled.
     * </pre>
     *
     * Protobuf enum {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction}
     */
    public enum PathWithEscapedSlashesAction
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Default behavior specific to implementation (i.e. Envoy) of this configuration option.
       * Envoy, by default, takes the ``KEEP_UNCHANGED`` action.
       * NOTE: the implementation may change the default behavior at-will.
       * </pre>
       *
       * <code>IMPLEMENTATION_SPECIFIC_DEFAULT = 0;</code>
       */
      IMPLEMENTATION_SPECIFIC_DEFAULT(0),
      /**
       * <pre>
       * Keep escaped slashes.
       * </pre>
       *
       * <code>KEEP_UNCHANGED = 1;</code>
       */
      KEEP_UNCHANGED(1),
      /**
       * <pre>
       * Reject client request with the 400 status. gRPC requests will be rejected with the ``INTERNAL`` (13) error code.
       * The ``http#.downstream_rq_failed_path_normalization`` counter is incremented for each rejected request.
       * </pre>
       *
       * <code>REJECT_REQUEST = 2;</code>
       */
      REJECT_REQUEST(2),
      /**
       * <pre>
       * Unescape ``%2F`` and ``%5C`` sequences and redirect the request to the new path if these sequences were present.
       * The redirect occurs after path normalization and merge slashes transformations if they were configured.
       * NOTE: gRPC requests will be rejected with the ``INTERNAL`` (13) error code.
       * This option minimizes possibility of path confusion exploits by forcing request with unescaped slashes to
       * traverse all parties: downstream client, intermediate proxies, Envoy and upstream server.
       * The ``http#.downstream_rq_redirected_with_normalized_path`` counter is incremented for each
       * redirected request.
       * </pre>
       *
       * <code>UNESCAPE_AND_REDIRECT = 3;</code>
       */
      UNESCAPE_AND_REDIRECT(3),
      /**
       * <pre>
       * Unescape ``%2F`` and ``%5C`` sequences.
       * Note: this option should not be enabled if intermediaries perform path based access control as
       * it may lead to path confusion vulnerabilities.
       * </pre>
       *
       * <code>UNESCAPE_AND_FORWARD = 4;</code>
       */
      UNESCAPE_AND_FORWARD(4),
      UNRECOGNIZED(-1),
      ;

      /**
       * <pre>
       * Default behavior specific to implementation (i.e. Envoy) of this configuration option.
       * Envoy, by default, takes the ``KEEP_UNCHANGED`` action.
       * NOTE: the implementation may change the default behavior at-will.
       * </pre>
       *
       * <code>IMPLEMENTATION_SPECIFIC_DEFAULT = 0;</code>
       */
      public static final int IMPLEMENTATION_SPECIFIC_DEFAULT_VALUE = 0;
      /**
       * <pre>
       * Keep escaped slashes.
       * </pre>
       *
       * <code>KEEP_UNCHANGED = 1;</code>
       */
      public static final int KEEP_UNCHANGED_VALUE = 1;
      /**
       * <pre>
       * Reject client request with the 400 status. gRPC requests will be rejected with the ``INTERNAL`` (13) error code.
       * The ``http#.downstream_rq_failed_path_normalization`` counter is incremented for each rejected request.
       * </pre>
       *
       * <code>REJECT_REQUEST = 2;</code>
       */
      public static final int REJECT_REQUEST_VALUE = 2;
      /**
       * <pre>
       * Unescape ``%2F`` and ``%5C`` sequences and redirect the request to the new path if these sequences were present.
       * The redirect occurs after path normalization and merge slashes transformations if they were configured.
       * NOTE: gRPC requests will be rejected with the ``INTERNAL`` (13) error code.
       * This option minimizes possibility of path confusion exploits by forcing request with unescaped slashes to
       * traverse all parties: downstream client, intermediate proxies, Envoy and upstream server.
       * The ``http#.downstream_rq_redirected_with_normalized_path`` counter is incremented for each
       * redirected request.
       * </pre>
       *
       * <code>UNESCAPE_AND_REDIRECT = 3;</code>
       */
      public static final int UNESCAPE_AND_REDIRECT_VALUE = 3;
      /**
       * <pre>
       * Unescape ``%2F`` and ``%5C`` sequences.
       * Note: this option should not be enabled if intermediaries perform path based access control as
       * it may lead to path confusion vulnerabilities.
       * </pre>
       *
       * <code>UNESCAPE_AND_FORWARD = 4;</code>
       */
      public static final int UNESCAPE_AND_FORWARD_VALUE = 4;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PathWithEscapedSlashesAction valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PathWithEscapedSlashesAction forNumber(int value) {
        switch (value) {
          case 0: return IMPLEMENTATION_SPECIFIC_DEFAULT;
          case 1: return KEEP_UNCHANGED;
          case 2: return REJECT_REQUEST;
          case 3: return UNESCAPE_AND_REDIRECT;
          case 4: return UNESCAPE_AND_FORWARD;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PathWithEscapedSlashesAction>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          PathWithEscapedSlashesAction> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PathWithEscapedSlashesAction>() {
              public PathWithEscapedSlashesAction findValueByNumber(int number) {
                return PathWithEscapedSlashesAction.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDescriptor().getEnumTypes().get(0);
      }

      private static final PathWithEscapedSlashesAction[] VALUES = values();

      public static PathWithEscapedSlashesAction valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PathWithEscapedSlashesAction(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction)
    }

    public static final int SKIP_PATH_NORMALIZATION_FIELD_NUMBER = 1;
    private boolean skipPathNormalization_;
    /**
     * <pre>
     * Should paths be normalized according to RFC 3986?
     * This operation overwrites the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * Envoy will respond with 400 to requests with malformed paths that fail path normalization.
     * The default behavior is to normalize the path.
     * This value may be overridden by the runtime variable
     * :ref:`http_connection_manager.normalize_path&lt;config_http_conn_man_runtime_normalize_path&gt;`.
     * See `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
     * for details of normalization.
     * Note that Envoy does not perform
     * `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
     * URI path normalization can be applied to a portion of requests by setting the
     * ``envoy_default_header_validator.path_normalization`` runtime value.
     * </pre>
     *
     * <code>bool skip_path_normalization = 1;</code>
     * @return The skipPathNormalization.
     */
    @java.lang.Override
    public boolean getSkipPathNormalization() {
      return skipPathNormalization_;
    }

    public static final int SKIP_MERGING_SLASHES_FIELD_NUMBER = 2;
    private boolean skipMergingSlashes_;
    /**
     * <pre>
     * Determines if adjacent slashes in the path are merged into one.
     * This operation overwrites the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * Setting this option to true will cause incoming requests with path ``//dir///file`` to not match against
     * route with ``prefix`` match set to ``/dir``. Defaults to ``false``. Note that slash merging is not part of
     * `HTTP spec &lt;https://datatracker.ietf.org/doc/html/rfc3986&gt;`_ and is provided for convenience.
     * Merging of slashes in URI path can be applied to a portion of requests by setting the
     * ``envoy_default_header_validator.merge_slashes`` runtime value.
     * </pre>
     *
     * <code>bool skip_merging_slashes = 2;</code>
     * @return The skipMergingSlashes.
     */
    @java.lang.Override
    public boolean getSkipMergingSlashes() {
      return skipMergingSlashes_;
    }

    public static final int PATH_WITH_ESCAPED_SLASHES_ACTION_FIELD_NUMBER = 3;
    private int pathWithEscapedSlashesAction_;
    /**
     * <pre>
     * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
     * This operation may overwrite the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
     * @return The enum numeric value on the wire for pathWithEscapedSlashesAction.
     */
    @java.lang.Override public int getPathWithEscapedSlashesActionValue() {
      return pathWithEscapedSlashesAction_;
    }
    /**
     * <pre>
     * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
     * This operation may overwrite the original request URI path and the new path is used for processing of
     * the request by HTTP filters and proxied to the upstream service.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
     * @return The pathWithEscapedSlashesAction.
     */
    @java.lang.Override public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction getPathWithEscapedSlashesAction() {
      @SuppressWarnings("deprecation")
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction result = io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.valueOf(pathWithEscapedSlashesAction_);
      return result == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (skipPathNormalization_ != false) {
        output.writeBool(1, skipPathNormalization_);
      }
      if (skipMergingSlashes_ != false) {
        output.writeBool(2, skipMergingSlashes_);
      }
      if (pathWithEscapedSlashesAction_ != io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.IMPLEMENTATION_SPECIFIC_DEFAULT.getNumber()) {
        output.writeEnum(3, pathWithEscapedSlashesAction_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (skipPathNormalization_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, skipPathNormalization_);
      }
      if (skipMergingSlashes_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, skipMergingSlashes_);
      }
      if (pathWithEscapedSlashesAction_ != io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.IMPLEMENTATION_SPECIFIC_DEFAULT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, pathWithEscapedSlashesAction_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions other = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions) obj;

      if (getSkipPathNormalization()
          != other.getSkipPathNormalization()) return false;
      if (getSkipMergingSlashes()
          != other.getSkipMergingSlashes()) return false;
      if (pathWithEscapedSlashesAction_ != other.pathWithEscapedSlashesAction_) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SKIP_PATH_NORMALIZATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSkipPathNormalization());
      hash = (37 * hash) + SKIP_MERGING_SLASHES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSkipMergingSlashes());
      hash = (37 * hash) + PATH_WITH_ESCAPED_SLASHES_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + pathWithEscapedSlashesAction_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_UriPathNormalizationOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_UriPathNormalizationOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        skipPathNormalization_ = false;

        skipMergingSlashes_ = false;

        pathWithEscapedSlashesAction_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_UriPathNormalizationOptions_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions getDefaultInstanceForType() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions build() {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions buildPartial() {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions result = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions(this);
        result.skipPathNormalization_ = skipPathNormalization_;
        result.skipMergingSlashes_ = skipMergingSlashes_;
        result.pathWithEscapedSlashesAction_ = pathWithEscapedSlashesAction_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions) {
          return mergeFrom((io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions other) {
        if (other == io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDefaultInstance()) return this;
        if (other.getSkipPathNormalization() != false) {
          setSkipPathNormalization(other.getSkipPathNormalization());
        }
        if (other.getSkipMergingSlashes() != false) {
          setSkipMergingSlashes(other.getSkipMergingSlashes());
        }
        if (other.pathWithEscapedSlashesAction_ != 0) {
          setPathWithEscapedSlashesActionValue(other.getPathWithEscapedSlashesActionValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean skipPathNormalization_ ;
      /**
       * <pre>
       * Should paths be normalized according to RFC 3986?
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Envoy will respond with 400 to requests with malformed paths that fail path normalization.
       * The default behavior is to normalize the path.
       * This value may be overridden by the runtime variable
       * :ref:`http_connection_manager.normalize_path&lt;config_http_conn_man_runtime_normalize_path&gt;`.
       * See `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
       * for details of normalization.
       * Note that Envoy does not perform
       * `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
       * URI path normalization can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.path_normalization`` runtime value.
       * </pre>
       *
       * <code>bool skip_path_normalization = 1;</code>
       * @return The skipPathNormalization.
       */
      @java.lang.Override
      public boolean getSkipPathNormalization() {
        return skipPathNormalization_;
      }
      /**
       * <pre>
       * Should paths be normalized according to RFC 3986?
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Envoy will respond with 400 to requests with malformed paths that fail path normalization.
       * The default behavior is to normalize the path.
       * This value may be overridden by the runtime variable
       * :ref:`http_connection_manager.normalize_path&lt;config_http_conn_man_runtime_normalize_path&gt;`.
       * See `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
       * for details of normalization.
       * Note that Envoy does not perform
       * `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
       * URI path normalization can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.path_normalization`` runtime value.
       * </pre>
       *
       * <code>bool skip_path_normalization = 1;</code>
       * @param value The skipPathNormalization to set.
       * @return This builder for chaining.
       */
      public Builder setSkipPathNormalization(boolean value) {
        
        skipPathNormalization_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Should paths be normalized according to RFC 3986?
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Envoy will respond with 400 to requests with malformed paths that fail path normalization.
       * The default behavior is to normalize the path.
       * This value may be overridden by the runtime variable
       * :ref:`http_connection_manager.normalize_path&lt;config_http_conn_man_runtime_normalize_path&gt;`.
       * See `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
       * for details of normalization.
       * Note that Envoy does not perform
       * `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
       * URI path normalization can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.path_normalization`` runtime value.
       * </pre>
       *
       * <code>bool skip_path_normalization = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearSkipPathNormalization() {
        
        skipPathNormalization_ = false;
        onChanged();
        return this;
      }

      private boolean skipMergingSlashes_ ;
      /**
       * <pre>
       * Determines if adjacent slashes in the path are merged into one.
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Setting this option to true will cause incoming requests with path ``//dir///file`` to not match against
       * route with ``prefix`` match set to ``/dir``. Defaults to ``false``. Note that slash merging is not part of
       * `HTTP spec &lt;https://datatracker.ietf.org/doc/html/rfc3986&gt;`_ and is provided for convenience.
       * Merging of slashes in URI path can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.merge_slashes`` runtime value.
       * </pre>
       *
       * <code>bool skip_merging_slashes = 2;</code>
       * @return The skipMergingSlashes.
       */
      @java.lang.Override
      public boolean getSkipMergingSlashes() {
        return skipMergingSlashes_;
      }
      /**
       * <pre>
       * Determines if adjacent slashes in the path are merged into one.
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Setting this option to true will cause incoming requests with path ``//dir///file`` to not match against
       * route with ``prefix`` match set to ``/dir``. Defaults to ``false``. Note that slash merging is not part of
       * `HTTP spec &lt;https://datatracker.ietf.org/doc/html/rfc3986&gt;`_ and is provided for convenience.
       * Merging of slashes in URI path can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.merge_slashes`` runtime value.
       * </pre>
       *
       * <code>bool skip_merging_slashes = 2;</code>
       * @param value The skipMergingSlashes to set.
       * @return This builder for chaining.
       */
      public Builder setSkipMergingSlashes(boolean value) {
        
        skipMergingSlashes_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Determines if adjacent slashes in the path are merged into one.
       * This operation overwrites the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * Setting this option to true will cause incoming requests with path ``//dir///file`` to not match against
       * route with ``prefix`` match set to ``/dir``. Defaults to ``false``. Note that slash merging is not part of
       * `HTTP spec &lt;https://datatracker.ietf.org/doc/html/rfc3986&gt;`_ and is provided for convenience.
       * Merging of slashes in URI path can be applied to a portion of requests by setting the
       * ``envoy_default_header_validator.merge_slashes`` runtime value.
       * </pre>
       *
       * <code>bool skip_merging_slashes = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSkipMergingSlashes() {
        
        skipMergingSlashes_ = false;
        onChanged();
        return this;
      }

      private int pathWithEscapedSlashesAction_ = 0;
      /**
       * <pre>
       * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
       * This operation may overwrite the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * </pre>
       *
       * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
       * @return The enum numeric value on the wire for pathWithEscapedSlashesAction.
       */
      @java.lang.Override public int getPathWithEscapedSlashesActionValue() {
        return pathWithEscapedSlashesAction_;
      }
      /**
       * <pre>
       * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
       * This operation may overwrite the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * </pre>
       *
       * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
       * @param value The enum numeric value on the wire for pathWithEscapedSlashesAction to set.
       * @return This builder for chaining.
       */
      public Builder setPathWithEscapedSlashesActionValue(int value) {
        
        pathWithEscapedSlashesAction_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
       * This operation may overwrite the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * </pre>
       *
       * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
       * @return The pathWithEscapedSlashesAction.
       */
      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction getPathWithEscapedSlashesAction() {
        @SuppressWarnings("deprecation")
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction result = io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.valueOf(pathWithEscapedSlashesAction_);
        return result == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
       * This operation may overwrite the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * </pre>
       *
       * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
       * @param value The pathWithEscapedSlashesAction to set.
       * @return This builder for chaining.
       */
      public Builder setPathWithEscapedSlashesAction(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        pathWithEscapedSlashesAction_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The action to take when request URL path contains escaped slash sequences (``%2F``, ``%2f``, ``%5C`` and ``%5c``).
       * This operation may overwrite the original request URI path and the new path is used for processing of
       * the request by HTTP filters and proxied to the upstream service.
       * </pre>
       *
       * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.PathWithEscapedSlashesAction path_with_escaped_slashes_action = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPathWithEscapedSlashesAction() {
        
        pathWithEscapedSlashesAction_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)
    }

    // @@protoc_insertion_point(class_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions)
    private static final io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions();
    }

    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UriPathNormalizationOptions>
        PARSER = new com.google.protobuf.AbstractParser<UriPathNormalizationOptions>() {
      @java.lang.Override
      public UriPathNormalizationOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new UriPathNormalizationOptions(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<UriPathNormalizationOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UriPathNormalizationOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface Http1ProtocolOptionsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Allows Envoy to process HTTP/1 requests/responses with both ``Content-Length`` and ``Transfer-Encoding``
     * headers set. By default such messages are rejected, but if option is enabled - Envoy will
     * remove the ``Content-Length`` header and process the message.
     * See `RFC7230, sec. 3.3.3 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.3.3&gt;`_ for details.
     * .. attention::
     *   Enabling this option might lead to request smuggling vulnerabilities, especially if traffic
     *   is proxied via multiple layers of proxies.
     * </pre>
     *
     * <code>bool allow_chunked_length = 1;</code>
     * @return The allowChunkedLength.
     */
    boolean getAllowChunkedLength();
  }
  /**
   * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions}
   */
  public static final class Http1ProtocolOptions extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)
      Http1ProtocolOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Http1ProtocolOptions.newBuilder() to construct.
    private Http1ProtocolOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Http1ProtocolOptions() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Http1ProtocolOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Http1ProtocolOptions(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {

              allowChunkedLength_ = input.readBool();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_Http1ProtocolOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_Http1ProtocolOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder.class);
    }

    public static final int ALLOW_CHUNKED_LENGTH_FIELD_NUMBER = 1;
    private boolean allowChunkedLength_;
    /**
     * <pre>
     * Allows Envoy to process HTTP/1 requests/responses with both ``Content-Length`` and ``Transfer-Encoding``
     * headers set. By default such messages are rejected, but if option is enabled - Envoy will
     * remove the ``Content-Length`` header and process the message.
     * See `RFC7230, sec. 3.3.3 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.3.3&gt;`_ for details.
     * .. attention::
     *   Enabling this option might lead to request smuggling vulnerabilities, especially if traffic
     *   is proxied via multiple layers of proxies.
     * </pre>
     *
     * <code>bool allow_chunked_length = 1;</code>
     * @return The allowChunkedLength.
     */
    @java.lang.Override
    public boolean getAllowChunkedLength() {
      return allowChunkedLength_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (allowChunkedLength_ != false) {
        output.writeBool(1, allowChunkedLength_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (allowChunkedLength_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, allowChunkedLength_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions other = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions) obj;

      if (getAllowChunkedLength()
          != other.getAllowChunkedLength()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALLOW_CHUNKED_LENGTH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getAllowChunkedLength());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_Http1ProtocolOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_Http1ProtocolOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        allowChunkedLength_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_Http1ProtocolOptions_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions getDefaultInstanceForType() {
        return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions build() {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions buildPartial() {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions result = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions(this);
        result.allowChunkedLength_ = allowChunkedLength_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions) {
          return mergeFrom((io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions other) {
        if (other == io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.getDefaultInstance()) return this;
        if (other.getAllowChunkedLength() != false) {
          setAllowChunkedLength(other.getAllowChunkedLength());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean allowChunkedLength_ ;
      /**
       * <pre>
       * Allows Envoy to process HTTP/1 requests/responses with both ``Content-Length`` and ``Transfer-Encoding``
       * headers set. By default such messages are rejected, but if option is enabled - Envoy will
       * remove the ``Content-Length`` header and process the message.
       * See `RFC7230, sec. 3.3.3 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.3.3&gt;`_ for details.
       * .. attention::
       *   Enabling this option might lead to request smuggling vulnerabilities, especially if traffic
       *   is proxied via multiple layers of proxies.
       * </pre>
       *
       * <code>bool allow_chunked_length = 1;</code>
       * @return The allowChunkedLength.
       */
      @java.lang.Override
      public boolean getAllowChunkedLength() {
        return allowChunkedLength_;
      }
      /**
       * <pre>
       * Allows Envoy to process HTTP/1 requests/responses with both ``Content-Length`` and ``Transfer-Encoding``
       * headers set. By default such messages are rejected, but if option is enabled - Envoy will
       * remove the ``Content-Length`` header and process the message.
       * See `RFC7230, sec. 3.3.3 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.3.3&gt;`_ for details.
       * .. attention::
       *   Enabling this option might lead to request smuggling vulnerabilities, especially if traffic
       *   is proxied via multiple layers of proxies.
       * </pre>
       *
       * <code>bool allow_chunked_length = 1;</code>
       * @param value The allowChunkedLength to set.
       * @return This builder for chaining.
       */
      public Builder setAllowChunkedLength(boolean value) {
        
        allowChunkedLength_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Allows Envoy to process HTTP/1 requests/responses with both ``Content-Length`` and ``Transfer-Encoding``
       * headers set. By default such messages are rejected, but if option is enabled - Envoy will
       * remove the ``Content-Length`` header and process the message.
       * See `RFC7230, sec. 3.3.3 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.3.3&gt;`_ for details.
       * .. attention::
       *   Enabling this option might lead to request smuggling vulnerabilities, especially if traffic
       *   is proxied via multiple layers of proxies.
       * </pre>
       *
       * <code>bool allow_chunked_length = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowChunkedLength() {
        
        allowChunkedLength_ = false;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)
    }

    // @@protoc_insertion_point(class_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions)
    private static final io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions();
    }

    public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Http1ProtocolOptions>
        PARSER = new com.google.protobuf.AbstractParser<Http1ProtocolOptions>() {
      @java.lang.Override
      public Http1ProtocolOptions parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Http1ProtocolOptions(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Http1ProtocolOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Http1ProtocolOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public static final int HTTP1_PROTOCOL_OPTIONS_FIELD_NUMBER = 1;
  private io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1ProtocolOptions_;
  /**
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
   * @return Whether the http1ProtocolOptions field is set.
   */
  @java.lang.Override
  public boolean hasHttp1ProtocolOptions() {
    return http1ProtocolOptions_ != null;
  }
  /**
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
   * @return The http1ProtocolOptions.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions getHttp1ProtocolOptions() {
    return http1ProtocolOptions_ == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.getDefaultInstance() : http1ProtocolOptions_;
  }
  /**
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder getHttp1ProtocolOptionsOrBuilder() {
    return getHttp1ProtocolOptions();
  }

  public static final int URI_PATH_NORMALIZATION_OPTIONS_FIELD_NUMBER = 2;
  private io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uriPathNormalizationOptions_;
  /**
   * <pre>
   * The URI path normalization options.
   * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
   * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
   * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
   * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
   * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
   * selection.
   * </pre>
   *
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
   * @return Whether the uriPathNormalizationOptions field is set.
   */
  @java.lang.Override
  public boolean hasUriPathNormalizationOptions() {
    return uriPathNormalizationOptions_ != null;
  }
  /**
   * <pre>
   * The URI path normalization options.
   * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
   * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
   * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
   * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
   * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
   * selection.
   * </pre>
   *
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
   * @return The uriPathNormalizationOptions.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions getUriPathNormalizationOptions() {
    return uriPathNormalizationOptions_ == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDefaultInstance() : uriPathNormalizationOptions_;
  }
  /**
   * <pre>
   * The URI path normalization options.
   * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
   * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
   * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
   * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
   * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
   * selection.
   * </pre>
   *
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder getUriPathNormalizationOptionsOrBuilder() {
    return getUriPathNormalizationOptions();
  }

  public static final int RESTRICT_HTTP_METHODS_FIELD_NUMBER = 3;
  private boolean restrictHttpMethods_;
  /**
   * <pre>
   * Restrict HTTP methods to these defined in the `RFC 7231 section 4.1 &lt;https://datatracker.ietf.org/doc/html/rfc7231#section-4.1&gt;`_
   * Envoy will respond with 400 to requests with disallowed methods.
   * By default methods with arbitrary names are accepted.
   * </pre>
   *
   * <code>bool restrict_http_methods = 3;</code>
   * @return The restrictHttpMethods.
   */
  @java.lang.Override
  public boolean getRestrictHttpMethods() {
    return restrictHttpMethods_;
  }

  public static final int HEADERS_WITH_UNDERSCORES_ACTION_FIELD_NUMBER = 4;
  private int headersWithUnderscoresAction_;
  /**
   * <pre>
   * Action to take when a client request with a header name containing underscore characters is received.
   * If this setting is not specified, the value defaults to ALLOW.
   * </pre>
   *
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
   * @return The enum numeric value on the wire for headersWithUnderscoresAction.
   */
  @java.lang.Override public int getHeadersWithUnderscoresActionValue() {
    return headersWithUnderscoresAction_;
  }
  /**
   * <pre>
   * Action to take when a client request with a header name containing underscore characters is received.
   * If this setting is not specified, the value defaults to ALLOW.
   * </pre>
   *
   * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
   * @return The headersWithUnderscoresAction.
   */
  @java.lang.Override public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction getHeadersWithUnderscoresAction() {
    @SuppressWarnings("deprecation")
    io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction result = io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.valueOf(headersWithUnderscoresAction_);
    return result == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (http1ProtocolOptions_ != null) {
      output.writeMessage(1, getHttp1ProtocolOptions());
    }
    if (uriPathNormalizationOptions_ != null) {
      output.writeMessage(2, getUriPathNormalizationOptions());
    }
    if (restrictHttpMethods_ != false) {
      output.writeBool(3, restrictHttpMethods_);
    }
    if (headersWithUnderscoresAction_ != io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.ALLOW.getNumber()) {
      output.writeEnum(4, headersWithUnderscoresAction_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (http1ProtocolOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getHttp1ProtocolOptions());
    }
    if (uriPathNormalizationOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getUriPathNormalizationOptions());
    }
    if (restrictHttpMethods_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, restrictHttpMethods_);
    }
    if (headersWithUnderscoresAction_ != io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.ALLOW.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, headersWithUnderscoresAction_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig other = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig) obj;

    if (hasHttp1ProtocolOptions() != other.hasHttp1ProtocolOptions()) return false;
    if (hasHttp1ProtocolOptions()) {
      if (!getHttp1ProtocolOptions()
          .equals(other.getHttp1ProtocolOptions())) return false;
    }
    if (hasUriPathNormalizationOptions() != other.hasUriPathNormalizationOptions()) return false;
    if (hasUriPathNormalizationOptions()) {
      if (!getUriPathNormalizationOptions()
          .equals(other.getUriPathNormalizationOptions())) return false;
    }
    if (getRestrictHttpMethods()
        != other.getRestrictHttpMethods()) return false;
    if (headersWithUnderscoresAction_ != other.headersWithUnderscoresAction_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHttp1ProtocolOptions()) {
      hash = (37 * hash) + HTTP1_PROTOCOL_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getHttp1ProtocolOptions().hashCode();
    }
    if (hasUriPathNormalizationOptions()) {
      hash = (37 * hash) + URI_PATH_NORMALIZATION_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getUriPathNormalizationOptions().hashCode();
    }
    hash = (37 * hash) + RESTRICT_HTTP_METHODS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getRestrictHttpMethods());
    hash = (37 * hash) + HEADERS_WITH_UNDERSCORES_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + headersWithUnderscoresAction_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This extension validates that HTTP request and response headers are well formed according to respective RFCs.
   * #. HTTP/1 header map validity according to `RFC 7230 section 3.2 &lt;https://datatracker.ietf.org/doc/html/rfc7230#section-3.2&gt;`_
   * #. Syntax of HTTP/1 request target URI and response status
   * #. HTTP/2 header map validity according to `RFC 7540 section 8.1.2 &lt;https://datatracker.ietf.org/doc/html/rfc7540#section-8.1.2&gt;`_
   * #. Syntax of HTTP/2 pseudo headers
   * #. HTTP/3 header map validity according to `RFC 9114 section 4.3  &lt;https://www.rfc-editor.org/rfc/rfc9114.html&gt;`_
   * #. Syntax of HTTP/3 pseudo headers
   * #. Syntax of Content-Length and Transfer-Encoding
   * #. Validation of HTTP/1 requests with both ``Content-Length`` and ``Transfer-Encoding`` headers
   * #. Normalization of the URI path according to `Normalization and Comparison &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6&gt;`_
   *    without `case normalization &lt;https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.1&gt;`_
   * </pre>
   *
   * Protobuf type {@code envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.class, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (http1ProtocolOptionsBuilder_ == null) {
        http1ProtocolOptions_ = null;
      } else {
        http1ProtocolOptions_ = null;
        http1ProtocolOptionsBuilder_ = null;
      }
      if (uriPathNormalizationOptionsBuilder_ == null) {
        uriPathNormalizationOptions_ = null;
      } else {
        uriPathNormalizationOptions_ = null;
        uriPathNormalizationOptionsBuilder_ = null;
      }
      restrictHttpMethods_ = false;

      headersWithUnderscoresAction_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorProto.internal_static_envoy_extensions_http_header_validators_envoy_default_v3_HeaderValidatorConfig_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig getDefaultInstanceForType() {
      return io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig build() {
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig buildPartial() {
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig result = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig(this);
      if (http1ProtocolOptionsBuilder_ == null) {
        result.http1ProtocolOptions_ = http1ProtocolOptions_;
      } else {
        result.http1ProtocolOptions_ = http1ProtocolOptionsBuilder_.build();
      }
      if (uriPathNormalizationOptionsBuilder_ == null) {
        result.uriPathNormalizationOptions_ = uriPathNormalizationOptions_;
      } else {
        result.uriPathNormalizationOptions_ = uriPathNormalizationOptionsBuilder_.build();
      }
      result.restrictHttpMethods_ = restrictHttpMethods_;
      result.headersWithUnderscoresAction_ = headersWithUnderscoresAction_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig) {
        return mergeFrom((io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig other) {
      if (other == io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.getDefaultInstance()) return this;
      if (other.hasHttp1ProtocolOptions()) {
        mergeHttp1ProtocolOptions(other.getHttp1ProtocolOptions());
      }
      if (other.hasUriPathNormalizationOptions()) {
        mergeUriPathNormalizationOptions(other.getUriPathNormalizationOptions());
      }
      if (other.getRestrictHttpMethods() != false) {
        setRestrictHttpMethods(other.getRestrictHttpMethods());
      }
      if (other.headersWithUnderscoresAction_ != 0) {
        setHeadersWithUnderscoresActionValue(other.getHeadersWithUnderscoresActionValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1ProtocolOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder> http1ProtocolOptionsBuilder_;
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     * @return Whether the http1ProtocolOptions field is set.
     */
    public boolean hasHttp1ProtocolOptions() {
      return http1ProtocolOptionsBuilder_ != null || http1ProtocolOptions_ != null;
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     * @return The http1ProtocolOptions.
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions getHttp1ProtocolOptions() {
      if (http1ProtocolOptionsBuilder_ == null) {
        return http1ProtocolOptions_ == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.getDefaultInstance() : http1ProtocolOptions_;
      } else {
        return http1ProtocolOptionsBuilder_.getMessage();
      }
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public Builder setHttp1ProtocolOptions(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions value) {
      if (http1ProtocolOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        http1ProtocolOptions_ = value;
        onChanged();
      } else {
        http1ProtocolOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public Builder setHttp1ProtocolOptions(
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder builderForValue) {
      if (http1ProtocolOptionsBuilder_ == null) {
        http1ProtocolOptions_ = builderForValue.build();
        onChanged();
      } else {
        http1ProtocolOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public Builder mergeHttp1ProtocolOptions(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions value) {
      if (http1ProtocolOptionsBuilder_ == null) {
        if (http1ProtocolOptions_ != null) {
          http1ProtocolOptions_ =
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.newBuilder(http1ProtocolOptions_).mergeFrom(value).buildPartial();
        } else {
          http1ProtocolOptions_ = value;
        }
        onChanged();
      } else {
        http1ProtocolOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public Builder clearHttp1ProtocolOptions() {
      if (http1ProtocolOptionsBuilder_ == null) {
        http1ProtocolOptions_ = null;
        onChanged();
      } else {
        http1ProtocolOptions_ = null;
        http1ProtocolOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder getHttp1ProtocolOptionsBuilder() {
      
      onChanged();
      return getHttp1ProtocolOptionsFieldBuilder().getBuilder();
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder getHttp1ProtocolOptionsOrBuilder() {
      if (http1ProtocolOptionsBuilder_ != null) {
        return http1ProtocolOptionsBuilder_.getMessageOrBuilder();
      } else {
        return http1ProtocolOptions_ == null ?
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.getDefaultInstance() : http1ProtocolOptions_;
      }
    }
    /**
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions http1_protocol_options = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder> 
        getHttp1ProtocolOptionsFieldBuilder() {
      if (http1ProtocolOptionsBuilder_ == null) {
        http1ProtocolOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.Http1ProtocolOptionsOrBuilder>(
                getHttp1ProtocolOptions(),
                getParentForChildren(),
                isClean());
        http1ProtocolOptions_ = null;
      }
      return http1ProtocolOptionsBuilder_;
    }

    private io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uriPathNormalizationOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder> uriPathNormalizationOptionsBuilder_;
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     * @return Whether the uriPathNormalizationOptions field is set.
     */
    public boolean hasUriPathNormalizationOptions() {
      return uriPathNormalizationOptionsBuilder_ != null || uriPathNormalizationOptions_ != null;
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     * @return The uriPathNormalizationOptions.
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions getUriPathNormalizationOptions() {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        return uriPathNormalizationOptions_ == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDefaultInstance() : uriPathNormalizationOptions_;
      } else {
        return uriPathNormalizationOptionsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public Builder setUriPathNormalizationOptions(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions value) {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        uriPathNormalizationOptions_ = value;
        onChanged();
      } else {
        uriPathNormalizationOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public Builder setUriPathNormalizationOptions(
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder builderForValue) {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        uriPathNormalizationOptions_ = builderForValue.build();
        onChanged();
      } else {
        uriPathNormalizationOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public Builder mergeUriPathNormalizationOptions(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions value) {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        if (uriPathNormalizationOptions_ != null) {
          uriPathNormalizationOptions_ =
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.newBuilder(uriPathNormalizationOptions_).mergeFrom(value).buildPartial();
        } else {
          uriPathNormalizationOptions_ = value;
        }
        onChanged();
      } else {
        uriPathNormalizationOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public Builder clearUriPathNormalizationOptions() {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        uriPathNormalizationOptions_ = null;
        onChanged();
      } else {
        uriPathNormalizationOptions_ = null;
        uriPathNormalizationOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder getUriPathNormalizationOptionsBuilder() {
      
      onChanged();
      return getUriPathNormalizationOptionsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder getUriPathNormalizationOptionsOrBuilder() {
      if (uriPathNormalizationOptionsBuilder_ != null) {
        return uriPathNormalizationOptionsBuilder_.getMessageOrBuilder();
      } else {
        return uriPathNormalizationOptions_ == null ?
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.getDefaultInstance() : uriPathNormalizationOptions_;
      }
    }
    /**
     * <pre>
     * The URI path normalization options.
     * By default Envoy normalizes URI path using the default values of the :ref:`UriPathNormalizationOptions
     * &lt;envoy_v3_api_msg_extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions&gt;`.
     * URI path transformations specified by the ``uri_path_normalization_options`` configuration can be applied to a portion
     * of requests by setting the ``envoy_default_header_validator.uri_path_transformations`` runtime value.
     * Caution: disabling path normalization may lead to path confusion vulnerabilities in access control or incorrect service
     * selection.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions uri_path_normalization_options = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder> 
        getUriPathNormalizationOptionsFieldBuilder() {
      if (uriPathNormalizationOptionsBuilder_ == null) {
        uriPathNormalizationOptionsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptions.Builder, io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.UriPathNormalizationOptionsOrBuilder>(
                getUriPathNormalizationOptions(),
                getParentForChildren(),
                isClean());
        uriPathNormalizationOptions_ = null;
      }
      return uriPathNormalizationOptionsBuilder_;
    }

    private boolean restrictHttpMethods_ ;
    /**
     * <pre>
     * Restrict HTTP methods to these defined in the `RFC 7231 section 4.1 &lt;https://datatracker.ietf.org/doc/html/rfc7231#section-4.1&gt;`_
     * Envoy will respond with 400 to requests with disallowed methods.
     * By default methods with arbitrary names are accepted.
     * </pre>
     *
     * <code>bool restrict_http_methods = 3;</code>
     * @return The restrictHttpMethods.
     */
    @java.lang.Override
    public boolean getRestrictHttpMethods() {
      return restrictHttpMethods_;
    }
    /**
     * <pre>
     * Restrict HTTP methods to these defined in the `RFC 7231 section 4.1 &lt;https://datatracker.ietf.org/doc/html/rfc7231#section-4.1&gt;`_
     * Envoy will respond with 400 to requests with disallowed methods.
     * By default methods with arbitrary names are accepted.
     * </pre>
     *
     * <code>bool restrict_http_methods = 3;</code>
     * @param value The restrictHttpMethods to set.
     * @return This builder for chaining.
     */
    public Builder setRestrictHttpMethods(boolean value) {
      
      restrictHttpMethods_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Restrict HTTP methods to these defined in the `RFC 7231 section 4.1 &lt;https://datatracker.ietf.org/doc/html/rfc7231#section-4.1&gt;`_
     * Envoy will respond with 400 to requests with disallowed methods.
     * By default methods with arbitrary names are accepted.
     * </pre>
     *
     * <code>bool restrict_http_methods = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearRestrictHttpMethods() {
      
      restrictHttpMethods_ = false;
      onChanged();
      return this;
    }

    private int headersWithUnderscoresAction_ = 0;
    /**
     * <pre>
     * Action to take when a client request with a header name containing underscore characters is received.
     * If this setting is not specified, the value defaults to ALLOW.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
     * @return The enum numeric value on the wire for headersWithUnderscoresAction.
     */
    @java.lang.Override public int getHeadersWithUnderscoresActionValue() {
      return headersWithUnderscoresAction_;
    }
    /**
     * <pre>
     * Action to take when a client request with a header name containing underscore characters is received.
     * If this setting is not specified, the value defaults to ALLOW.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
     * @param value The enum numeric value on the wire for headersWithUnderscoresAction to set.
     * @return This builder for chaining.
     */
    public Builder setHeadersWithUnderscoresActionValue(int value) {
      
      headersWithUnderscoresAction_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Action to take when a client request with a header name containing underscore characters is received.
     * If this setting is not specified, the value defaults to ALLOW.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
     * @return The headersWithUnderscoresAction.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction getHeadersWithUnderscoresAction() {
      @SuppressWarnings("deprecation")
      io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction result = io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.valueOf(headersWithUnderscoresAction_);
      return result == null ? io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Action to take when a client request with a header name containing underscore characters is received.
     * If this setting is not specified, the value defaults to ALLOW.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
     * @param value The headersWithUnderscoresAction to set.
     * @return This builder for chaining.
     */
    public Builder setHeadersWithUnderscoresAction(io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      headersWithUnderscoresAction_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Action to take when a client request with a header name containing underscore characters is received.
     * If this setting is not specified, the value defaults to ALLOW.
     * </pre>
     *
     * <code>.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig.HeadersWithUnderscoresAction headers_with_underscores_action = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearHeadersWithUnderscoresAction() {
      
      headersWithUnderscoresAction_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)
  }

  // @@protoc_insertion_point(class_scope:envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig)
  private static final io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig();
  }

  public static io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HeaderValidatorConfig>
      PARSER = new com.google.protobuf.AbstractParser<HeaderValidatorConfig>() {
    @java.lang.Override
    public HeaderValidatorConfig parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new HeaderValidatorConfig(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<HeaderValidatorConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HeaderValidatorConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.extensions.http.header_validators.envoy_default.v3.HeaderValidatorConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

