/*
 * Decompiled with CFR 0.152.
 */
package com.trasier.client.ws;

import com.trasier.client.api.Span;
import com.trasier.client.configuration.TrasierClientConfiguration;
import io.opentracing.propagation.TextMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.soap.SOAPMessageContext;

class SOAPMessageInjectAdapter
implements TextMap {
    private final TrasierClientConfiguration clientConfig;
    private final Span span;

    SOAPMessageInjectAdapter(SOAPMessageContext context, TrasierClientConfiguration clientConfig, Span span) {
        this.clientConfig = clientConfig;
        this.span = span;
        this.initHeaderMap(context);
        if (span.getIncomingHeader() == null) {
            span.setIncomingHeader(new HashMap());
        }
    }

    private Map<String, List<String>> initHeaderMap(SOAPMessageContext context) {
        HashMap<String, List<String>> headers = (HashMap<String, List<String>>)context.get((Object)"javax.xml.ws.http.request.headers");
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
            context.put((Object)"javax.xml.ws.http.request.headers", headers);
        }
        headers.put("X-Conversation-Id", Arrays.asList(this.span.getConversationId()));
        headers.put("X-Trace-Id", Arrays.asList(this.span.getTraceId()));
        headers.put("X-Span-Id", Arrays.asList(this.span.getId()));
        if (this.clientConfig.getSystemName() != null) {
            headers.put("X-Incoming-Endpoint-Name", Arrays.asList(this.clientConfig.getSystemName()));
        }
        return headers;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return null;
    }

    public void put(String key, String value) {
        if (value != null) {
            this.span.getIncomingHeader().put(key, value);
        }
    }
}

