/*
 * Decompiled with CFR 0.152.
 */
package com.trasier.client.ws;

import com.trasier.client.api.ContentType;
import com.trasier.client.api.Endpoint;
import com.trasier.client.api.Span;
import com.trasier.client.configuration.TrasierClientConfiguration;
import com.trasier.client.opentracing.TrasierScopeManager;
import com.trasier.client.opentracing.TrasierSpan;
import com.trasier.client.opentracing.TrasierTracer;
import com.trasier.client.util.LocalEndpointHolder;
import com.trasier.client.ws.SOAPMessageInjectAdapter;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingSoapHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracingSoapHandler.class);
    private final Tracer tracer;
    private final TrasierClientConfiguration clientConfig;

    public TracingSoapHandler(Tracer tracer, TrasierClientConfiguration clientConfig) {
        this.tracer = tracer;
        this.clientConfig = clientConfig;
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        if (this.tracer instanceof TrasierTracer && this.clientConfig.isActivated()) {
            this.handle(soapMessageContext, false);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext soapMessageContext) {
        if (this.tracer instanceof TrasierTracer && this.clientConfig.isActivated()) {
            this.handle(soapMessageContext, true);
        }
        return true;
    }

    private void handle(SOAPMessageContext soapMessageContext, boolean isFault) {
        TrasierSpan trasierSpan;
        TrasierTracer tracer = (TrasierTracer)this.tracer;
        boolean isRequest = (Boolean)soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (isRequest) {
            String methodName = this.resolveMethodName(soapMessageContext);
            trasierSpan = (TrasierSpan)tracer.buildSpan(methodName).withTag(Tags.SPAN_KIND.getKey(), "client").start();
            tracer.activateSpan((io.opentracing.Span)trasierSpan);
        } else {
            trasierSpan = (TrasierSpan)tracer.activeSpan();
        }
        Span span = trasierSpan.unwrap();
        try {
            tracer.inject(trasierSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new SOAPMessageInjectAdapter(soapMessageContext, this.clientConfig, span));
            String message = this.getMessagePayload(soapMessageContext);
            if (isRequest) {
                span.setIncomingContentType(ContentType.XML);
                span.setIncomingEndpoint(LocalEndpointHolder.getLocalEndpoint((String)this.clientConfig.getSystemName()));
                URL url = this.getOutgoingEndpointUrl(soapMessageContext);
                if (url != null) {
                    int indexOfDot = url.getHost().indexOf(".");
                    String endpointName = indexOfDot > 0 ? url.getHost().substring(0, indexOfDot) : url.getHost();
                    span.setOutgoingEndpoint(TracingSoapHandler.createEndpoint(endpointName, url.getHost(), url.getPort()));
                }
                span.setStartTimestamp(Long.valueOf(new Date().getTime()));
                span.setIncomingHeader(this.createIncommingHeaders(url));
                span.setIncomingData(message);
            } else {
                span.setOutgoingContentType(ContentType.XML);
                span.setEndTimestamp(Long.valueOf(new Date().getTime()));
                span.setOutgoingData(message);
                span.setStatus(isFault ? "ERROR" : "OK");
                TrasierScopeManager scopeManager = (TrasierScopeManager)tracer.scopeManager();
                scopeManager.activeScope().close();
                trasierSpan.finish();
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private URL getOutgoingEndpointUrl(SOAPMessageContext soapMessageContext) {
        HttpURLConnection httpConnection = (HttpURLConnection)soapMessageContext.get((Object)"http.connection");
        if (httpConnection != null && httpConnection.getURL() != null) {
            return httpConnection.getURL();
        }
        Object address = soapMessageContext.get((Object)"javax.xml.ws.service.endpoint.address");
        if (address instanceof String) {
            try {
                return new URL(String.valueOf(address));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    private String getMessagePayload(SOAPMessageContext soapMessageContext) throws SOAPException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessageContext.getMessage().writeTo((OutputStream)out);
        return out.toString();
    }

    private Map<String, String> createIncommingHeaders(URL url) {
        HashMap<String, String> traceableHeaders = new HashMap<String, String>();
        if (url != null) {
            traceableHeaders.put("url", url.toString());
        }
        return traceableHeaders;
    }

    private static Endpoint createEndpoint(String name, String host, Integer port) {
        Endpoint endpoint = new Endpoint(name);
        endpoint.setHostname(host);
        endpoint.setPort(String.valueOf(port));
        return endpoint;
    }

    private String resolveMethodName(SOAPMessageContext soapMessageContext) {
        Method method = (Method)soapMessageContext.get((Object)"java.lang.reflect.Method");
        String methodName = "soap";
        if (method != null) {
            methodName = method.getName();
        } else {
            Object operation = soapMessageContext.get((Object)"javax.xml.ws.wsdl.operation");
            if (operation instanceof QName) {
                methodName = ((QName)operation).getLocalPart();
            }
        }
        return methodName;
    }
}

