/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class TDClientException
extends RuntimeException {
    private final ErrorType errorType;
    private final Optional<Exception> rootCause;

    private static final String formatErrorMessage(ErrorType errorType, String message, Optional<Exception> cause) {
        String rootCauseErrorMessage = cause.isPresent() ? " The root cause: " + ((Exception)cause.get()).getMessage() : "";
        return String.format("[%s] %s%s", errorType.name(), message != null ? message : "", rootCauseErrorMessage);
    }

    public TDClientException(ErrorType errorType, String message, Optional<Exception> cause) {
        super(TDClientException.formatErrorMessage(errorType, message, cause));
        Preconditions.checkNotNull((Object)((Object)errorType), (Object)"errorType is null");
        Preconditions.checkNotNull(cause, (Object)"cause is null");
        this.errorType = errorType;
        this.rootCause = cause;
    }

    public TDClientException(ErrorType errorType, String message, Exception cause) {
        this(errorType, message, (Optional<Exception>)Optional.of((Object)cause));
    }

    public TDClientException(ErrorType errorType, Exception cause) {
        this(errorType, cause.getMessage(), (Optional<Exception>)Optional.of((Object)cause));
    }

    public TDClientException(ErrorType errorType, String message) {
        this(errorType, message, (Optional<Exception>)Optional.absent());
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<Exception> getRootCause() {
        return this.rootCause;
    }

    public static enum ErrorType {
        INVALID_CONFIGURATION,
        INVALID_INPUT,
        AUTHENTICATION_FAILURE,
        TARGET_NOT_FOUND,
        TARGET_ALREADY_EXISTS,
        SERVER_ERROR,
        CLIENT_ERROR,
        PROXY_AUTHENTICATION_FAILURE,
        INTERRUPTED,
        REQUEST_TIMEOUT,
        SSL_ERROR,
        EXECUTION_FAILURE,
        UNEXPECTED_RESPONSE_CODE,
        INVALID_JSON_RESPONSE,
        SOCKET_ERROR;

    }
}

