/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.treasuredata.client.model.TDSavedQueryStartRequestV4;
import java.util.ArrayList;

final class ImmutableTDSavedQueryStartRequestV4
extends TDSavedQueryStartRequestV4 {
    private final String scheduledTime;
    private final Optional<String> domainKey;

    private ImmutableTDSavedQueryStartRequestV4(String scheduledTime, Optional<String> domainKey) {
        this.scheduledTime = scheduledTime;
        this.domainKey = domainKey;
    }

    @Override
    @JsonProperty(value="scheduled_time")
    public String scheduledTime() {
        return this.scheduledTime;
    }

    @Override
    @JsonProperty(value="domain_key")
    public Optional<String> domainKey() {
        return this.domainKey;
    }

    public final ImmutableTDSavedQueryStartRequestV4 withScheduledTime(String scheduledTime) {
        if (this.scheduledTime.equals(scheduledTime)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)scheduledTime, (Object)"scheduledTime");
        return new ImmutableTDSavedQueryStartRequestV4(newValue, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequestV4 withDomainKey(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.domainKey.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, (Optional<String>)newValue);
    }

    public final ImmutableTDSavedQueryStartRequestV4 withDomainKey(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"domainKey");
        if (this.domainKey.equals((Object)value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, (Optional<String>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDSavedQueryStartRequestV4 && this.equalTo((ImmutableTDSavedQueryStartRequestV4)another);
    }

    private boolean equalTo(ImmutableTDSavedQueryStartRequestV4 another) {
        return this.scheduledTime.equals(another.scheduledTime) && this.domainKey.equals(another.domainKey);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.scheduledTime.hashCode();
        h = h * 17 + this.domainKey.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TDSavedQueryStartRequestV4").omitNullValues().add("scheduledTime", (Object)this.scheduledTime).add("domainKey", this.domainKey.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTDSavedQueryStartRequestV4 fromJson(Json json) {
        Builder builder = ImmutableTDSavedQueryStartRequestV4.builder();
        if (json.scheduledTime != null) {
            builder.scheduledTime(json.scheduledTime);
        }
        if (json.domainKey != null) {
            builder.domainKey((Optional)json.domainKey);
        }
        return builder.build();
    }

    public static ImmutableTDSavedQueryStartRequestV4 copyOf(TDSavedQueryStartRequestV4 instance) {
        if (instance instanceof ImmutableTDSavedQueryStartRequestV4) {
            return (ImmutableTDSavedQueryStartRequestV4)instance;
        }
        return ImmutableTDSavedQueryStartRequestV4.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements TDSavedQueryStartRequestV4.Builder {
        private static final long INIT_BIT_SCHEDULED_TIME = 1L;
        private long initBits = 1L;
        private String scheduledTime;
        private Optional<String> domainKey = Optional.absent();

        private Builder() {
        }

        public final Builder from(TDSavedQueryStartRequestV4 instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.scheduledTime(instance.scheduledTime());
            Optional<String> domainKeyOptional = instance.domainKey();
            if (domainKeyOptional.isPresent()) {
                this.domainKey((Optional)domainKeyOptional);
            }
            return this;
        }

        @Override
        public final Builder scheduledTime(String scheduledTime) {
            this.scheduledTime = (String)Preconditions.checkNotNull((Object)scheduledTime, (Object)"scheduledTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder domainKey(String domainKey) {
            this.domainKey = Optional.of((Object)domainKey);
            return this;
        }

        @Override
        public final Builder domainKey(Optional<String> domainKey) {
            this.domainKey = (Optional)Preconditions.checkNotNull(domainKey, (Object)"domainKey");
            return this;
        }

        @Override
        public ImmutableTDSavedQueryStartRequestV4 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, this.domainKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scheduledTime");
            }
            return "Cannot build TDSavedQueryStartRequestV4, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends TDSavedQueryStartRequestV4 {
        String scheduledTime;
        Optional<String> domainKey = Optional.absent();

        Json() {
        }

        @JsonProperty(value="scheduled_time")
        public void setScheduledTime(String scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @JsonProperty(value="domain_key")
        public void setDomainKey(Optional<String> domainKey) {
            this.domainKey = domainKey;
        }

        @Override
        public String scheduledTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domainKey() {
            throw new UnsupportedOperationException();
        }
    }
}

