/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class TDApiErrorMessage {
    private final String error;
    private final String text;
    private final String severity;
    private final Map<String, Object> details;

    public TDApiErrorMessage(String error, String text, String severity) {
        this(error, text, severity, (Map<String, Object>)ImmutableMap.of());
    }

    @JsonCreator
    public TDApiErrorMessage(@JsonProperty(value="error") String error, @JsonProperty(value="text") String text, @JsonProperty(value="severity") String severity, @JsonProperty(value="details") Map<String, Object> details) {
        this.error = error;
        this.text = text;
        this.severity = severity;
        this.details = details;
    }

    public String getError() {
        return this.error;
    }

    public String getText() {
        return this.text;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public String toString() {
        return String.format("[%s] %s", this.severity, this.text);
    }
}

