/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;

public enum TDExportFileFormatType {
    TSV_GZ("tsv.gz"),
    JSONL_GZ("jsonl.gz"),
    JSON_GZ("json.gz"),
    LINE_JSON_GZ("line-json.gz");

    private String name;

    private TDExportFileFormatType(String name) {
        this.name = name;
    }

    @JsonCreator
    public static TDExportFileFormatType fromName(String name) {
        if ("tsv.gz".equals(name)) {
            return TSV_GZ;
        }
        if ("jsonl.gz".equals(name)) {
            return JSONL_GZ;
        }
        if ("json.gz".equals(name)) {
            return JSON_GZ;
        }
        if ("line-json.gz".equals(name)) {
            return LINE_JSON_GZ;
        }
        throw new RuntimeJsonMappingException("Unexpected export file format type");
    }

    public String getTypeName() {
        return this.name;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }
}

