/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.treasuredata.client.model.TDExportFileFormatType;
import com.treasuredata.client.model.TDExportJobRequest;
import java.util.ArrayList;
import java.util.Date;

public final class TDExportJobRequestBuilder {
    private static final long INIT_BIT_DATABASE = 1L;
    private static final long INIT_BIT_TABLE = 2L;
    private static final long INIT_BIT_FROM = 4L;
    private static final long INIT_BIT_TO = 8L;
    private static final long INIT_BIT_FILE_FORMAT = 16L;
    private static final long INIT_BIT_ACCESS_KEY_ID = 32L;
    private static final long INIT_BIT_SECRET_ACCESS_KEY = 64L;
    private static final long INIT_BIT_BUCKET_NAME = 128L;
    private static final long INIT_BIT_FILE_PREFIX = 256L;
    private long initBits = 511L;
    private String database;
    private String table;
    private Date from;
    private Date to;
    private TDExportFileFormatType fileFormat;
    private String accessKeyId;
    private String secretAccessKey;
    private String bucketName;
    private String filePrefix;
    private Optional<String> poolName = Optional.absent();
    private Optional<String> domainKey = Optional.absent();

    public final TDExportJobRequestBuilder database(String database) {
        this.database = (String)Preconditions.checkNotNull((Object)database, (Object)"database");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final TDExportJobRequestBuilder table(String table) {
        this.table = (String)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final TDExportJobRequestBuilder from(Date from) {
        this.from = (Date)Preconditions.checkNotNull((Object)from, (Object)"from");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final TDExportJobRequestBuilder to(Date to) {
        this.to = (Date)Preconditions.checkNotNull((Object)to, (Object)"to");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final TDExportJobRequestBuilder fileFormat(TDExportFileFormatType fileFormat) {
        this.fileFormat = (TDExportFileFormatType)((Object)Preconditions.checkNotNull((Object)((Object)fileFormat), (Object)"fileFormat"));
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public final TDExportJobRequestBuilder accessKeyId(String accessKeyId) {
        this.accessKeyId = (String)Preconditions.checkNotNull((Object)accessKeyId, (Object)"accessKeyId");
        this.initBits &= 0xFFFFFFFFFFFFFFDFL;
        return this;
    }

    public final TDExportJobRequestBuilder secretAccessKey(String secretAccessKey) {
        this.secretAccessKey = (String)Preconditions.checkNotNull((Object)secretAccessKey, (Object)"secretAccessKey");
        this.initBits &= 0xFFFFFFFFFFFFFFBFL;
        return this;
    }

    public final TDExportJobRequestBuilder bucketName(String bucketName) {
        this.bucketName = (String)Preconditions.checkNotNull((Object)bucketName, (Object)"bucketName");
        this.initBits &= 0xFFFFFFFFFFFFFF7FL;
        return this;
    }

    public final TDExportJobRequestBuilder filePrefix(String filePrefix) {
        this.filePrefix = (String)Preconditions.checkNotNull((Object)filePrefix, (Object)"filePrefix");
        this.initBits &= 0xFFFFFFFFFFFFFEFFL;
        return this;
    }

    public final TDExportJobRequestBuilder poolName(String poolName) {
        this.poolName = Optional.of((Object)poolName);
        return this;
    }

    public final TDExportJobRequestBuilder poolName(Optional<String> poolName) {
        this.poolName = (Optional)Preconditions.checkNotNull(poolName, (Object)"poolName");
        return this;
    }

    public final TDExportJobRequestBuilder domainKey(String domainKey) {
        this.domainKey = Optional.of((Object)domainKey);
        return this;
    }

    public final TDExportJobRequestBuilder domainKey(Optional<String> domainKey) {
        this.domainKey = (Optional)Preconditions.checkNotNull(domainKey, (Object)"domainKey");
        return this;
    }

    public TDExportJobRequest build() {
        this.checkRequiredAttributes();
        return TDExportJobRequest.of(this.database, this.table, this.from, this.to, this.fileFormat, this.accessKeyId, this.secretAccessKey, this.bucketName, this.filePrefix, this.poolName, this.domainKey);
    }

    private boolean databaseIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean tableIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean fromIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean toIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean fileFormatIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private boolean accessKeyIdIsSet() {
        return (this.initBits & 0x20L) == 0L;
    }

    private boolean secretAccessKeyIsSet() {
        return (this.initBits & 0x40L) == 0L;
    }

    private boolean bucketNameIsSet() {
        return (this.initBits & 0x80L) == 0L;
    }

    private boolean filePrefixIsSet() {
        return (this.initBits & 0x100L) == 0L;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if (!this.databaseIsSet()) {
            attributes.add("database");
        }
        if (!this.tableIsSet()) {
            attributes.add("table");
        }
        if (!this.fromIsSet()) {
            attributes.add("from");
        }
        if (!this.toIsSet()) {
            attributes.add("to");
        }
        if (!this.fileFormatIsSet()) {
            attributes.add("fileFormat");
        }
        if (!this.accessKeyIdIsSet()) {
            attributes.add("accessKeyId");
        }
        if (!this.secretAccessKeyIsSet()) {
            attributes.add("secretAccessKey");
        }
        if (!this.bucketNameIsSet()) {
            attributes.add("bucketName");
        }
        if (!this.filePrefixIsSet()) {
            attributes.add("filePrefix");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

