/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.treasuredata.client.model.TDExportResultJobRequest;
import java.util.ArrayList;

public final class TDExportResultJobRequestBuilder {
    private static final long INIT_BIT_JOB_ID = 1L;
    private long initBits = 1L;
    private String jobId;
    private Optional<String> resultOutput = Optional.absent();
    private Optional<String> resultConnectionId = Optional.absent();
    private Optional<String> resultConnectionSettings = Optional.absent();

    public final TDExportResultJobRequestBuilder jobId(String jobId) {
        this.jobId = (String)Preconditions.checkNotNull((Object)jobId, (Object)"jobId");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final TDExportResultJobRequestBuilder resultOutput(String resultOutput) {
        this.resultOutput = Optional.of((Object)resultOutput);
        return this;
    }

    public final TDExportResultJobRequestBuilder resultOutput(Optional<String> resultOutput) {
        this.resultOutput = (Optional)Preconditions.checkNotNull(resultOutput, (Object)"resultOutput");
        return this;
    }

    public final TDExportResultJobRequestBuilder resultConnectionId(String resultConnectionId) {
        this.resultConnectionId = Optional.of((Object)resultConnectionId);
        return this;
    }

    public final TDExportResultJobRequestBuilder resultConnectionId(Optional<String> resultConnectionId) {
        this.resultConnectionId = (Optional)Preconditions.checkNotNull(resultConnectionId, (Object)"resultConnectionId");
        return this;
    }

    public final TDExportResultJobRequestBuilder resultConnectionSettings(String resultConnectionSettings) {
        this.resultConnectionSettings = Optional.of((Object)resultConnectionSettings);
        return this;
    }

    public final TDExportResultJobRequestBuilder resultConnectionSettings(Optional<String> resultConnectionSettings) {
        this.resultConnectionSettings = (Optional)Preconditions.checkNotNull(resultConnectionSettings, (Object)"resultConnectionSettings");
        return this;
    }

    public TDExportResultJobRequest build() {
        this.checkRequiredAttributes();
        return TDExportResultJobRequest.of(this.jobId, this.resultOutput, this.resultConnectionId, this.resultConnectionSettings);
    }

    private boolean jobIdIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if (!this.jobIdIsSet()) {
            attributes.add("jobId");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

