/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.google.common.base.Optional;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDSaveQueryRequest;

public class TDSavedQueryBuilder {
    private Optional<String> name = Optional.absent();
    private Optional<String> cron = Optional.absent();
    private Optional<TDJob.Type> type = Optional.absent();
    private Optional<String> query = Optional.absent();
    private Optional<String> timezone = Optional.absent();
    private Optional<Long> delay = Optional.absent();
    private Optional<String> database = Optional.absent();
    private Optional<Integer> priority = Optional.absent();
    private Optional<Integer> retryLimit = Optional.absent();
    private Optional<String> result = Optional.absent();
    private Optional<TDJob.EngineVersion> engineVersion = Optional.absent();

    public TDSavedQueryBuilder setName(String name) {
        this.name = Optional.of((Object)name);
        return this;
    }

    public TDSavedQueryBuilder setCron(String cron) {
        this.cron = Optional.of((Object)cron);
        return this;
    }

    public TDSavedQueryBuilder setType(TDJob.Type type) {
        this.type = Optional.of((Object)((Object)type));
        return this;
    }

    public TDSavedQueryBuilder setQuery(String query) {
        this.query = Optional.of((Object)query);
        return this;
    }

    public TDSavedQueryBuilder setTimezone(String timezone) {
        this.timezone = Optional.of((Object)timezone);
        return this;
    }

    public TDSavedQueryBuilder setDelay(long delay) {
        this.delay = Optional.of((Object)delay);
        return this;
    }

    public TDSavedQueryBuilder setDatabase(String database) {
        this.database = Optional.of((Object)database);
        return this;
    }

    public TDSavedQueryBuilder setPriority(int priority) {
        this.priority = Optional.of((Object)priority);
        return this;
    }

    public TDSavedQueryBuilder setRetryLimit(int retryLimit) {
        this.retryLimit = Optional.of((Object)retryLimit);
        return this;
    }

    public TDSavedQueryBuilder setResult(String result) {
        this.result = Optional.of((Object)result);
        return this;
    }

    public TDSavedQueryBuilder setEngineVersion(TDJob.EngineVersion engineVersion) {
        this.engineVersion = Optional.fromNullable((Object)engineVersion);
        return this;
    }

    private static <T> void checkPresence(Optional<T> opt, String errorMessage) {
        if (!opt.isPresent()) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, errorMessage);
        }
    }

    public TDSaveQueryRequest build() {
        TDSavedQueryBuilder.checkPresence(this.name, "name is not set");
        TDSavedQueryBuilder.checkPresence(this.type, "job type is not set");
        TDSavedQueryBuilder.checkPresence(this.query, "query is not set");
        TDSavedQueryBuilder.checkPresence(this.timezone, "timezone is not set. Use UTC, US/Pacific, Asia/Tokyo, etc.");
        TDSavedQueryBuilder.checkPresence(this.database, "database is not set");
        return new TDSaveQueryRequest((String)this.name.get(), (String)this.cron.or((Object)""), (TDJob.Type)((Object)this.type.get()), (String)this.query.get(), (String)this.timezone.get(), (Long)this.delay.or((Object)0L), (String)this.database.get(), (Integer)this.priority.or((Object)TDJob.Priority.NORMAL.toInt()), (Integer)this.retryLimit.or((Object)0), (String)this.result.or((Object)""), (TDJob.EngineVersion)this.engineVersion.orNull());
    }

    protected TDSavedQueryBuilder(String name) {
        this.setName(name);
    }
}

