/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDSaveQueryRequest;
import com.treasuredata.client.model.TDSavedQuery;

public class TDSavedQueryUpdateRequest {
    private final Optional<String> name;
    private final Optional<String> cron;
    private final Optional<TDJob.Type> type;
    private final Optional<String> query;
    private final Optional<String> timezone;
    private final Optional<Long> delay;
    private final Optional<String> database;
    private final Optional<Integer> priority;
    private final Optional<Integer> retryLimit;
    private final Optional<String> result;
    private final Optional<TDJob.EngineVersion> engineVersion;

    @JsonCreator
    @VisibleForTesting
    TDSavedQueryUpdateRequest(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="cron") Optional<String> cron, @JsonProperty(value="type") Optional<TDJob.Type> type, @JsonProperty(value="query") Optional<String> query, @JsonProperty(value="timezone") Optional<String> timezone, @JsonProperty(value="delay") Optional<Long> delay, @JsonProperty(value="database") Optional<String> database, @JsonProperty(value="priority") Optional<Integer> priority, @JsonProperty(value="retry_limit") Optional<Integer> retryLimit, @JsonProperty(value="result") Optional<String> result, @JsonProperty(value="engine_version") Optional<TDJob.EngineVersion> engineVersion) {
        this.name = name;
        this.cron = cron;
        this.type = type;
        this.query = query;
        this.timezone = timezone;
        this.delay = delay;
        this.database = database;
        this.priority = priority;
        this.retryLimit = retryLimit;
        this.result = result;
        this.engineVersion = engineVersion;
    }

    @VisibleForTesting
    static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule().configureAbsentsAsNulls(false));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        return mapper;
    }

    public String toJson() {
        try {
            return TDSavedQueryUpdateRequest.getObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("Failed to produce json data of TDSavedQueryUpdateRequest: %s", this), e);
        }
    }

    @VisibleForTesting
    public TDSaveQueryRequest merge(TDSavedQuery base) {
        return new TDSaveQueryRequest((String)this.name.or((Object)base.getName()), (String)this.cron.or((Object)base.getCron()), (TDJob.Type)((Object)this.type.or((Object)base.getType())), (String)this.query.or((Object)base.getQuery()), (String)this.timezone.or((Object)base.getTimezone()), (Long)this.delay.or((Object)base.getDelay()), (String)this.database.or((Object)base.getDatabase()), (Integer)this.priority.or((Object)base.getPriority()), (Integer)this.retryLimit.or((Object)base.getRetryLimit()), (String)this.result.or((Object)base.getResult()), this.engineVersion.isPresent() ? (TDJob.EngineVersion)this.engineVersion.get() : base.getEngineVersion());
    }

    @JsonProperty
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty
    public Optional<String> getCron() {
        return this.cron;
    }

    @JsonProperty
    public Optional<TDJob.Type> getType() {
        return this.type;
    }

    @JsonProperty
    public Optional<String> getQuery() {
        return this.query;
    }

    @JsonProperty
    public Optional<String> getTimezone() {
        return this.timezone;
    }

    @JsonProperty
    public Optional<Long> getDelay() {
        return this.delay;
    }

    @JsonProperty
    public Optional<String> getDatabase() {
        return this.database;
    }

    @JsonProperty
    public Optional<Integer> getPriority() {
        return this.priority;
    }

    @JsonProperty(value="retry_limit")
    public Optional<Integer> getRetryLimit() {
        return this.retryLimit;
    }

    @JsonProperty
    public Optional<String> getResult() {
        return this.result;
    }

    @JsonProperty(value="engine_version")
    public Optional<TDJob.EngineVersion> getEngineVersion() {
        return this.engineVersion;
    }

    public String toString() {
        return "TDSavedQueryUpdateRequest{name=" + this.name + ", cron=" + this.cron + ", type=" + this.type + ", query=" + this.query + ", timezone=" + this.timezone + ", delay=" + this.delay + ", database=" + this.database + ", priority=" + this.priority + ", retryLimit=" + this.retryLimit + ", result=" + this.result + ", engineVersion=" + this.engineVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TDSavedQueryUpdateRequest that = (TDSavedQueryUpdateRequest)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.cron != null ? !this.cron.equals(that.cron) : that.cron != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) {
            return false;
        }
        if (this.delay != null ? !this.delay.equals(that.delay) : that.delay != null) {
            return false;
        }
        if (this.database != null ? !this.database.equals(that.database) : that.database != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.retryLimit != null ? !this.retryLimit.equals(that.retryLimit) : that.retryLimit != null) {
            return false;
        }
        if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) {
            return false;
        }
        return this.result != null ? this.result.equals(that.result) : that.result == null;
    }

    public int hashCode() {
        int result1 = this.name != null ? this.name.hashCode() : 0;
        result1 = 31 * result1 + (this.cron != null ? this.cron.hashCode() : 0);
        result1 = 31 * result1 + (this.type != null ? this.type.hashCode() : 0);
        result1 = 31 * result1 + (this.query != null ? this.query.hashCode() : 0);
        result1 = 31 * result1 + (this.timezone != null ? this.timezone.hashCode() : 0);
        result1 = 31 * result1 + (this.delay != null ? this.delay.hashCode() : 0);
        result1 = 31 * result1 + (this.database != null ? this.database.hashCode() : 0);
        result1 = 31 * result1 + (this.priority != null ? this.priority.hashCode() : 0);
        result1 = 31 * result1 + (this.retryLimit != null ? this.retryLimit.hashCode() : 0);
        result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
        result1 = 31 * result1 + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
        return result1;
    }
}

