/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client.bulkimport;

import com.treasure_data.client.ClientException;
import com.treasure_data.client.TreasureDataClient;
import com.treasure_data.client.bulkimport.BulkImportClientAdaptor;
import com.treasure_data.client.bulkimport.BulkImportClientAdaptorImpl;
import com.treasure_data.model.bulkimport.CommitSessionRequest;
import com.treasure_data.model.bulkimport.CommitSessionResult;
import com.treasure_data.model.bulkimport.CreateSessionRequest;
import com.treasure_data.model.bulkimport.CreateSessionResult;
import com.treasure_data.model.bulkimport.DeletePartRequest;
import com.treasure_data.model.bulkimport.DeletePartResult;
import com.treasure_data.model.bulkimport.DeleteSessionRequest;
import com.treasure_data.model.bulkimport.DeleteSessionResult;
import com.treasure_data.model.bulkimport.FreezeSessionRequest;
import com.treasure_data.model.bulkimport.FreezeSessionResult;
import com.treasure_data.model.bulkimport.GetErrorRecordsRequest;
import com.treasure_data.model.bulkimport.GetErrorRecordsResult;
import com.treasure_data.model.bulkimport.ListPartsRequest;
import com.treasure_data.model.bulkimport.ListPartsResult;
import com.treasure_data.model.bulkimport.ListSessionsRequest;
import com.treasure_data.model.bulkimport.ListSessionsResult;
import com.treasure_data.model.bulkimport.PerformSessionRequest;
import com.treasure_data.model.bulkimport.PerformSessionResult;
import com.treasure_data.model.bulkimport.Session;
import com.treasure_data.model.bulkimport.SessionSummary;
import com.treasure_data.model.bulkimport.ShowSessionRequest;
import com.treasure_data.model.bulkimport.ShowSessionResult;
import com.treasure_data.model.bulkimport.UnfreezeSessionRequest;
import com.treasure_data.model.bulkimport.UnfreezeSessionResult;
import com.treasure_data.model.bulkimport.UploadPartRequest;
import com.treasure_data.model.bulkimport.UploadPartResult;
import java.io.InputStream;
import java.util.List;
import org.msgpack.unpacker.Unpacker;

public class BulkImportClient {
    private BulkImportClientAdaptor clientAdaptor;

    public BulkImportClient(TreasureDataClient client) {
        this.clientAdaptor = new BulkImportClientAdaptorImpl(client);
    }

    public SessionSummary showSession(String sessionName) throws ClientException {
        return (SessionSummary)this.showSession(new ShowSessionRequest(new Session(sessionName, null, null))).getSession();
    }

    public ShowSessionResult showSession(ShowSessionRequest request) throws ClientException {
        return this.clientAdaptor.showSession(request);
    }

    public List<SessionSummary> listSessions() throws ClientException {
        return this.listSessions(new ListSessionsRequest()).getSessions();
    }

    public ListSessionsResult listSessions(ListSessionsRequest request) throws ClientException {
        return this.clientAdaptor.listSessions(request);
    }

    public List<String> listParts(Session sess) throws ClientException {
        return this.listParts(new ListPartsRequest(sess)).getParts();
    }

    public ListPartsResult listParts(ListPartsRequest request) throws ClientException {
        return this.clientAdaptor.listParts(request);
    }

    public Session createSession(String sessName, String databaseName, String tableName) throws ClientException {
        return this.createSession(new CreateSessionRequest(sessName, databaseName, tableName)).getSession();
    }

    public CreateSessionResult createSession(CreateSessionRequest request) throws ClientException {
        return this.clientAdaptor.createSession(request);
    }

    public void uploadPart(Session sess, String partID, byte[] bytes) throws ClientException {
        this.uploadPart(new UploadPartRequest(sess, partID, bytes));
    }

    public void uploadPart(Session sess, String partID, InputStream in, int size) throws ClientException {
        this.uploadPart(new UploadPartRequest(sess, partID, in, size));
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws ClientException {
        return this.clientAdaptor.uploadPart(request);
    }

    public void deletePart(Session sess, String partID) throws ClientException {
        this.deletePart(new DeletePartRequest(sess, partID));
    }

    public DeletePartResult deletePart(DeletePartRequest request) throws ClientException {
        return this.clientAdaptor.deletePart(request);
    }

    public void performSession(Session sess) throws ClientException {
        this.performSession(new PerformSessionRequest(sess));
    }

    public PerformSessionResult performSession(PerformSessionRequest request) throws ClientException {
        return this.clientAdaptor.performSession(request);
    }

    public Unpacker getErrorRecords(Session sess) throws ClientException {
        return this.getErrorRecords(new GetErrorRecordsRequest(sess)).getErrorRecords();
    }

    public GetErrorRecordsResult getErrorRecords(GetErrorRecordsRequest request) throws ClientException {
        return this.clientAdaptor.getErrorRecords(request);
    }

    public void commitSession(Session sess) throws ClientException {
        this.commitSession(new CommitSessionRequest(sess));
    }

    public CommitSessionResult commitSession(CommitSessionRequest request) throws ClientException {
        return this.clientAdaptor.commitSession(request);
    }

    public void deleteSession(String sessionName) throws ClientException {
        this.deleteSession(new Session(sessionName, null, null));
    }

    public void deleteSession(Session sess) throws ClientException {
        this.deleteSession(new DeleteSessionRequest(sess));
    }

    public DeleteSessionResult deleteSession(DeleteSessionRequest request) throws ClientException {
        return this.clientAdaptor.deleteSession(request);
    }

    public void freezeSession(Session sess) throws ClientException {
        this.freezeSession(new FreezeSessionRequest(sess));
    }

    public FreezeSessionResult freezeSession(FreezeSessionRequest request) throws ClientException {
        return this.clientAdaptor.freezeSession(request);
    }

    public void unfreezeSession(Session sess) throws ClientException {
        this.unfreezeSession(new UnfreezeSessionRequest(sess));
    }

    public UnfreezeSessionResult unfreezeSession(UnfreezeSessionRequest request) throws ClientException {
        return this.clientAdaptor.unfreezeSession(request);
    }
}

