/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client.bulkimport;

import com.treasure_data.client.AbstractClientAdaptor;
import com.treasure_data.client.ClientException;
import com.treasure_data.client.DefaultClientAdaptorImpl;
import com.treasure_data.client.HttpClientException;
import com.treasure_data.client.HttpConnectionImpl;
import com.treasure_data.client.TreasureDataClient;
import com.treasure_data.client.Validator;
import com.treasure_data.client.bulkimport.BulkImportClientAdaptor;
import com.treasure_data.model.bulkimport.CommitSessionRequest;
import com.treasure_data.model.bulkimport.CommitSessionResult;
import com.treasure_data.model.bulkimport.CreateSessionRequest;
import com.treasure_data.model.bulkimport.CreateSessionResult;
import com.treasure_data.model.bulkimport.DeletePartRequest;
import com.treasure_data.model.bulkimport.DeletePartResult;
import com.treasure_data.model.bulkimport.DeleteSessionRequest;
import com.treasure_data.model.bulkimport.DeleteSessionResult;
import com.treasure_data.model.bulkimport.FreezeSessionRequest;
import com.treasure_data.model.bulkimport.FreezeSessionResult;
import com.treasure_data.model.bulkimport.GetErrorRecordsRequest;
import com.treasure_data.model.bulkimport.GetErrorRecordsResult;
import com.treasure_data.model.bulkimport.ListPartsRequest;
import com.treasure_data.model.bulkimport.ListPartsResult;
import com.treasure_data.model.bulkimport.ListSessions;
import com.treasure_data.model.bulkimport.ListSessionsRequest;
import com.treasure_data.model.bulkimport.ListSessionsResult;
import com.treasure_data.model.bulkimport.PerformSessionRequest;
import com.treasure_data.model.bulkimport.PerformSessionResult;
import com.treasure_data.model.bulkimport.Session;
import com.treasure_data.model.bulkimport.SessionSummary;
import com.treasure_data.model.bulkimport.ShowSessionRequest;
import com.treasure_data.model.bulkimport.ShowSessionResult;
import com.treasure_data.model.bulkimport.UnfreezeSessionRequest;
import com.treasure_data.model.bulkimport.UnfreezeSessionResult;
import com.treasure_data.model.bulkimport.UploadPartRequest;
import com.treasure_data.model.bulkimport.UploadPartResult;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONValue;
import org.msgpack.unpacker.Unpacker;

public class BulkImportClientAdaptorImpl
extends AbstractClientAdaptor
implements BulkImportClientAdaptor {
    private static Logger LOG = Logger.getLogger(BulkImportClientAdaptorImpl.class.getName());
    private TreasureDataClient client;
    private Validator validator;
    private HttpConnectionImpl conn;

    BulkImportClientAdaptorImpl(TreasureDataClient client) {
        super(client.getConfig());
        this.client = client;
        this.validator = new Validator();
    }

    @Override
    public ShowSessionResult showSession(ShowSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        String message = null;
        int code = 0;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/show/%s", request.getSessionName());
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Show session failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Show session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "showSession", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Show session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map sess = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, sess);
        String name = (String)sess.get("name");
        String database = (String)sess.get("database");
        String table = (String)sess.get("table");
        String status = (String)sess.get("status");
        boolean upload_frozen = (Boolean)sess.get("upload_frozen");
        String job_id = DefaultClientAdaptorImpl.getJobID(sess);
        Long vr = (Long)sess.get("valid_records");
        long valid_records = vr != null ? vr : 0L;
        Long er = (Long)sess.get("error_records");
        long error_records = er != null ? er : 0L;
        Long vp = (Long)sess.get("valid_parts");
        long valid_parts = vp != null ? vp : 0L;
        Long ep = (Long)sess.get("error_parts");
        long error_parts = ep != null ? ep : 0L;
        SessionSummary summary = new SessionSummary(name, database, table, SessionSummary.Status.fromString(status), upload_frozen, job_id, valid_records, error_records, valid_parts, error_parts);
        return new ShowSessionResult(summary);
    }

    @Override
    public ListSessionsResult listSessions(ListSessionsRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        String message = null;
        int code = 0;
        try {
            this.conn = this.createConnection();
            String path = "/v3/bulk_import/list";
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("List sessions failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("List sessions failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "listSessions", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("List sessions failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        Iterator sessIter = ((List)map.get("bulk_imports")).iterator();
        ArrayList<SessionSummary> sessions = new ArrayList<SessionSummary>();
        while (sessIter.hasNext()) {
            Map sess = (Map)sessIter.next();
            String name = (String)sess.get("name");
            String database = (String)sess.get("database");
            String table = (String)sess.get("table");
            String status = (String)sess.get("status");
            boolean upload_frozen = (Boolean)sess.get("upload_frozen");
            String job_id = (String)sess.get("job_id");
            Long vr = (Long)sess.get("valid_records");
            long valid_records = vr != null ? vr : 0L;
            Long er = (Long)sess.get("error_records");
            long error_records = er != null ? er : 0L;
            Long vp = (Long)sess.get("valid_parts");
            long valid_parts = vp != null ? vp : 0L;
            Long ep = (Long)sess.get("error_parts");
            long error_parts = ep != null ? ep : 0L;
            SessionSummary summary = new SessionSummary(name, database, table, SessionSummary.Status.fromString(status), upload_frozen, job_id, valid_records, error_records, valid_parts, error_parts);
            sessions.add(summary);
        }
        return new ListSessionsResult(new ListSessions<SessionSummary>(sessions));
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/list_parts/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("List parts failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("List parts failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "listParts", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("List parts failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        List parts = (List)map.get("parts");
        return new ListPartsResult((Session)request.getSession(), parts);
    }

    @Override
    public CreateSessionResult createSession(CreateSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/create/%s/%s/%s", HttpConnectionImpl.e(request.getSessionName()), HttpConnectionImpl.e(request.getDatabaseName()), HttpConnectionImpl.e(request.getTableName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                throw new HttpClientException("Create session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            throw new HttpClientException("Create session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new CreateSessionResult(request.getSession());
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/upload_part/%s/%s", HttpConnectionImpl.e(request.getSessionName()), HttpConnectionImpl.e(request.getPartID()));
            this.conn.doPutRequest(request, path, request.getInputStream(), request.getSize());
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Upload part failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Upload part failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "uploadPart", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Upload part failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new UploadPartResult((Session)request.getSession());
    }

    @Override
    public DeletePartResult deletePart(DeletePartRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/delete_part/%s/%s", HttpConnectionImpl.e(request.getSessionName()), HttpConnectionImpl.e(request.getPartID()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Delete part failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Delete part failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "deletePart", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Delete part failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new DeletePartResult((Session)request.getSession());
    }

    @Override
    public PerformSessionResult performSession(PerformSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/perform/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("priority", Integer.toString(request.getPriority().getPriority()));
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Perform session failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Perform session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "performSession", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Perform session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new PerformSessionResult((Session)request.getSession());
    }

    @Override
    public GetErrorRecordsResult getErrorRecords(GetErrorRecordsRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        Unpacker unpacker = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/error_records/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Get error_records failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Get error_records failed", message + ", detail = " + errMessage, code);
            }
            try {
                unpacker = this.conn.getResponseBodyBinary();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "getErrorRecords", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Get error_records failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        return new GetErrorRecordsResult((Session)request.getSession(), unpacker);
    }

    @Override
    public CommitSessionResult commitSession(CommitSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/commit/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Commit session failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Commit session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "commitSession", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Commit session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new CommitSessionResult((Session)request.getSession());
    }

    @Override
    public DeleteSessionResult deleteSession(DeleteSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/delete/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                throw new HttpClientException("Delete session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            throw new HttpClientException("Delete session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new DeleteSessionResult((Session)request.getSession());
    }

    @Override
    public FreezeSessionResult freezeSession(FreezeSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/freeze/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Freeze session failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Freeze session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "freezeSession", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Freeze session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new FreezeSessionResult((Session)request.getSession());
    }

    @Override
    public UnfreezeSessionResult unfreezeSession(UnfreezeSessionRequest request) throws ClientException {
        request.setCredentials(this.client.getTreasureDataCredentials());
        this.validator.validateCredentials(this.client, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/bulk_import/unfreeze/%s", HttpConnectionImpl.e(request.getSessionName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Unfreeze session failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Unfreeze session failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "unfreezeSession", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Unfreeze session failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new UnfreezeSessionResult((Session)request.getSession());
    }

    static interface HttpURL {
        public static final String V3_SHOW = "/v3/bulk_import/show/%s";
        public static final String V3_LIST = "/v3/bulk_import/list";
        public static final String V3_CREATE = "/v3/bulk_import/create/%s/%s/%s";
        public static final String V3_DELETE = "/v3/bulk_import/delete/%s";
        public static final String V3_UPLOAD_PART = "/v3/bulk_import/upload_part/%s/%s";
        public static final String V3_DELETE_PART = "/v3/bulk_import/delete_part/%s/%s";
        public static final String V3_LIST_PARTS = "/v3/bulk_import/list_parts/%s";
        public static final String V3_FREEZE = "/v3/bulk_import/freeze/%s";
        public static final String V3_UNFREEZE = "/v3/bulk_import/unfreeze/%s";
        public static final String V3_PERFORM = "/v3/bulk_import/perform/%s";
        public static final String V3_COMMIT = "/v3/bulk_import/commit/%s";
        public static final String V3_ERROR_RECORDS = "/v3/bulk_import/error_records/%s";
        public static final String V3_PERFORM_FINISHED = "/v3/bulk_import/perform_finished/%s";
        public static final String V3_COMMIT_FINISHED = "/v3/bulk_import/commit_finished/%s";
    }
}

