/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model;

import com.treasure_data.model.Table;
import com.treasure_data.model.TableSpecifyRequest;

public class DeletePartialTableRequest
extends TableSpecifyRequest<Table> {
    private long from;
    private long to;

    public DeletePartialTableRequest(Table table, long from, long to) {
        super(table);
        this.from = from;
        this.to = to;
        this.validateParameters();
    }

    private void validateParameters() {
        if (this.to <= 0L) {
            throw new IllegalArgumentException(String.format("'to' must be a positive number: to=%d", this.to));
        }
        if (this.to % 3600L != 0L) {
            throw new IllegalArgumentException(String.format("'to' parameter must be a multiple of 3600: to=%d", this.to));
        }
        if (this.from < 0L) {
            throw new IllegalArgumentException(String.format("'from' must be a positive number (>= 0): from=%d", this.from));
        }
        if (this.to - this.from <= 0L) {
            throw new IllegalArgumentException(String.format("'from' must be less than 'to': from=%d", this.from));
        }
        if (this.from % 3600L != 0L) {
            throw new IllegalArgumentException(String.format("'from' parameter must be a multiple of 3600: from=%d", this.from));
        }
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }
}

