/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model;

import com.treasure_data.model.AbstractModel;
import com.treasure_data.model.Database;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Job
extends AbstractModel {
    private Type type;
    private Database database;
    private String url;
    private String query;
    private String resultTable;
    private Priority priority = Priority.NORMAL;
    private int retryLimit = 0;

    public static Type toType(String typeName) {
        return Type.StringToType.get(typeName);
    }

    public static String toTypeName(Type type) {
        return type.type();
    }

    public Job(String jobID) {
        this(jobID, Type.HIVE, null, null, null);
    }

    public Job(Database database, String query) {
        this(database, query, null);
    }

    public Job(Database database, String query, Priority priority, int retryLimit) {
        this(null, Type.HIVE, database, null, null);
        this.setQuery(query);
        this.setPriority(priority);
        this.setRetryLimit(retryLimit);
    }

    public Job(Database database, String query, String resultTable) {
        this(null, Type.HIVE, database, null, null);
        this.setQuery(query);
    }

    public Job(Database database, Type type, String query, String resultTable) {
        this(null, type, database, null, null);
        this.setQuery(query);
    }

    public Job(String jobID, Type type, Database database, String url, String resultTable) {
        super(jobID);
        this.setType(type);
        this.setDatabase(database);
        this.setURL(url);
        this.setResultTable(resultTable);
    }

    public void setJobID(String jobID) {
        super.setName(jobID);
    }

    public String getJobID() {
        return super.getName();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public void setResultTable(String resultTable) {
        this.resultTable = resultTable;
    }

    public String getResultTable() {
        return this.resultTable;
    }

    public static enum Priority {
        VERYLOW(-2),
        LOW(-1),
        NORMAL(0),
        HIGH(1),
        VERYHIGH(2);

        private int priority;

        private Priority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public static Priority fromInt(int p) {
            return IntToPriority.get(p);
        }

        private static class IntToPriority {
            private static final Map<Integer, Priority> REVERSE_DICTIONARY;

            private IntToPriority() {
            }

            static Priority get(int p) {
                return REVERSE_DICTIONARY.get(p);
            }

            static {
                HashMap<Integer, Priority> map = new HashMap<Integer, Priority>();
                for (Priority p : Priority.values()) {
                    map.put(p.getPriority(), p);
                }
                REVERSE_DICTIONARY = Collections.unmodifiableMap(map);
            }
        }
    }

    public static enum Type {
        HIVE("hive"),
        MAPRED("mapred"),
        IMPALA("impala"),
        UNKNOWN("none");

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public static class StringToType {
            private static final Map<String, Type> REVERSE_DICTIONARY;

            static Type get(String key) {
                return REVERSE_DICTIONARY.get(key);
            }

            static {
                HashMap<String, Type> map = new HashMap<String, Type>();
                for (Type elem : Type.values()) {
                    map.put(elem.type(), elem);
                }
                REVERSE_DICTIONARY = Collections.unmodifiableMap(map);
            }
        }
    }
}

