/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model;

import com.treasure_data.model.AbstractModel;
import com.treasure_data.model.Database;
import com.treasure_data.model.Table;
import java.util.ArrayList;
import java.util.List;

public class TableSchema
extends AbstractModel {
    protected Table table;
    protected List<Pair> pairs;

    public static List<Pair> parsePairs(List<String> pairList) {
        if (pairList == null || pairList.isEmpty()) {
            return new ArrayList<Pair>();
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (String pair : pairList) {
            pairs.add(TableSchema.parsePair(pair));
        }
        return pairs;
    }

    public static Pair parsePair(String pairString) {
        String[] pair = pairString.split(":");
        if (pair.length != 2) {
            throw new IllegalArgumentException("");
        }
        return new Pair(pair[0], TableSchema.parseType(pair[1]));
    }

    private static Type parseType(String typeString) {
        if (PrimitiveType.STRING.getType().equals(typeString)) {
            return PrimitiveType.STRING;
        }
        if (PrimitiveType.INT.getType().equals(typeString)) {
            return PrimitiveType.INT;
        }
        if (PrimitiveType.LONG.getType().equals(typeString)) {
            return PrimitiveType.LONG;
        }
        if (PrimitiveType.DOUBLE.getType().equals(typeString)) {
            return PrimitiveType.DOUBLE;
        }
        if (PrimitiveType.FLOAT.getType().equals(typeString)) {
            return PrimitiveType.FLOAT;
        }
        if (typeString.startsWith("array<")) {
            typeString = typeString.substring(0, "array<".length());
            typeString = typeString.substring(0, typeString.length() - 1);
            return new ArrayType(TableSchema.parseType(typeString));
        }
        throw new IllegalArgumentException("");
    }

    public TableSchema(Table table) {
        this(table, null);
    }

    public TableSchema(Table table, List<String> pairsOfColsAndTypes) {
        super(table.getName());
        this.table = table;
        this.setPairsOfColsAndTypes(pairsOfColsAndTypes);
    }

    public void setPairs(List<Pair> pairs) {
        this.pairs = pairs;
    }

    public void setPairsOfColsAndTypes(List<String> pairsOfColsAndTypes) {
        if (pairsOfColsAndTypes == null || pairsOfColsAndTypes.isEmpty()) {
            this.pairs = new ArrayList<Pair>();
        }
        this.pairs = TableSchema.parsePairs(pairsOfColsAndTypes);
    }

    public Database getDatabase() {
        return this.table.getDatabase();
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public String getName() {
        return this.table.getName();
    }

    public List<Pair> getPairsOfColsAndTypes() {
        return this.pairs;
    }

    public static class Pair {
        String col;
        Type type;

        Pair(String col, Type type) {
            this.col = col;
            this.type = type;
        }

        public String getColumnName() {
            return this.col;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.col + ":" + this.type;
        }
    }

    public static class PrimitiveType
    implements Type {
        private static final PrimitiveType STRING = new PrimitiveType("string");
        private static final PrimitiveType INT = new PrimitiveType("int");
        private static final PrimitiveType LONG = new PrimitiveType("long");
        private static final PrimitiveType DOUBLE = new PrimitiveType("double");
        private static final PrimitiveType FLOAT = new PrimitiveType("float");
        private String type;

        private PrimitiveType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return this.getType();
        }
    }

    public static class ArrayType
    implements ContainerType {
        private Type elementType;

        private ArrayType(Type elementType) {
            this.elementType = elementType;
        }

        @Override
        public String getContainerType() {
            return "array";
        }

        @Override
        public String toString() {
            return this.getContainerType() + "<" + this.elementType.toString() + ">";
        }
    }

    public static interface ContainerType
    extends Type {
        public String getContainerType();
    }

    public static interface Type {
        public String toString();
    }
}

