/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.treasuredata.client.model.TDColumn;
import com.treasuredata.client.model.TDTableType;
import java.util.List;

public class TDTable {
    private final String id;
    private final String name;
    private final TDTableType type;
    private final List<TDColumn> columns;
    private final long rowCount;
    private final long estimatedStorageSize;
    private final String lastLogTimeStamp;
    private final String expireDays;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public TDTable(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="type") TDTableType type, @JsonProperty(value="schema") String schema, @JsonProperty(value="count") long rowCount, @JsonProperty(value="estimated_storage_size") long estimatedStroageSize, @JsonProperty(value="last_log_timestamp") String lastLogTimeStamp, @JsonProperty(value="expire_days") String expireDays, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.columns = TDColumn.parseTuple(schema);
        this.rowCount = rowCount;
        this.estimatedStorageSize = estimatedStroageSize;
        this.lastLogTimeStamp = lastLogTimeStamp;
        this.expireDays = expireDays;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TDTableType getType() {
        return this.type;
    }

    @JsonProperty
    public List<TDColumn> getColumns() {
        return this.columns;
    }

    public List<TDColumn> getSchema() {
        return this.getColumns();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getEstimatedStorageSize() {
        return this.estimatedStorageSize;
    }

    public String getLastLogTimeStamp() {
        return this.lastLogTimeStamp;
    }

    public String getExpireDays() {
        return this.expireDays;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TDTable other = (TDTable)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.columns});
    }

    public String toString() {
        return String.format("%s(%s)", this.name, Joiner.on((String)", ").join(this.columns));
    }
}

