/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.auth;

import java.util.Properties;

public class TreasureDataCredentials {
    private String apiKey;
    private String internalKey;
    private String internalKeyId;

    private void setProps(Properties props) {
        this.apiKey = System.getenv("TREASURE_DATA_API_KEY");
        if (this.apiKey == null) {
            this.apiKey = props.getProperty("td.api.key");
        }
        this.internalKey = props.getProperty("td.api.internalkey");
        this.internalKeyId = props.getProperty("td.api.internalkeyid");
    }

    public TreasureDataCredentials() {
        this(System.getProperties());
    }

    public TreasureDataCredentials(Properties props) {
        this.setProps(props);
    }

    public TreasureDataCredentials(String apiKey) {
        this.apiKey = apiKey;
        this.internalKey = null;
        this.internalKeyId = null;
    }

    public void setAPIKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getAPIKey() {
        return this.apiKey;
    }

    public String getInternalKey() {
        return this.internalKey;
    }

    public String getInternalKeyId() {
        return this.internalKeyId;
    }

    public String toString() {
        return String.format("%s{apiKey=%s}", this.getClass().getName(), this.apiKey != null ? this.apiKey : "null");
    }
}

