/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client;

import com.treasure_data.auth.TreasureDataCredentials;
import com.treasure_data.client.AbstractClientAdaptor;
import com.treasure_data.client.ClientException;
import com.treasure_data.client.Config;
import com.treasure_data.client.DefaultClientAdaptor;
import com.treasure_data.client.HttpClientException;
import com.treasure_data.client.HttpConnectionImpl;
import com.treasure_data.client.Validator;
import com.treasure_data.model.AuthenticateRequest;
import com.treasure_data.model.AuthenticateResult;
import com.treasure_data.model.CreateDatabaseRequest;
import com.treasure_data.model.CreateDatabaseResult;
import com.treasure_data.model.CreateTableRequest;
import com.treasure_data.model.CreateTableResult;
import com.treasure_data.model.Database;
import com.treasure_data.model.DatabaseSummary;
import com.treasure_data.model.DeleteDatabaseRequest;
import com.treasure_data.model.DeleteDatabaseResult;
import com.treasure_data.model.DeletePartialTableRequest;
import com.treasure_data.model.DeletePartialTableResult;
import com.treasure_data.model.DeleteTableRequest;
import com.treasure_data.model.DeleteTableResult;
import com.treasure_data.model.ExportRequest;
import com.treasure_data.model.ExportResult;
import com.treasure_data.model.GetJobResultRequest;
import com.treasure_data.model.GetJobResultResult;
import com.treasure_data.model.GetServerStatusRequest;
import com.treasure_data.model.GetServerStatusResult;
import com.treasure_data.model.ImportRequest;
import com.treasure_data.model.ImportResult;
import com.treasure_data.model.Job;
import com.treasure_data.model.JobResult;
import com.treasure_data.model.JobResult2;
import com.treasure_data.model.JobSummary;
import com.treasure_data.model.KillJobRequest;
import com.treasure_data.model.KillJobResult;
import com.treasure_data.model.ListDatabases;
import com.treasure_data.model.ListDatabasesRequest;
import com.treasure_data.model.ListDatabasesResult;
import com.treasure_data.model.ListJobs;
import com.treasure_data.model.ListJobsRequest;
import com.treasure_data.model.ListJobsResult;
import com.treasure_data.model.ListTables;
import com.treasure_data.model.ListTablesRequest;
import com.treasure_data.model.ListTablesResult;
import com.treasure_data.model.RenameTableRequest;
import com.treasure_data.model.RenameTableResult;
import com.treasure_data.model.ServerStatus;
import com.treasure_data.model.SetTableSchemaRequest;
import com.treasure_data.model.SetTableSchemaResult;
import com.treasure_data.model.ShowJobRequest;
import com.treasure_data.model.ShowJobResult;
import com.treasure_data.model.ShowJobStatusRequest;
import com.treasure_data.model.ShowJobStatusResult;
import com.treasure_data.model.SubmitJobRequest;
import com.treasure_data.model.SubmitJobResult;
import com.treasure_data.model.SwapTableRequest;
import com.treasure_data.model.SwapTableResult;
import com.treasure_data.model.Table;
import com.treasure_data.model.TableSchema;
import com.treasure_data.model.TableSummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONValue;
import org.msgpack.unpacker.Unpacker;

public class DefaultClientAdaptorImpl
extends AbstractClientAdaptor
implements DefaultClientAdaptor {
    private static Logger LOG = Logger.getLogger(DefaultClientAdaptorImpl.class.getName());
    private Validator validator = new Validator();

    DefaultClientAdaptorImpl(Config conf) {
        super(conf);
    }

    @Override
    public AuthenticateResult authenticate(AuthenticateRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        String jsonData = null;
        String message = null;
        int code = 0;
        try {
            this.conn = this.createConnection();
            String path = "/v3/user/authenticate";
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("user", request.getEmail());
            params.put("password", request.getPassword());
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Authentication failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Authentication failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "authenticate", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Authentication failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        String apiKey = (String)map.get("apikey");
        TreasureDataCredentials credentails = new TreasureDataCredentials(apiKey);
        return new AuthenticateResult(credentails);
    }

    @Override
    public GetServerStatusResult getServerStatus(GetServerStatusRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = "/v3/system/server_status";
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Server is down", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Server is down", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "getServerStatus", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Server is down", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        String status = (String)map.get("status");
        return new GetServerStatusResult(new ServerStatus(status));
    }

    @Override
    public ListDatabasesResult listDatabases(ListDatabasesRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        String message = null;
        int code = 0;
        try {
            this.conn = this.createConnection();
            String path = "/v3/database/list";
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("List databases failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("List databases failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "listDatabases", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("List databases failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        Iterator dbMaps = ((List)map.get("databases")).iterator();
        ArrayList<DatabaseSummary> databases = new ArrayList<DatabaseSummary>();
        while (dbMaps.hasNext()) {
            Map dbMap = (Map)dbMaps.next();
            String name = (String)dbMap.get("name");
            long count = (Long)dbMap.get("count");
            String createdAt = (String)dbMap.get("created_at");
            String updatedAt = (String)dbMap.get("updated_at");
            databases.add(new DatabaseSummary(name, count, createdAt, updatedAt));
        }
        return new ListDatabasesResult(new ListDatabases<DatabaseSummary>(databases));
    }

    @Override
    public CreateDatabaseResult createDatabase(CreateDatabaseRequest request) throws ClientException {
        this.validator.validateDatabaseName(request.getDatabaseName());
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/database/create/%s", HttpConnectionImpl.e(request.getDatabaseName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Create database failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Create database failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "createDatabase", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Create database failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map dbMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, dbMap);
        String dbName = (String)dbMap.get("database");
        return new CreateDatabaseResult(new Database(dbName));
    }

    @Override
    public DeleteDatabaseResult deleteDatabase(DeleteDatabaseRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/database/delete/%s", HttpConnectionImpl.e(request.getDatabaseName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Delete database failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Delete database failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "deleteDatabase", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Delete database failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map dbMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, dbMap);
        return new DeleteDatabaseResult((Database)request.getDatabase());
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest request) throws ClientException {
        if (request.getDatabase() == null) {
            throw new ClientException("database is not specified");
        }
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/list/%s", HttpConnectionImpl.e(((Database)request.getDatabase()).getName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("List tables failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("List tables failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "listTables", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("List tables failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        Iterator tableMapIter = ((List)map.get("tables")).iterator();
        ArrayList<TableSummary> tableList = new ArrayList<TableSummary>();
        while (tableMapIter.hasNext()) {
            Map tableMap = (Map)tableMapIter.next();
            String name = (String)tableMap.get("name");
            String typeName = (String)tableMap.get("type");
            Long count = (Long)tableMap.get("count");
            String schema = (String)tableMap.get("schema");
            String createdAt = (String)tableMap.get("created_at");
            String updatedAt = (String)tableMap.get("updated_at");
            TableSummary tbl = new TableSummary((Database)request.getDatabase(), name, Table.toType(typeName), count, schema, createdAt, updatedAt);
            tableList.add(tbl);
        }
        ListTables<TableSummary> tables = new ListTables<TableSummary>(tableList);
        return new ListTablesResult((Database)request.getDatabase(), tables);
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest request) throws ClientException {
        this.validator.validateTableName(request.getTableName());
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/create/%s/%s/%s", HttpConnectionImpl.e(request.getDatabase().getName()), HttpConnectionImpl.e(request.getTableName()), HttpConnectionImpl.e(Table.toTypeName(((Table)request.getTable()).getType())));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                throw new HttpClientException("Create table failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            throw new HttpClientException("Create table failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map tableMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, tableMap);
        String tableName = (String)tableMap.get("table");
        Table.Type tableType = Table.toType((String)tableMap.get("type"));
        Table table = new Table(request.getDatabase(), tableName, tableType);
        return new CreateTableResult(table);
    }

    @Override
    public RenameTableResult renameTable(RenameTableRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/rename/%s/%s/%s", HttpConnectionImpl.e(request.getDatabaseName()), HttpConnectionImpl.e(request.getOrigTableName()), HttpConnectionImpl.e(request.getNewTableName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("overwrite", "" + request.getOverwrite());
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Rename table failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Rename table failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "renameTable", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Rename table failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new RenameTableResult(request.getDatabaseName(), request.getOrigTableName(), request.getNewTableName());
    }

    @Override
    public SwapTableResult swapTable(SwapTableRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/swap/%s/%s/%s", HttpConnectionImpl.e(request.getDatabaseName()), HttpConnectionImpl.e(request.getTableName1()), HttpConnectionImpl.e(request.getTableName2()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Swap table failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Swap table failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "swapTable", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Swap table failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        return new SwapTableResult(request.getDatabaseName(), request.getTableName1(), request.getTableName2());
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/delete/%s/%s", HttpConnectionImpl.e(request.getDatabase().getName()), HttpConnectionImpl.e(((Table)request.getTable()).getName()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Delete table failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Delete table failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "deleteTable", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Delete table failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map tableMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, tableMap);
        String tableName = (String)tableMap.get("table");
        return new DeleteTableResult(request.getDatabase(), tableName);
    }

    @Override
    public DeletePartialTableResult deletePartialTable(DeletePartialTableRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/partialdelete/%s/%s", HttpConnectionImpl.e(request.getDatabase().getName()), HttpConnectionImpl.e(((Table)request.getTable()).getName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("from", "" + request.getFrom());
            params.put("to", "" + request.getTo());
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Delete partial table failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Delete partial table failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "deletePartialTable", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Delete partial table failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map jobMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, jobMap);
        String jobID = DefaultClientAdaptorImpl.getJobID(jobMap);
        Job job = new Job(jobID, Job.Type.MAPRED, request.getDatabase(), null, null);
        return new DeletePartialTableResult(job);
    }

    @Override
    public TableSchema showTableSchema(String database, String table) throws ClientException {
        List<TableSummary> summaries = this.listTables(new ListTablesRequest(new Database(database))).getTables();
        TableSummary summary = null;
        for (TableSummary t : summaries) {
            if (!t.getName().equals(table)) continue;
            summary = t;
        }
        if (summary == null) {
            throw new ClientException("Not such table " + table);
        }
        String schemaString = summary.getSchema();
        List schema = (List)JSONValue.parse((String)schemaString);
        if (schema == null || schema.isEmpty()) {
            return new TableSchema(new Table(new Database(database), table), null);
        }
        ArrayList<String> pairs = new ArrayList<String>();
        for (int i = 0; i < schema.size(); ++i) {
            List pair = (List)schema.get(i);
            pairs.add((String)pair.get(0) + ":" + (String)pair.get(1));
        }
        return new TableSchema(new Table(new Database(database), table), pairs);
    }

    @Override
    public SetTableSchemaResult setTableSchema(SetTableSchemaRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/update-schema/%s/%s", HttpConnectionImpl.e(request.getDatabaseName()), HttpConnectionImpl.e(request.getTableName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("schema", HttpConnectionImpl.e(request.getJSONString()));
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Set table schema failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Set table schema failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "setTableSchema", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Set table schema failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map tblMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, tblMap);
        String dbName = (String)tblMap.get("database");
        String tblName = (String)tblMap.get("table");
        return new SetTableSchemaResult(request.getTableSchema());
    }

    @Override
    public TableSchema addTableSchema(String database, String table, List<String> addedPairList) throws ClientException {
        TableSchema current = this.showTableSchema(database, table);
        List<TableSchema.Pair> currentPairs = current.getPairsOfColsAndTypes();
        if (addedPairList == null || addedPairList.isEmpty()) {
            return current;
        }
        List<TableSchema.Pair> addedPairs = TableSchema.parsePairs(addedPairList);
        if (currentPairs == null || currentPairs.isEmpty()) {
            current.setPairs(addedPairs);
        } else {
            block0: for (TableSchema.Pair addedPair : addedPairs) {
                String addedCol = addedPair.getColumnName();
                for (int i = 0; i < currentPairs.size(); ++i) {
                    if (!currentPairs.get(i).getColumnName().equals(addedCol)) continue;
                    currentPairs.remove(i);
                    continue block0;
                }
            }
            currentPairs.addAll(addedPairs);
        }
        SetTableSchemaResult result = this.setTableSchema(new SetTableSchemaRequest(current));
        return result.getTableSchema();
    }

    @Override
    public TableSchema removeTableSchema(String database, String table, List<String> removedColList) throws ClientException {
        TableSchema current = this.showTableSchema(database, table);
        List<TableSchema.Pair> currentPairs = current.getPairsOfColsAndTypes();
        if (removedColList == null || removedColList.isEmpty() || currentPairs == null || currentPairs.isEmpty()) {
            return current;
        }
        block0: for (String removedCol : removedColList) {
            for (int i = 0; i < currentPairs.size(); ++i) {
                if (!currentPairs.get(i).getColumnName().equals(removedCol)) continue;
                currentPairs.remove(i);
                continue block0;
            }
        }
        SetTableSchemaResult result = this.setTableSchema(new SetTableSchemaRequest(current));
        return result.getTableSchema();
    }

    @Override
    public ImportResult importData(ImportRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/table/import/%s/%s/msgpack.gz", HttpConnectionImpl.e(request.getTable().getDatabase().getName()), HttpConnectionImpl.e(request.getTable().getName()));
            this.conn.doPutRequest(request, path, request.getBytes());
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Import data failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Import data failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "importData", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Import data failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        double elapsedTime = (Double)map.get("elapsed_time");
        return new ImportResult(request.getTable(), elapsedTime);
    }

    @Override
    public ExportResult exportData(ExportRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/export/run/%s/%s", HttpConnectionImpl.e(request.getDatabase().getName()), HttpConnectionImpl.e(((Table)request.getTable()).getName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getAccessKeyID() == null) {
                throw new IllegalArgumentException("access_key_id is null");
            }
            params.put("access_key_id", HttpConnectionImpl.e(request.getAccessKeyID()));
            if (request.getSecretAccessKey() == null) {
                throw new IllegalArgumentException("secret_access_key is null");
            }
            params.put("secret_access_key", HttpConnectionImpl.e(request.getSecretAccessKey()));
            if (request.getStorageType() == null) {
                throw new IllegalArgumentException("storage_type is null");
            }
            params.put("storage_type", request.getStorageType());
            if (request.getBucketName() == null) {
                throw new IllegalArgumentException("bucket is null");
            }
            params.put("bucket", request.getBucketName());
            if (request.getFileFormat() == null) {
                throw new IllegalArgumentException("file_format is null");
            }
            params.put("file_format", request.getFileFormat());
            if (request.getFrom() != null) {
                params.put("from", request.getFrom());
            }
            if (request.getTo() != null) {
                params.put("to", request.getTo());
            }
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Export failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Export failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "exportData", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Export failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map jobMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, jobMap);
        String jobID = DefaultClientAdaptorImpl.getJobID(jobMap);
        Job job = new Job(jobID, Job.Type.MAPRED, request.getDatabase(), null, null);
        return new ExportResult(job);
    }

    @Override
    public SubmitJobResult submitJob(SubmitJobRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/issue/%s/%s", HttpConnectionImpl.e(request.getJob().getType().type()), HttpConnectionImpl.e(request.getDatabase().getName()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getJob().getQuery() == null) {
                throw new IllegalArgumentException("query is null");
            }
            params.put("query", HttpConnectionImpl.e(request.getJob().getQuery()));
            params.put("version", "0.7");
            if (request.getJob().getResultTable() != null) {
                params.put("result", HttpConnectionImpl.e(request.getJob().getResultTable()));
            }
            params.put("priority", "" + request.getJob().getPriority().getPriority());
            params.put("retry_limit", "" + request.getJob().getRetryLimit());
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Submit job failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Submit job failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "submitJob", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Submit job failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map jobMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, jobMap);
        String jobID = DefaultClientAdaptorImpl.getJobID(jobMap);
        Job job = request.getJob();
        job.setJobID(jobID);
        return new SubmitJobResult(job);
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) throws ClientException {
        long to;
        long from;
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/list", new Object[0]);
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            from = request.getFrom();
            if (from < 0L) {
                throw new IllegalArgumentException();
            }
            params.put("from", "" + from);
            to = request.getTo();
            if (to < 0L) {
                throw new IllegalArgumentException();
            }
            if (to > 0L) {
                params.put("to", "" + to);
            }
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("List jobs failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("List jobs failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "listJobs", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("List jobs failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        long count = (Long)map.get("count");
        from = (Long)map.get("from");
        to = (Long)map.get("to");
        Iterator jobMapIter = ((List)map.get("jobs")).iterator();
        ArrayList<JobSummary> jobs = new ArrayList<JobSummary>();
        while (jobMapIter.hasNext()) {
            Map jobMap = (Map)jobMapIter.next();
            Job.Type type = Job.toType((String)jobMap.get("type"));
            String jobID = DefaultClientAdaptorImpl.getJobID(jobMap);
            JobSummary.Status status = JobSummary.toStatus((String)jobMap.get("status"));
            String startAt = (String)jobMap.get("start_at");
            String endAt = (String)jobMap.get("end_at");
            String query = (String)jobMap.get("query");
            String result = (String)jobMap.get("result");
            JobSummary job = new JobSummary(jobID, type, null, null, result, status, startAt, endAt, query, null);
            jobs.add(job);
        }
        return new ListJobsResult(new ListJobs<JobSummary>(count, from, to, jobs));
    }

    @Override
    public KillJobResult killJob(KillJobRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/kill/%s", HttpConnectionImpl.e(request.getJob().getJobID()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doPostRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Kill job failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Kill job failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "killJob", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Kill job failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map map = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, map);
        JobSummary.Status status = JobSummary.toStatus((String)map.get("former_status"));
        String jobID = DefaultClientAdaptorImpl.getJobID(map);
        return new KillJobResult(jobID, status);
    }

    @Override
    public ShowJobResult showJob(ShowJobRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/show/%s", HttpConnectionImpl.e(request.getJob().getJobID()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Show jobs failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Show jobs failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "showJob", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Show jobs failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map jobMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, jobMap);
        String jobID = DefaultClientAdaptorImpl.getJobID(jobMap);
        Job.Type type = Job.toType((String)jobMap.get("type"));
        Database database = new Database((String)jobMap.get("database"));
        String url = (String)jobMap.get("url");
        JobSummary.Status status = JobSummary.toStatus((String)jobMap.get("status"));
        String start_at = (String)jobMap.get("start_at");
        String end_at = (String)jobMap.get("end_at");
        String query = (String)jobMap.get("query");
        String result = (String)jobMap.get("result");
        String resultSchema = (String)jobMap.get("hive_result_schema");
        Map debugMap = (Map)jobMap.get("debug");
        JobSummary.Debug debug = new JobSummary.Debug((String)debugMap.get("cmdout"), (String)debugMap.get("stderr"));
        JobSummary job = new JobSummary(jobID, type, database, url, result, status, start_at, end_at, query, resultSchema, debug);
        return new ShowJobResult(job);
    }

    @Override
    public ShowJobStatusResult showJobStatus(ShowJobStatusRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        String jsonData = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/status/%s", HttpConnectionImpl.e(request.getJob().getJobID()));
            Map<String, String> header = null;
            Map<String, String> params = null;
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Show job status failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Show job status failed", message + ", detail = " + errMessage, code);
            }
            jsonData = this.conn.getResponseBody();
            this.validator.validateJSONData(jsonData);
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "showJobStatus", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Show job status failed", message, code, e);
        }
        finally {
            if (this.conn != null) {
                this.conn.disconnect();
            }
        }
        Map jobMap = (Map)JSONValue.parse((String)jsonData);
        this.validator.validateJavaObject(jsonData, jobMap);
        JobSummary.Status status = JobSummary.toStatus((String)jobMap.get("status"));
        return new ShowJobStatusResult(status);
    }

    @Override
    public GetJobResultResult getJobResult(GetJobResultRequest request) throws ClientException {
        request.setCredentials(this.getConfig().getCredentials());
        this.validator.validateCredentials(this, request);
        Unpacker unpacker = null;
        int code = 0;
        String message = null;
        try {
            this.conn = this.createConnection();
            String path = String.format("/v3/job/result/%s", HttpConnectionImpl.e(request.getJobResult().getJob().getJobID()));
            Map<String, String> header = null;
            HashMap<String, String> params = new HashMap<String, String>();
            if (request.getJobResult().getFormat() != JobResult.Format.MSGPACKGZ) {
                String msg = String.format("Doesn't support format", new Object[]{request.getJobResult().getFormat()});
                throw new UnsupportedOperationException(msg);
            }
            params.put("format", JobResult.toFormatName(JobResult.Format.MSGPACKGZ));
            this.conn.doGetRequest(request, path, header, params);
            code = this.conn.getResponseCode();
            message = this.conn.getResponseMessage();
            if (code != 200) {
                String errMessage = this.conn.getErrorMessage();
                LOG.severe(HttpClientException.toMessage("Get job result failed", message, code));
                LOG.severe(errMessage);
                throw new HttpClientException("Get job result failed", message + ", detail = " + errMessage, code);
            }
            request.getJobResult().setResultSize(this.conn.getContentLength());
            if (!(request.getJobResult() instanceof JobResult2)) {
                unpacker = this.conn.getResponseBodyBinaryWithGZip();
                request.getJobResult().setResult(unpacker);
            } else {
                ((JobResult2)request.getJobResult()).setResultInputStream(this.conn.getInputStream());
            }
        }
        catch (IOException e) {
            LOG.throwing(this.getClass().getName(), "getJobResult", e);
            LOG.severe(HttpClientException.toMessage(e.getMessage(), message, code));
            throw new HttpClientException("Get job result failed", message, code, e);
        }
        finally {
            if (this.conn != null && !(request.getJobResult() instanceof JobResult2)) {
                this.conn.disconnect();
            }
        }
        return new GetJobResultResult(request.getJobResult());
    }

    public static String getJobID(Map<String, Object> map) {
        Object job_id = map.get("job_id");
        if (job_id instanceof Number) {
            return ((Number)job_id).toString();
        }
        return (String)job_id;
    }

    static interface HttpURL {
        public static final String V3_USER_AUTHENTICATE = "/v3/user/authenticate";
        public static final String V3_SYSTEM_SERVER_STATUS = "/v3/system/server_status";
        public static final String V3_DATABASE_LIST = "/v3/database/list";
        public static final String V3_DATABASE_CREATE = "/v3/database/create/%s";
        public static final String V3_DATABASE_DELETE = "/v3/database/delete/%s";
        public static final String V3_TABLE_LIST = "/v3/table/list/%s";
        public static final String V3_TABLE_CREATE = "/v3/table/create/%s/%s/%s";
        public static final String V3_TABLE_RENAME = "/v3/table/rename/%s/%s/%s";
        public static final String V3_TABLE_SWAP = "/v3/table/swap/%s/%s/%s";
        public static final String V3_TABLE_DELETE = "/v3/table/delete/%s/%s";
        public static final String V3_TABLE_DELETE_PARTIAL = "/v3/table/partialdelete/%s/%s";
        public static final String V3_SCHEMA_UPDATE = "/v3/table/update-schema/%s/%s";
        public static final String V3_TABLE_IMPORT = "/v3/table/import/%s/%s/msgpack.gz";
        public static final String V3_EXPORTJOB_SUBMIT = "/v3/export/run/%s/%s";
        public static final String V3_JOB_SUBMIT = "/v3/job/issue/%s/%s";
        public static final String V3_JOB_LIST = "/v3/job/list";
        public static final String V3_JOB_KILL = "/v3/job/kill/%s";
        public static final String V3_JOB_SHOW = "/v3/job/show/%s";
        public static final String V3_JOBSTATUS_SHOW = "/v3/job/status/%s";
        public static final String V3_JOB_RESULT = "/v3/job/result/%s";
    }
}

