/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client;

import com.treasure_data.client.ClientException;
import com.treasure_data.model.Request;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.msgpack.MessagePack;
import org.msgpack.unpacker.BufferUnpacker;
import org.msgpack.unpacker.Unpacker;

public class HttpConnectionImpl {
    private static Logger LOG = Logger.getLogger(HttpConnectionImpl.class.getName());
    private static final SimpleDateFormat RFC2822FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private HttpURLConnection conn = null;
    private Properties props;
    private MessageDigest md = null;
    private int getReadTimeout;
    private int putReadTimeout;
    private int postReadTimeout;

    public HttpConnectionImpl() {
        this(System.getProperties());
    }

    public HttpConnectionImpl(Properties props) {
        this.getReadTimeout = Integer.parseInt(props.getProperty("td.client.getmethod.read.timeout", "600000"));
        this.putReadTimeout = Integer.parseInt(props.getProperty("td.client.putmethod.read.timeout", "600000"));
        this.postReadTimeout = Integer.parseInt(props.getProperty("td.client.postmethod.read.timeout", "600000"));
        try {
            this.md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private void setRequestAuthHeader(Request<?> request, HttpURLConnection conn) throws IOException {
        String apiKey = request.getCredentials().getAPIKey();
        if (apiKey != null) {
            conn.setRequestProperty("Authorization", "TD1 " + apiKey);
        }
        String internalKey = request.getCredentials().getInternalKey();
        String internalKeyId = request.getCredentials().getInternalKeyId();
        String dateStr = HttpConnectionImpl.toRFC2822Format(new Date());
        conn.setRequestProperty("Date", dateStr);
        if (this.md != null && internalKey != null && internalKeyId != null) {
            this.md.reset();
            this.md.update(String.format("%s\n%s\n", dateStr, internalKey).getBytes());
            String hashedKey = HttpConnectionImpl.byteArrayToHexString(this.md.digest());
            conn.setRequestProperty("Internal-Authorization", String.format("TD2 %s:%s", internalKeyId, hashedKey));
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public void doGetRequest(Request<?> request, String path, Map<String, String> header, Map<String, String> params) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("https://").append(this.getApiServerPath()).append(path);
        if (params != null && !params.isEmpty()) {
            sbuf.append("?");
            int paramSize = params.size();
            Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();
            for (int i = 0; i < paramSize; ++i) {
                Map.Entry<String, String> e = iter.next();
                sbuf.append(e.getKey()).append("=").append(e.getValue());
                if (i + 1 == paramSize) continue;
                sbuf.append("&");
            }
        }
        URL url = new URL(sbuf.toString());
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setReadTimeout(this.getReadTimeout);
        this.conn.setRequestMethod("GET");
        this.setRequestAuthHeader(request, this.conn);
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> e : header.entrySet()) {
                this.conn.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        this.conn.connect();
    }

    public void doPostRequest(Request<?> request, String path, Map<String, String> header, Map<String, String> params) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("https://").append(this.getApiServerPath()).append(path);
        if (params != null && !params.isEmpty()) {
            sbuf.append("?");
            int paramSize = params.size();
            Iterator<Map.Entry<String, String>> iter = params.entrySet().iterator();
            for (int i = 0; i < paramSize; ++i) {
                Map.Entry<String, String> e = iter.next();
                sbuf.append(e.getKey()).append("=").append(e.getValue());
                if (i + 1 == paramSize) continue;
                sbuf.append("&");
            }
            URL url = new URL(sbuf.toString());
            this.conn = (HttpURLConnection)url.openConnection();
        } else {
            URL url = new URL(sbuf.toString());
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setRequestProperty("Content-Length", "0");
        }
        this.conn.setReadTimeout(this.postReadTimeout);
        this.conn.setRequestMethod("POST");
        this.setRequestAuthHeader(request, this.conn);
        if (header != null && !header.isEmpty()) {
            for (Map.Entry<String, String> e : header.entrySet()) {
                this.conn.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(sbuf.toString());
        }
        this.conn.connect();
    }

    public void doPutRequest(Request<?> request, String path, byte[] bytes) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("https://").append(this.getApiServerPath()).append(path);
        URL url = new URL(sbuf.toString());
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setReadTimeout(this.putReadTimeout);
        this.conn.setRequestMethod("PUT");
        this.conn.setRequestProperty("Content-Length", "" + bytes.length);
        this.setRequestAuthHeader(request, this.conn);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        BufferedOutputStream out = new BufferedOutputStream(this.conn.getOutputStream());
        out.write(bytes);
        out.flush();
    }

    public void doPutRequest(Request<?> request, String path, InputStream in, int size) throws IOException {
        int len;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("https://").append(this.getApiServerPath()).append(path);
        URL url = new URL(sbuf.toString());
        this.conn = (HttpURLConnection)url.openConnection();
        this.conn.setReadTimeout(this.putReadTimeout);
        this.conn.setRequestMethod("PUT");
        this.conn.setRequestProperty("Content-Length", "" + size);
        this.setRequestAuthHeader(request, this.conn);
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream out = new BufferedOutputStream(this.conn.getOutputStream());
        byte[] buf = new byte[1024];
        while ((len = bin.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    public int getResponseCode() throws IOException {
        return this.conn.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.conn.getResponseMessage();
    }

    public String getResponseBody() throws IOException {
        String line;
        StringBuilder sbuf = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        while ((line = reader.readLine()) != null) {
            sbuf.append(line);
        }
        reader.close();
        return sbuf.toString();
    }

    public String getErrorMessage() throws IOException {
        String line;
        StringBuilder sbuf = new StringBuilder();
        InputStream orig = this.conn.getErrorStream();
        if (orig == null) {
            return "No error message";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(orig));
        while ((line = reader.readLine()) != null) {
            sbuf.append(line);
        }
        reader.close();
        return sbuf.toString();
    }

    public void disconnect() {
        this.conn.disconnect();
    }

    public int getContentLength() throws IOException {
        return this.conn.getContentLength();
    }

    public Unpacker getResponseBodyBinary() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.getInputStream());
        MessagePack msgpack = new MessagePack();
        BufferUnpacker unpacker = msgpack.createBufferUnpacker();
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = in.read(buf)) != -1) {
            unpacker.feed(buf, 0, len);
        }
        return unpacker;
    }

    public Unpacker getResponseBodyBinaryWithGZip() throws IOException {
        GZIPInputStream in = new GZIPInputStream(this.getInputStream());
        MessagePack msgpack = new MessagePack();
        BufferUnpacker unpacker = msgpack.createBufferUnpacker();
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = ((InputStream)in).read(buf)) != -1) {
            unpacker.feed(buf, 0, len);
        }
        return unpacker;
    }

    public Unpacker getResponseBodyBinaryWithGZip2() throws IOException {
        MessagePack msgpack = new MessagePack();
        BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(this.getInputStream()));
        return msgpack.createUnpacker((InputStream)in);
    }

    public InputStream getInputStream() throws IOException {
        return this.conn.getInputStream();
    }

    private String getApiServerPath() {
        String hostAndPort = "";
        hostAndPort = System.getenv("TD_API_SERVER");
        if (hostAndPort != null && !hostAndPort.isEmpty()) {
            int port;
            String host;
            try {
                URL url = new URL(hostAndPort);
                host = url.getHost();
                port = url.getPort() == -1 ? Integer.parseInt("80") : url.getPort();
            }
            catch (MalformedURLException e) {
                String[] splited = hostAndPort.split(":");
                if (splited.length == 2) {
                    host = splited[0];
                    port = Integer.parseInt(splited[1]);
                }
                host = hostAndPort;
                port = Integer.parseInt("80");
            }
            return host + ":" + port;
        }
        Properties props = System.getProperties();
        String host = props.getProperty("td.api.server.host", "api.treasure-data.com");
        int port = Integer.parseInt(props.getProperty("td.api.server.port", "80"));
        hostAndPort = host + ":" + port;
        return hostAndPort;
    }

    public static String e(String s) throws ClientException {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(e);
        }
    }

    private static String toRFC2822Format(Date from) {
        return RFC2822FORMAT.format(from);
    }
}

