/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client;

import com.treasure_data.client.ClientException;
import com.treasure_data.client.HttpClientException;
import java.io.IOException;
import java.util.logging.Logger;

public class RetryClient {
    private static Logger LOG = Logger.getLogger(RetryClient.class.getName());

    public void retry(Retryable r, int retryCount) throws IOException {
        int count = 0;
        while (true) {
            try {
                r.doTry();
                if (count <= 0) break;
                LOG.warning("Retry succeeded.");
            }
            catch (ClientException e) {
                LOG.warning(e.getMessage());
                if (count >= retryCount) {
                    LOG.warning("Retry count exceeded limit.");
                    throw new IOException("Retry error");
                }
                ++count;
                LOG.warning("It failed. but will be retried.");
                this.waitRetry(1L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry(Retryable r, int retryCount, long waitSec) throws IOException {
        int count = 0;
        boolean notRetry = false;
        while (true) {
            try {
                r.doTry();
            }
            catch (ClientException e) {
                LOG.warning(e.getMessage());
                if (e instanceof HttpClientException && ((HttpClientException)e).getResponseCode() < 400) {
                    ++count;
                    this.waitRetry(waitSec);
                }
                LOG.info("turned notRetry flag: " + notRetry);
                notRetry = true;
            }
            finally {
                if (count < retryCount && !notRetry) continue;
                throw new IOException("Retry out error");
            }
            break;
        }
    }

    protected void waitRetry(long sec) {
        try {
            Thread.sleep(sec * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static interface Retryable {
        public void doTry() throws ClientException;
    }
}

