/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client;

import com.treasure_data.auth.TreasureDataCredentials;
import com.treasure_data.client.ClientException;
import com.treasure_data.client.Config;
import com.treasure_data.client.DefaultClientAdaptor;
import com.treasure_data.client.DefaultClientAdaptorImpl;
import com.treasure_data.model.AuthenticateRequest;
import com.treasure_data.model.AuthenticateResult;
import com.treasure_data.model.CreateDatabaseRequest;
import com.treasure_data.model.CreateDatabaseResult;
import com.treasure_data.model.CreateTableRequest;
import com.treasure_data.model.CreateTableResult;
import com.treasure_data.model.Database;
import com.treasure_data.model.DatabaseSummary;
import com.treasure_data.model.DeleteDatabaseRequest;
import com.treasure_data.model.DeleteDatabaseResult;
import com.treasure_data.model.DeletePartialTableRequest;
import com.treasure_data.model.DeletePartialTableResult;
import com.treasure_data.model.DeleteTableRequest;
import com.treasure_data.model.DeleteTableResult;
import com.treasure_data.model.ExportRequest;
import com.treasure_data.model.ExportResult;
import com.treasure_data.model.GetJobResultRequest;
import com.treasure_data.model.GetJobResultResult;
import com.treasure_data.model.GetServerStatusRequest;
import com.treasure_data.model.GetServerStatusResult;
import com.treasure_data.model.ImportRequest;
import com.treasure_data.model.ImportResult;
import com.treasure_data.model.Job;
import com.treasure_data.model.JobResult;
import com.treasure_data.model.JobSummary;
import com.treasure_data.model.KillJobRequest;
import com.treasure_data.model.KillJobResult;
import com.treasure_data.model.ListDatabasesRequest;
import com.treasure_data.model.ListDatabasesResult;
import com.treasure_data.model.ListJobsRequest;
import com.treasure_data.model.ListJobsResult;
import com.treasure_data.model.ListTablesRequest;
import com.treasure_data.model.ListTablesResult;
import com.treasure_data.model.RenameTableRequest;
import com.treasure_data.model.RenameTableResult;
import com.treasure_data.model.ServerStatus;
import com.treasure_data.model.SetTableSchemaRequest;
import com.treasure_data.model.SetTableSchemaResult;
import com.treasure_data.model.ShowJobRequest;
import com.treasure_data.model.ShowJobResult;
import com.treasure_data.model.ShowJobStatusRequest;
import com.treasure_data.model.ShowJobStatusResult;
import com.treasure_data.model.SubmitJobRequest;
import com.treasure_data.model.SubmitJobResult;
import com.treasure_data.model.SwapTableRequest;
import com.treasure_data.model.SwapTableResult;
import com.treasure_data.model.Table;
import com.treasure_data.model.TableSchema;
import com.treasure_data.model.TableSummary;
import java.util.List;
import java.util.Properties;

public class TreasureDataClient {
    private DefaultClientAdaptor clientAdaptor;

    static DefaultClientAdaptor createClientAdaptor(TreasureDataCredentials credentials, Properties props) {
        Config conf = new Config(props);
        conf.setCredentials(credentials);
        DefaultClientAdaptorImpl clientAdaptor = new DefaultClientAdaptorImpl(conf);
        return clientAdaptor;
    }

    public TreasureDataClient() {
        this(System.getProperties());
    }

    public TreasureDataClient(Properties props) {
        this(new TreasureDataCredentials(props), props);
    }

    public TreasureDataClient(TreasureDataCredentials credentials, Properties props) {
        this.clientAdaptor = TreasureDataClient.createClientAdaptor(credentials, props);
    }

    public Config getConfig() {
        return this.clientAdaptor.getConfig();
    }

    public DefaultClientAdaptor getClientAdaptor() {
        return this.clientAdaptor;
    }

    public TreasureDataCredentials getTreasureDataCredentials() {
        return this.clientAdaptor.getTreasureDataCredentials();
    }

    public void setTreasureDataCredentials(TreasureDataCredentials credentials) {
        this.clientAdaptor.setTreasureDataCredentials(credentials);
    }

    public void authenticate(String email, String password) throws ClientException {
        this.authenticate(new AuthenticateRequest(email, password));
    }

    public AuthenticateResult authenticate(AuthenticateRequest request) throws ClientException {
        AuthenticateResult result = this.clientAdaptor.authenticate(request);
        TreasureDataCredentials credentials = result.getTreasureDataCredentials();
        this.setTreasureDataCredentials(credentials);
        return result;
    }

    public ServerStatus getServerStatus() throws ClientException {
        return this.clientAdaptor.getServerStatus(new GetServerStatusRequest()).getServerStatus();
    }

    public GetServerStatusResult getServerStatus(GetServerStatusRequest request) throws ClientException {
        return this.clientAdaptor.getServerStatus(new GetServerStatusRequest());
    }

    public List<DatabaseSummary> listDatabases() throws ClientException {
        return this.listDatabases(new ListDatabasesRequest()).getDatabases();
    }

    public ListDatabasesResult listDatabases(ListDatabasesRequest request) throws ClientException {
        return this.clientAdaptor.listDatabases(request);
    }

    public Database createDatabase(String databaseName) throws ClientException {
        return this.createDatabase(new CreateDatabaseRequest(databaseName)).getDatabase();
    }

    public CreateDatabaseResult createDatabase(CreateDatabaseRequest request) throws ClientException {
        return this.clientAdaptor.createDatabase(request);
    }

    public void deleteDatabase(String databaseName) throws ClientException {
        this.deleteDatabase(new DeleteDatabaseRequest(new Database(databaseName)));
    }

    public DeleteDatabaseResult deleteDatabase(DeleteDatabaseRequest request) throws ClientException {
        return this.clientAdaptor.deleteDatabase(request);
    }

    public List<TableSummary> listTables(String databaseName) throws ClientException {
        return this.listTables(new Database(databaseName));
    }

    public List<TableSummary> listTables(Database database) throws ClientException {
        return this.listTables(new ListTablesRequest(database)).getTables();
    }

    public ListTablesResult listTables(ListTablesRequest request) throws ClientException {
        return this.clientAdaptor.listTables(request);
    }

    public Table createTable(String databaseName, String tableName) throws ClientException {
        return this.createTable(new Database(databaseName), tableName);
    }

    public Table createTable(Database database, String tableName) throws ClientException {
        CreateTableResult result = this.createTable(new CreateTableRequest(database, tableName));
        return result.getTable();
    }

    public void renameTable(String databaseName, String origTableName, String newTableName) throws ClientException {
        this.renameTable(new RenameTableRequest(databaseName, origTableName, newTableName));
    }

    public void renameTable(String databaseName, String origTableName, String newTableName, boolean overwrite) throws ClientException {
        this.renameTable(new RenameTableRequest(databaseName, origTableName, newTableName, overwrite));
    }

    public RenameTableResult renameTable(RenameTableRequest request) throws ClientException {
        return this.clientAdaptor.renameTable(request);
    }

    public void swapTable(String databaseName, String tableName1, String tableName2) throws ClientException {
        this.swapTable(new SwapTableRequest(databaseName, tableName1, tableName2));
    }

    public SwapTableResult swapTable(SwapTableRequest request) throws ClientException {
        return this.clientAdaptor.swapTable(request);
    }

    public CreateTableResult createTable(CreateTableRequest request) throws ClientException {
        return this.clientAdaptor.createTable(request);
    }

    public void deleteTable(String databaseName, String tableName) throws ClientException {
        this.deleteTable(new DeleteTableRequest(new Table(new Database(databaseName), tableName, Table.Type.LOG)));
    }

    public DeleteTableResult deleteTable(DeleteTableRequest request) throws ClientException {
        return this.clientAdaptor.deleteTable(request);
    }

    public void deletePartiallTable(String databaseName, String tableName, long from, long to) throws ClientException {
        this.clientAdaptor.deletePartialTable(new DeletePartialTableRequest(new Table(new Database(databaseName), tableName), from, to));
    }

    public DeletePartialTableResult deletePartiallTable(DeletePartialTableRequest request) throws ClientException {
        return this.clientAdaptor.deletePartialTable(request);
    }

    public TableSchema showTableSchema(String database, String table) throws ClientException {
        return this.clientAdaptor.showTableSchema(database, table);
    }

    public TableSchema setTableSchema(String database, String table, List<String> pairsOfColsAndTypes) throws ClientException {
        return this.setTableSchema(new SetTableSchemaRequest(new TableSchema(new Table(new Database(database), table), pairsOfColsAndTypes))).getTableSchema();
    }

    public SetTableSchemaResult setTableSchema(SetTableSchemaRequest request) throws ClientException {
        return this.clientAdaptor.setTableSchema(request);
    }

    public TableSchema addTableSchema(String database, String table, List<String> addedPairsOfColsAndTypes) throws ClientException {
        return this.clientAdaptor.addTableSchema(database, table, addedPairsOfColsAndTypes);
    }

    public TableSchema removeTableSchema(String database, String table, List<String> removedCols) throws ClientException {
        return this.clientAdaptor.removeTableSchema(database, table, removedCols);
    }

    public ImportResult importData(String databaseName, String tableName, byte[] data) throws ClientException {
        return this.importData(new Table(new Database(databaseName), tableName), data);
    }

    public ImportResult importData(Table table, byte[] data) throws ClientException {
        return this.importData(new ImportRequest(table, data));
    }

    public ImportResult importData(ImportRequest request) throws ClientException {
        return this.clientAdaptor.importData(request);
    }

    public ExportResult exportData(ExportRequest request) throws ClientException {
        return this.clientAdaptor.exportData(request);
    }

    public void submitJob(Job job) throws ClientException {
        this.submitJob(new SubmitJobRequest(job));
    }

    public SubmitJobResult submitJob(SubmitJobRequest request) throws ClientException {
        return this.clientAdaptor.submitJob(request);
    }

    public List<JobSummary> listJobs(long from, long to) throws ClientException {
        return this.listJobs(new ListJobsRequest(from, to)).getJobs();
    }

    public ListJobsResult listJobs(ListJobsRequest request) throws ClientException {
        return this.clientAdaptor.listJobs(request);
    }

    public void killJob(String jobID) throws ClientException {
        this.killJob(new Job(jobID));
    }

    public void killJob(Job job) throws ClientException {
        this.killJob(new KillJobRequest(job));
    }

    public KillJobResult killJob(KillJobRequest request) throws ClientException {
        return this.clientAdaptor.killJob(request);
    }

    public JobSummary showJob(String jobID) throws ClientException {
        return this.showJob(new Job(jobID));
    }

    public JobSummary showJob(Job job) throws ClientException {
        return (JobSummary)this.showJob(new ShowJobRequest(job)).getJob();
    }

    public ShowJobResult showJob(ShowJobRequest request) throws ClientException {
        return this.clientAdaptor.showJob(request);
    }

    public JobSummary.Status showJobStatus(Job job) throws ClientException {
        return this.showJobStatus(new ShowJobStatusRequest(job)).getJobStatus();
    }

    public ShowJobStatusResult showJobStatus(ShowJobStatusRequest request) throws ClientException {
        return this.clientAdaptor.showJobStatus(request);
    }

    public JobResult getJobResult(Job job) throws ClientException {
        return this.getJobResult(new GetJobResultRequest(new JobResult(job))).getJobResult();
    }

    public GetJobResultResult getJobResult(GetJobResultRequest request) throws ClientException {
        return this.clientAdaptor.getJobResult(request);
    }
}

