/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.client;

import com.treasure_data.client.ClientException;
import com.treasure_data.client.DefaultClientAdaptor;
import com.treasure_data.client.TreasureDataClient;
import com.treasure_data.model.Request;
import java.util.regex.Pattern;

public class Validator {
    private static Pattern databaseNamePat = Pattern.compile("^([a-z0-9_]+)$");

    public void validateCredentials(TreasureDataClient client, Request<?> request) throws ClientException {
        String apiKey = request.getCredentials().getAPIKey();
        if (apiKey != null) {
            return;
        }
        apiKey = client.getTreasureDataCredentials().getAPIKey();
        if (apiKey != null) {
            request.setCredentials(client.getTreasureDataCredentials());
        }
        throw new ClientException("api key is not set.");
    }

    public void validateCredentials(DefaultClientAdaptor clientAdaptor, Request<?> request) throws ClientException {
        String apiKey = request.getCredentials().getAPIKey();
        if (apiKey != null) {
            return;
        }
        apiKey = clientAdaptor.getTreasureDataCredentials().getAPIKey();
        if (apiKey != null) {
            request.setCredentials(clientAdaptor.getTreasureDataCredentials());
        }
        throw new ClientException("api key is not set.");
    }

    public void validateJSONData(String jsonData) throws ClientException {
        if (jsonData == null) {
            throw new ClientException("JSON data that was returned by server is null");
        }
    }

    public void validateJavaObject(String jsonData, Object obj) throws ClientException {
        if (obj == null) {
            throw new ClientException(String.format("Server error (invalid JSON Data): %s", jsonData));
        }
    }

    public void validateDatabaseName(String name) throws ClientException {
        if (name == null || name.isEmpty()) {
            throw new ClientException("Empty name is not allowed");
        }
        if (name.length() < 3 || 256 < name.length()) {
            throw new ClientException(String.format("Name must be 3 to 256 characters, got %d characters.", name.length()));
        }
        if (!databaseNamePat.matcher(name).matches()) {
            throw new ClientException("Name must consist only of lower-case alphabets, numbers and '_'.");
        }
    }

    public void validateTableName(String name) throws ClientException {
        this.validateDatabaseName(name);
    }
}

