/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model;

import com.treasure_data.model.AbstractModel;
import com.treasure_data.model.Job;
import org.msgpack.unpacker.Unpacker;

public class JobResult
extends AbstractModel {
    private Job job;
    private Format format;
    private long resultSize;
    private Unpacker result;

    public static Format toFormat(String formatName) {
        if (formatName.equals("msgpack")) {
            return Format.MSGPACK;
        }
        if (formatName.equals("msgpack.gz")) {
            return Format.MSGPACKGZ;
        }
        if (formatName.equals("json")) {
            return Format.JSON;
        }
        return Format.UNKNOWN;
    }

    public static String toFormatName(Format format) {
        switch (format) {
            case MSGPACK: {
                return "msgpack";
            }
            case MSGPACKGZ: {
                return "msgpack.gz";
            }
            case JSON: {
                return "json";
            }
        }
        return "unknown";
    }

    public JobResult(Job job) {
        super(job.getJobID());
        this.job = job;
        this.format = Format.MSGPACKGZ;
    }

    public Job getJob() {
        return this.job;
    }

    public void setResultSize(long size) {
        this.resultSize = size;
    }

    public long getResultSize() {
        return this.resultSize;
    }

    public void setResult(Unpacker result) {
        this.result = result;
    }

    public Unpacker getResult() {
        return this.result;
    }

    public Format getFormat() {
        return this.format;
    }

    public static enum Format {
        MSGPACK,
        MSGPACKGZ,
        JSON,
        UNKNOWN;

    }
}

