/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model;

import com.treasure_data.model.Database;
import com.treasure_data.model.Job;

public class JobSummary
extends Job {
    private Status status;
    private String createdAt;
    private String startAt;
    private String endAt;
    private String resultSchema;
    private Debug debug;

    public static Status toStatus(String statusName) {
        if (statusName == null) {
            throw new NullPointerException();
        }
        if (statusName.equals("queued")) {
            return Status.QUEUED;
        }
        if (statusName.equals("booting")) {
            return Status.BOOTING;
        }
        if (statusName.equals("running")) {
            return Status.RUNNING;
        }
        if (statusName.equals("success")) {
            return Status.SUCCESS;
        }
        if (statusName.equals("error")) {
            return Status.ERROR;
        }
        if (statusName.equals("killed")) {
            return Status.KILLED;
        }
        return Status.UNKNOWN;
    }

    public static String toStatusName(Status status) {
        if (status == null) {
            throw new NullPointerException();
        }
        switch (status) {
            case QUEUED: {
                return "queued";
            }
            case BOOTING: {
                return "booting";
            }
            case RUNNING: {
                return "running";
            }
            case SUCCESS: {
                return "success";
            }
            case ERROR: {
                return "error";
            }
            case KILLED: {
                return "killed";
            }
        }
        return "unknown";
    }

    public JobSummary(String jobID, Job.Type type, Database database, String url, String resultTable, Status status, String startAt, String endAt, String query, String resultSchema) {
        this(jobID, type, database, url, resultTable, status, startAt, endAt, query, resultSchema, null);
    }

    public JobSummary(String jobID, Job.Type type, Database database, String url, String resultTable, Status status, String startAt, String endAt, String query, String resultSchema, Debug debug) {
        super(jobID, type, database, url, resultTable);
        this.status = status;
        this.startAt = startAt;
        this.endAt = endAt;
        this.setQuery(query);
        this.resultSchema = resultSchema;
        this.debug = debug;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setCreatedAt(String time) {
        this.createdAt = time;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setStartAt(String time) {
        this.startAt = time;
    }

    public String getStartAt() {
        return this.startAt;
    }

    public void setEndAt(String time) {
        this.endAt = time;
    }

    public String getEndAt() {
        return this.endAt;
    }

    public String getResultSchema() {
        return this.resultSchema;
    }

    public Debug getDebug() {
        return this.debug;
    }

    public static class Debug {
        private String cmdout;
        private String stderr;

        public Debug(String cmdout, String stderr) {
            this.cmdout = cmdout;
            this.stderr = stderr;
        }

        public String getCmdout() {
            return this.cmdout;
        }

        public String getStderr() {
            return this.stderr;
        }
    }

    public static enum Status {
        QUEUED,
        BOOTING,
        RUNNING,
        SUCCESS,
        ERROR,
        KILLED,
        UNKNOWN;

    }
}

