/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model.bulkimport;

import com.treasure_data.model.bulkimport.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SessionSummary
extends Session {
    private Status status;
    private boolean uploadFrozen;
    private String jobID;
    private long validRecords;
    private long errorRecords;
    private long validParts;
    private long errorParts;

    public SessionSummary(String name, String databaseName, String tableName, Status status, boolean uploadFrozen, String jobID, long validRecords, long errorRecords, long validParts, long errorParts) {
        super(name, databaseName, tableName);
        this.status = status;
        this.uploadFrozen = uploadFrozen;
        this.jobID = jobID;
        this.validRecords = validRecords;
        this.errorRecords = errorRecords;
        this.validParts = validParts;
        this.errorParts = errorParts;
    }

    @Override
    public String toString() {
        return String.format("SessionSummary{name=%s, db=%s, tbl=%s, frozen=%b, stat=%s, jid=%s, vr=%d, er=%d, vp=%d, ep=%d}", this.getName(), this.getDatabaseName(), this.getTableName(), this.status.statusName(), this.uploadFrozen, this.jobID, this.validRecords, this.errorRecords, this.validParts, this.errorParts);
    }

    public String getStatus() {
        return this.status.statusName();
    }

    public boolean uploadFrozen() {
        return this.uploadFrozen;
    }

    public String getJobID() {
        return this.jobID;
    }

    public long getValidRecords() {
        return this.validRecords;
    }

    public long getErrorRecords() {
        return this.errorRecords;
    }

    public long getValidParts() {
        return this.validParts;
    }

    public long getErrorParts() {
        return this.errorParts;
    }

    public static enum Status {
        UPLOADING("uploading"),
        PERFORMING("performing"),
        READY("ready"),
        COMMITTING("committing"),
        COMMITTED("committed"),
        UNKNOWN("unknown");

        private String statusName;

        private Status(String statusName) {
            this.statusName = statusName;
        }

        public String statusName() {
            return this.statusName;
        }

        public static Status fromString(String statusName) {
            return StringToStatus.get(statusName);
        }

        private static class StringToStatus {
            private static final Map<String, Status> REVERSE_DICTIONARY;

            private StringToStatus() {
            }

            static Status get(String key) {
                return REVERSE_DICTIONARY.get(key);
            }

            static {
                HashMap<String, Status> map = new HashMap<String, Status>();
                for (Status elem : Status.values()) {
                    map.put(elem.statusName, elem);
                }
                REVERSE_DICTIONARY = Collections.unmodifiableMap(map);
            }
        }
    }
}

