/*
 * Decompiled with CFR 0.152.
 */
package com.treasure_data.model.bulkimport;

import com.treasure_data.model.bulkimport.BulkImportSpecifyRequest;
import com.treasure_data.model.bulkimport.Session;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UploadPartRequest
extends BulkImportSpecifyRequest<Session> {
    private String partID;
    private Format format;
    private InputStream in;
    private int size;

    public static String toFormatName(Format format) {
        switch (format) {
            case MSGPACKGZ: {
                return "msgpack.gz";
            }
        }
        return "msgpack.gz";
    }

    public static Format toFormat(String formatName) {
        if (formatName.equals("msgpack.gz")) {
            return Format.MSGPACKGZ;
        }
        return Format.MSGPACKGZ;
    }

    public UploadPartRequest(Session sess, String partID, byte[] bytes) {
        this(sess, partID, new ByteArrayInputStream(bytes), bytes.length);
    }

    public UploadPartRequest(Session sess, String partID, InputStream in, int size) {
        super(sess);
        this.partID = partID;
        this.format = Format.MSGPACKGZ;
        this.in = in;
        this.size = size;
    }

    public String getPartID() {
        return this.partID;
    }

    public Format getFormat() {
        return this.format;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public int getSize() {
        return this.size;
    }

    public static enum Format {
        MSGPACKGZ;

    }
}

