/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.treasuredata.client.TDHttpMethod;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDApiRequest {
    private static Logger logger = LoggerFactory.getLogger(TDApiRequest.class);
    private final TDHttpMethod method;
    private final String path;
    private final Map<String, String> queryParams;
    private final Multimap<String, String> headerParams;
    private final Optional<String> postJson;
    private final Optional<File> putFile;
    private final Optional<byte[]> content;
    private final Optional<Boolean> followRedirects;
    private final int contentOffset;
    private final int contentLength;

    TDApiRequest(TDHttpMethod method, String path, Map<String, String> queryParams, Multimap<String, String> headerParams, Optional<String> postJson, Optional<File> putFile, Optional<byte[]> content, int contentOffset, int contentLength, Optional<Boolean> followRedirects) {
        this.method = (TDHttpMethod)((Object)Preconditions.checkNotNull((Object)((Object)method), (Object)"method is null"));
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"uri is null");
        this.queryParams = (Map)Preconditions.checkNotNull(queryParams, (Object)"queryParms is null");
        this.headerParams = (Multimap)Preconditions.checkNotNull(headerParams, (Object)"headerParams is null");
        this.postJson = (Optional)Preconditions.checkNotNull(postJson, (Object)"postJson is null");
        this.putFile = (Optional)Preconditions.checkNotNull(putFile, (Object)"putFile is null");
        this.content = (Optional)Preconditions.checkNotNull(content, (Object)"content is null");
        this.contentOffset = contentOffset;
        this.contentLength = contentLength;
        this.followRedirects = (Optional)Preconditions.checkNotNull(followRedirects, (Object)"followRedirects is null");
    }

    public TDApiRequest withUri(String uri) {
        return new TDApiRequest(this.method, uri, (Map<String, String>)ImmutableMap.copyOf(this.queryParams), (Multimap<String, String>)ImmutableMultimap.copyOf(this.headerParams), this.postJson, this.putFile, this.content, this.contentOffset, this.contentLength, this.followRedirects);
    }

    public String getPath() {
        return this.path;
    }

    public TDHttpMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Multimap<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public Optional<String> getPostJson() {
        return this.postJson;
    }

    public Optional<File> getPutFile() {
        return this.putFile;
    }

    public Optional<byte[]> getContent() {
        return this.content;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Optional<Boolean> getFollowRedirects() {
        return this.followRedirects;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class Builder {
        private static final Map<String, String> EMPTY_MAP = ImmutableMap.of();
        private static final Multimap<String, String> EMPTY_HEADERS = ImmutableMultimap.of();
        private TDHttpMethod method;
        private String path;
        private Map<String, String> queryParams;
        private ImmutableMultimap.Builder<String, String> headerParams;
        private Optional<String> postJson = Optional.absent();
        private Optional<File> file = Optional.absent();
        private Optional<byte[]> content = Optional.absent();
        private int contentOffset;
        private int contentLength;
        private Optional<Boolean> followRedirects = Optional.absent();

        Builder(TDHttpMethod method, String path) {
            this.method = method;
            this.path = path;
        }

        public static Builder GET(String uri) {
            return new Builder(TDHttpMethod.GET, uri);
        }

        public static Builder POST(String uri) {
            return new Builder(TDHttpMethod.POST, uri);
        }

        public static Builder PUT(String uri) {
            return new Builder(TDHttpMethod.PUT, uri);
        }

        public static Builder DELETE(String uri) {
            return new Builder(TDHttpMethod.DELETE, uri);
        }

        public Builder addHeader(String key, String value) {
            if (this.headerParams == null) {
                this.headerParams = ImmutableMultimap.builder();
            }
            this.headerParams.put((Object)key, (Object)value);
            return this;
        }

        public Builder addHeaders(Multimap<String, String> headers) {
            if (this.headerParams == null) {
                this.headerParams = ImmutableMultimap.builder();
            }
            this.headerParams.putAll(headers);
            return this;
        }

        public Builder addQueryParam(String key, String value) {
            if (this.queryParams == null) {
                this.queryParams = new HashMap<String, String>();
            }
            this.queryParams.put(key, value);
            return this;
        }

        public Builder setPostJson(String json) {
            this.postJson = Optional.of((Object)json);
            return this;
        }

        public Builder setFile(File file) {
            this.file = Optional.of((Object)file);
            return this;
        }

        public Builder setContent(byte[] content, int offset, int length) {
            this.content = Optional.of((Object)content);
            this.contentOffset = offset;
            this.contentLength = length;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = Optional.of((Object)followRedirects);
            return this;
        }

        public TDApiRequest build() {
            return new TDApiRequest(this.method, this.path, this.queryParams != null ? this.queryParams : EMPTY_MAP, (Multimap<String, String>)(this.headerParams != null ? this.headerParams.build() : EMPTY_HEADERS), this.postJson, this.file, this.content, this.contentOffset, this.contentLength, this.followRedirects);
        }
    }
}

