/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.net.UrlEscapers;
import com.treasuredata.client.TDApiRequest;
import com.treasuredata.client.TDClientApi;
import com.treasuredata.client.TDClientBuilder;
import com.treasuredata.client.TDClientConfig;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpConflictException;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.client.TDClientHttpNotFoundException;
import com.treasuredata.client.TDHttpClient;
import com.treasuredata.client.model.ObjectMappers;
import com.treasuredata.client.model.TDApiKey;
import com.treasuredata.client.model.TDAuthenticationResult;
import com.treasuredata.client.model.TDBulkImportParts;
import com.treasuredata.client.model.TDBulkImportSession;
import com.treasuredata.client.model.TDBulkLoadSessionStartRequest;
import com.treasuredata.client.model.TDBulkLoadSessionStartResult;
import com.treasuredata.client.model.TDColumn;
import com.treasuredata.client.model.TDConnectionLookupResult;
import com.treasuredata.client.model.TDDatabase;
import com.treasuredata.client.model.TDExportJobRequest;
import com.treasuredata.client.model.TDExportResultJobRequest;
import com.treasuredata.client.model.TDImportResult;
import com.treasuredata.client.model.TDJob;
import com.treasuredata.client.model.TDJobList;
import com.treasuredata.client.model.TDJobRequest;
import com.treasuredata.client.model.TDJobSubmitResult;
import com.treasuredata.client.model.TDJobSummary;
import com.treasuredata.client.model.TDPartialDeleteJob;
import com.treasuredata.client.model.TDResultFormat;
import com.treasuredata.client.model.TDSaveQueryRequest;
import com.treasuredata.client.model.TDSavedQuery;
import com.treasuredata.client.model.TDSavedQueryHistory;
import com.treasuredata.client.model.TDSavedQueryStartRequest;
import com.treasuredata.client.model.TDSavedQueryStartRequestV4;
import com.treasuredata.client.model.TDSavedQueryStartResultV4;
import com.treasuredata.client.model.TDSavedQueryUpdateRequest;
import com.treasuredata.client.model.TDTable;
import com.treasuredata.client.model.TDTableDistribution;
import com.treasuredata.client.model.TDTableList;
import com.treasuredata.client.model.TDTableType;
import com.treasuredata.client.model.TDUpdateTableResult;
import com.treasuredata.client.model.TDUser;
import com.treasuredata.client.model.TDUserList;
import com.treasuredata.client.model.impl.TDScheduleRunResult;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDClient
implements TDClientApi<TDClient> {
    private static final Logger logger = LoggerFactory.getLogger(TDClient.class);
    private static final String version;
    @VisibleForTesting
    protected final TDClientConfig config;
    @VisibleForTesting
    protected final TDHttpClient httpClient;
    protected final Optional<String> apiKeyCache;
    private static Pattern acceptableNamePattern;

    public static String getVersion() {
        return version;
    }

    static String readMavenVersion(URL mavenProperties) {
        String v = "unknown";
        if (mavenProperties != null) {
            try (InputStream in = mavenProperties.openStream();){
                Properties p = new Properties();
                p.load(in);
                v = p.getProperty("version", "unknown");
            }
            catch (Throwable e) {
                logger.warn("Error in reading pom.properties file", e);
            }
        }
        return v;
    }

    public static TDClient newClient() {
        return new TDClientBuilder(true).build();
    }

    public static TDClientBuilder newBuilder() {
        return new TDClientBuilder(true);
    }

    public static TDClientBuilder newBuilder(boolean loadTDConf) {
        return new TDClientBuilder(loadTDConf);
    }

    @Override
    public TDClient withApiKey(String newApiKey) {
        return new TDClient(this.config, this.httpClient, (Optional<String>)Optional.of((Object)newApiKey));
    }

    @Override
    public TDClient withHeaders(Multimap<String, String> headers) {
        return new TDClient(this.config, this.httpClient.withHeaders(headers), this.apiKeyCache);
    }

    public TDClient(TDClientConfig config) {
        this(config, new TDHttpClient(config), config.apiKey);
    }

    protected TDClient(TDClientConfig config, TDHttpClient httpClient, Optional<String> apiKeyCache) {
        this.config = config;
        this.httpClient = httpClient;
        this.apiKeyCache = apiKeyCache;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    protected static String buildUrl(String urlPrefix, String ... args) {
        StringBuilder s = new StringBuilder();
        s.append(urlPrefix);
        for (String a : args) {
            s.append("/");
            s.append(UrlEscapers.urlPathSegmentEscaper().escape(a));
        }
        return s.toString();
    }

    protected <ResultType> ResultType doGet(String path, Class<ResultType> resultTypeClass) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(resultTypeClass, (Object)"resultTypeClass is null");
        TDApiRequest request = TDApiRequest.Builder.GET(path).build();
        return this.httpClient.call(request, this.apiKeyCache, resultTypeClass);
    }

    protected <ResultType> ResultType doGet(String path, TypeReference<ResultType> resultTypeReference) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(resultTypeReference, (Object)"resultTypeReference is null");
        TDApiRequest request = TDApiRequest.Builder.GET(path).build();
        return this.httpClient.call(request, this.apiKeyCache, resultTypeReference);
    }

    protected <ResultType> ResultType doGet(String path, JavaType resultType) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull((Object)resultType, (Object)"resultType is null");
        TDApiRequest request = TDApiRequest.Builder.GET(path).build();
        return (ResultType)this.httpClient.call(request, this.apiKeyCache, resultType);
    }

    protected <ResultType> ResultType doPost(String path, Map<String, String> queryParam, Optional<String> jsonBody, Class<ResultType> resultTypeClass) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(queryParam, (Object)"param is null");
        Preconditions.checkNotNull(jsonBody, (Object)"body is null");
        Preconditions.checkNotNull(resultTypeClass, (Object)"resultTypeClass is null");
        TDApiRequest.Builder request = TDApiRequest.Builder.POST(path);
        for (Map.Entry<String, String> e : queryParam.entrySet()) {
            request.addQueryParam(e.getKey(), e.getValue());
        }
        if (jsonBody.isPresent()) {
            request.setPostJson((String)jsonBody.get());
        }
        return this.httpClient.call(request.build(), this.apiKeyCache, resultTypeClass);
    }

    protected <ResultType> ResultType doPost(String path, Class<ResultType> resultTypeClass) throws TDClientException {
        return this.doPost(path, (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.absent(), resultTypeClass);
    }

    protected <ResultType> ResultType doPost(String path, Map<String, String> queryParam, Class<ResultType> resultTypeClass) throws TDClientException {
        return this.doPost(path, queryParam, (Optional<String>)Optional.absent(), resultTypeClass);
    }

    protected <ResultType> ResultType doPut(String path, Map<String, String> queryParam, File file, Class<ResultType> resultTypeClass) throws TDClientException {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        Preconditions.checkNotNull(resultTypeClass, (Object)"resultTypeClass is null");
        TDApiRequest.Builder request = this.buildPutRequest(path, queryParam);
        request.setFile(file);
        return this.httpClient.call(request.build(), this.apiKeyCache, resultTypeClass);
    }

    protected <ResultType> ResultType doPut(String path, Map<String, String> queryParam, byte[] content, int offset, int length, Class<ResultType> resultTypeClass) throws TDClientException {
        Preconditions.checkNotNull((Object)content, (Object)"content is null");
        Preconditions.checkNotNull(resultTypeClass, (Object)"resultTypeClass is null");
        TDApiRequest.Builder request = this.buildPutRequest(path, queryParam);
        request.setContent(content, offset, length);
        return this.httpClient.call(request.build(), this.apiKeyCache, resultTypeClass);
    }

    private TDApiRequest.Builder buildPutRequest(String path, Map<String, String> queryParam) {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(queryParam, (Object)"param is null");
        TDApiRequest.Builder request = TDApiRequest.Builder.PUT(path);
        for (Map.Entry<String, String> e : queryParam.entrySet()) {
            request.addQueryParam(e.getKey(), e.getValue());
        }
        return request;
    }

    protected String doPost(String path) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        TDApiRequest request = TDApiRequest.Builder.POST(path).build();
        return this.httpClient.call(request, this.apiKeyCache);
    }

    protected String doPost(String path, Map<String, String> queryParam) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull(queryParam, (Object)"param is null");
        TDApiRequest.Builder request = TDApiRequest.Builder.POST(path);
        for (Map.Entry<String, String> e : queryParam.entrySet()) {
            request.addQueryParam(e.getKey(), e.getValue());
        }
        return this.httpClient.call(request.build(), this.apiKeyCache);
    }

    protected String doPut(String path, File filePath) throws TDClientException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Preconditions.checkNotNull((Object)filePath, (Object)"filePath is null");
        TDApiRequest request = TDApiRequest.Builder.PUT(path).setFile(filePath).build();
        return this.httpClient.call(request, this.apiKeyCache);
    }

    @Override
    public TDClient authenticate(String email, String password) {
        TDAuthenticationResult authResult = this.doPost("/v3/user/authenticate", (Map<String, String>)ImmutableMap.of((Object)"user", (Object)email, (Object)"password", (Object)password), TDAuthenticationResult.class);
        return this.withApiKey(authResult.getApikey());
    }

    @Override
    public TDUser getUser() {
        return this.doGet("/v3/user/show", TDUser.class);
    }

    @Override
    public TDApiKey validateApiKey() {
        return this.doGet("/v3/user/apikey/validate", TDApiKey.class);
    }

    @Override
    public TDUserList listUsers() {
        return this.doGet("/v3/user/list", TDUserList.class);
    }

    @Override
    public String serverStatus() {
        return this.httpClient.call(TDApiRequest.Builder.GET("/v3/system/server_status").build(), (Optional<String>)Optional.absent());
    }

    @Override
    public List<String> listDatabaseNames() throws TDClientException {
        ArrayList<String> tableList = new ArrayList<String>();
        for (TDDatabase db : this.listDatabases()) {
            tableList.add(db.getName());
        }
        return tableList;
    }

    @Override
    public List<TDDatabase> listDatabases() throws TDClientException {
        return this.doGet("/v3/database/list", new TypeReference<List<TDDatabase>>(){});
    }

    static String validateDatabaseName(String databaseName) {
        return TDClient.validateName(databaseName, "Database");
    }

    static String validateTableName(String tableName) {
        return TDClient.validateName(tableName, "Table");
    }

    private static String validateName(String name, String type) {
        if (name.length() < 3 || name.length() > 256) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, String.format("%s name must be 3 to 256 characters but got %d characters: %s", type, name.length(), name));
        }
        if (!acceptableNamePattern.matcher(name).matches()) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, String.format("%s name must follow this pattern %s: %s", type, acceptableNamePattern.pattern(), name));
        }
        return name;
    }

    @Override
    public void createDatabase(String databaseName) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/database/create", TDClient.validateDatabaseName(databaseName)));
    }

    @Override
    public void createDatabaseIfNotExists(String databaseName) throws TDClientException {
        try {
            this.createDatabase(databaseName);
        }
        catch (TDClientHttpConflictException tDClientHttpConflictException) {
            // empty catch block
        }
    }

    @Override
    public void deleteDatabase(String databaseName) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/database/delete", TDClient.validateDatabaseName(databaseName)));
    }

    @Override
    public void deleteDatabaseIfExists(String databaseName) throws TDClientException {
        try {
            this.deleteDatabase(databaseName);
        }
        catch (TDClientHttpNotFoundException tDClientHttpNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public TDTable showTable(String databaseName, String tableName) {
        return this.doGet(TDClient.buildUrl("/v3/table/show", databaseName, tableName), TDTable.class);
    }

    @Override
    public List<TDTable> listTables(String databaseName) throws TDClientException {
        TDTableList tableList = this.doGet(TDClient.buildUrl("/v3/table/list", databaseName), TDTableList.class);
        return tableList.getTables();
    }

    @Override
    public boolean existsDatabase(String databaseName) throws TDClientException {
        return this.listDatabaseNames().contains(databaseName);
    }

    @Override
    public boolean existsTable(String databaseName, String tableName) throws TDClientException {
        try {
            for (TDTable table : this.listTables(databaseName)) {
                if (!table.getName().equals(tableName)) continue;
                return true;
            }
            return false;
        }
        catch (TDClientHttpException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void createTable(String databaseName, String tableName) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/table/create", databaseName, TDClient.validateTableName(tableName), TDTableType.LOG.getTypeName()));
    }

    @Override
    public void createTable(String databaseName, String tableName, String idempotentKey) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/table/create", databaseName, TDClient.validateTableName(tableName), TDTableType.LOG.getTypeName()), (Map<String, String>)ImmutableMap.of((Object)"idempotent_key", (Object)idempotentKey));
    }

    @Override
    public void createTableIfNotExists(String databaseName, String tableName) throws TDClientException {
        try {
            this.createTable(databaseName, tableName);
        }
        catch (TDClientHttpConflictException tDClientHttpConflictException) {
            // empty catch block
        }
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newTableName) throws TDClientException {
        this.renameTable(databaseName, tableName, newTableName, false);
    }

    @Override
    public void renameTable(String databaseName, String tableName, String newTableName, boolean overwrite) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/table/rename", databaseName, tableName, TDClient.validateTableName(newTableName)), (Map<String, String>)ImmutableMap.of((Object)"overwrite", (Object)Boolean.toString(overwrite)), TDUpdateTableResult.class);
    }

    @Override
    public void deleteTable(String databaseName, String tableName) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/table/delete", databaseName, tableName));
    }

    @Override
    public void deleteTableIfExists(String databaseName, String tableName) throws TDClientException {
        try {
            this.deleteTable(databaseName, tableName);
        }
        catch (TDClientHttpNotFoundException tDClientHttpNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public TDPartialDeleteJob partialDelete(String databaseName, String tableName, long from, long to) throws TDClientException {
        return this.partialDelete(databaseName, tableName, from, to, null);
    }

    @Override
    public TDPartialDeleteJob partialDelete(String databaseName, String tableName, long from, long to, String domainKey) throws TDClientException {
        if (from % 3600L != 0L || to % 3600L != 0L) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, String.format("from/to value must be a multiple of 3600: [%s, %s)", from, to));
        }
        ImmutableMap.Builder queryParams = ImmutableMap.builder().put((Object)"from", (Object)Long.toString(from)).put((Object)"to", (Object)Long.toString(to));
        if (domainKey != null) {
            queryParams.put((Object)"domain_key", (Object)domainKey);
        }
        TDPartialDeleteJob job = this.doPost(TDClient.buildUrl("/v3/table/partialdelete", databaseName, tableName), (Map<String, String>)queryParams.build(), TDPartialDeleteJob.class);
        return job;
    }

    @Override
    public void swapTables(String databaseName, String tableName1, String tableName2) {
        this.doPost(TDClient.buildUrl("/v3/table/swap", databaseName, tableName1, tableName2));
    }

    @Override
    public void updateTableSchema(String databaseName, String tableName, List<TDColumn> newSchema) {
        this.updateTableSchema(databaseName, tableName, newSchema, false);
    }

    @Override
    public void updateTableSchema(String databaseName, String tableName, List<TDColumn> newSchema, boolean ignoreDuplicate) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"databaseName is null");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Preconditions.checkNotNull(newSchema, (Object)"newSchema is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TDColumn newColumn : newSchema) {
            builder.add((Object)ImmutableList.of((Object)newColumn.getKeyString(), (Object)newColumn.getType().toString(), (Object)newColumn.getName()));
        }
        String schemaJson = JSONObject.toJSONString((Map)ImmutableMap.of((Object)"schema", (Object)builder.build(), (Object)"ignore_duplicate_schema", (Object)ignoreDuplicate));
        this.doPost(TDClient.buildUrl("/v3/table/update-schema", databaseName, tableName), (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.of((Object)schemaJson), String.class);
    }

    @Override
    public void appendTableSchema(String databaseName, String tableName, List<TDColumn> appendedSchema) {
        Preconditions.checkNotNull((Object)databaseName, (Object)"databaseName is null");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Preconditions.checkNotNull(appendedSchema, (Object)"appendedSchema is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TDColumn appendedColumn : appendedSchema) {
            builder.add((Object)ImmutableList.of((Object)appendedColumn.getKeyString(), (Object)appendedColumn.getType().toString()));
        }
        String schemaJson = JSONObject.toJSONString((Map)ImmutableMap.of((Object)"schema", (Object)builder.build()));
        this.doPost(TDClient.buildUrl("/v3/table/append-schema", databaseName, tableName), (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.of((Object)schemaJson), String.class);
    }

    @Override
    public String submit(TDJobRequest jobRequest) throws TDClientException {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("query", jobRequest.getQuery());
        queryParam.put("version", TDClient.getVersion());
        if (jobRequest.getResultOutput().isPresent()) {
            queryParam.put("result", (String)jobRequest.getResultOutput().get());
        }
        queryParam.put("priority", Integer.toString(jobRequest.getPriority().toInt()));
        if (jobRequest.getRetryLimit().isPresent()) {
            queryParam.put("retry_limit", Integer.toString((Integer)jobRequest.getRetryLimit().get()));
        }
        if (jobRequest.getPoolName().isPresent()) {
            queryParam.put("pool_name", (String)jobRequest.getPoolName().get());
        }
        if (jobRequest.getTable().isPresent()) {
            queryParam.put("table", (String)jobRequest.getTable().get());
        }
        if (jobRequest.getScheduledTime().isPresent()) {
            queryParam.put("scheduled_time", String.valueOf(jobRequest.getScheduledTime().get()));
        }
        if (jobRequest.getDomainKey().isPresent()) {
            queryParam.put("domain_key", (String)jobRequest.getDomainKey().get());
        }
        if (jobRequest.getResultConnectionId().isPresent()) {
            queryParam.put("result_connection_id", String.valueOf(jobRequest.getResultConnectionId().get()));
        }
        if (jobRequest.getResultConnectionSettings().isPresent()) {
            queryParam.put("result_connection_settings", (String)jobRequest.getResultConnectionSettings().get());
        }
        if (jobRequest.getEngineVersion().isPresent()) {
            queryParam.put("engine_version", ((TDJob.EngineVersion)jobRequest.getEngineVersion().get()).getEngineVersion());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("submit job: " + jobRequest);
        }
        TDJobSubmitResult result = this.doPost(TDClient.buildUrl("/v3/job/issue", jobRequest.getType().getType(), jobRequest.getDatabase()), queryParam, (Optional<String>)jobRequest.getConfig().transform((Function)new Function<ObjectNode, String>(){

            public String apply(ObjectNode config) {
                ObjectNode body = config.objectNode();
                body.set("config", (JsonNode)config);
                return body.toString();
            }
        }), TDJobSubmitResult.class);
        return result.getJobId();
    }

    @Override
    public TDJobList listJobs() throws TDClientException {
        return this.doGet("/v3/job/list", TDJobList.class);
    }

    @Override
    public TDJobList listJobs(long from, long to) throws TDClientException {
        return this.doGet(String.format("/v3/job/list?from=%d&to=%d", from, to), TDJobList.class);
    }

    @Override
    public void killJob(String jobId) throws TDClientException {
        this.doPost(TDClient.buildUrl("/v3/job/kill", jobId));
    }

    @Override
    public TDJobSummary jobStatus(String jobId) throws TDClientException {
        return this.doGet(TDClient.buildUrl("/v3/job/status", jobId), TDJobSummary.class);
    }

    @Override
    public TDJobSummary jobStatusByDomainKey(String domainKey) {
        return this.doGet(TDClient.buildUrl("/v3/job/status_by_domain_key", domainKey), TDJobSummary.class);
    }

    @Override
    public TDJob jobInfo(String jobId) throws TDClientException {
        return this.doGet(TDClient.buildUrl("/v3/job/show", jobId), TDJob.class);
    }

    @Override
    public <Result> Result jobResult(String jobId, TDResultFormat format, Function<InputStream, Result> resultStreamHandler) throws TDClientException {
        TDApiRequest request = TDApiRequest.Builder.GET(TDClient.buildUrl("/v3/job/result", jobId)).addQueryParam("format", format.getName()).build();
        return this.httpClient.call(request, this.apiKeyCache, resultStreamHandler);
    }

    @Override
    public List<TDBulkImportSession> listBulkImportSessions() {
        return this.doGet(TDClient.buildUrl("/v3/bulk_import/list", new String[0]), new TypeReference<List<TDBulkImportSession>>(){});
    }

    @Override
    public List<String> listBulkImportParts(String sessionName) {
        return this.doGet(TDClient.buildUrl("/v3/bulk_import/list_parts", sessionName), TDBulkImportParts.class).getParts();
    }

    @Override
    public void createBulkImportSession(String sessionName, String databaseName, String tableName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/create", sessionName, databaseName, tableName));
    }

    @Override
    public TDBulkImportSession getBulkImportSession(String sessionName) {
        return this.doGet(TDClient.buildUrl("/v3/bulk_import/show", sessionName), TDBulkImportSession.class);
    }

    @Override
    public void uploadBulkImportPart(String sessionName, String uniquePartName, File path) {
        this.doPut(TDClient.buildUrl("/v3/bulk_import/upload_part", sessionName, uniquePartName), path);
    }

    public void deleteBulkImportPart(String sessionName, String uniquePartName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/delete_part", sessionName, uniquePartName));
    }

    @Override
    public void freezeBulkImportSession(String sessionName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/freeze", sessionName));
    }

    @Override
    public void unfreezeBulkImportSession(String sessionName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/unfreeze", sessionName));
    }

    @Override
    public void performBulkImportSession(String sessionName) {
        this.performBulkImportSession(sessionName, TDJob.Priority.NORMAL);
    }

    @Override
    public void performBulkImportSession(String sessionName, Optional<String> poolName) {
        this.performBulkImportSession(sessionName, poolName, TDJob.Priority.NORMAL);
    }

    @Override
    public void performBulkImportSession(String sessionName, TDJob.Priority priority) {
        this.performBulkImportSession(sessionName, (Optional<String>)Optional.absent(), priority);
    }

    @Override
    public void performBulkImportSession(String sessionName, Optional<String> poolName, TDJob.Priority priority) {
        Optional jsonBody = Optional.absent();
        if (poolName.isPresent()) {
            jsonBody = Optional.of((Object)JSONObject.toJSONString((Map)ImmutableMap.of((Object)"pool_name", (Object)poolName.get())));
        }
        this.doPost(TDClient.buildUrl("/v3/bulk_import/perform", sessionName), (Map<String, String>)ImmutableMap.of((Object)"priority", (Object)Integer.toString(priority.toInt())), (Optional<String>)jsonBody, String.class);
    }

    @Override
    public void commitBulkImportSession(String sessionName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/commit", sessionName));
    }

    @Override
    public void deleteBulkImportSession(String sessionName) {
        this.doPost(TDClient.buildUrl("/v3/bulk_import/delete", sessionName));
    }

    @Override
    public <Result> Result getBulkImportErrorRecords(String sessionName, Function<InputStream, Result> resultStreamHandler) {
        TDApiRequest request = TDApiRequest.Builder.GET(TDClient.buildUrl("/v3/bulk_import/error_records", sessionName)).build();
        return this.httpClient.call(request, this.apiKeyCache, resultStreamHandler);
    }

    @Override
    public String startSavedQuery(String name, Date scheduledTime) {
        return this.startSavedQuery(TDSavedQueryStartRequest.builder().name(name).scheduledTime(scheduledTime).build());
    }

    @Override
    public String startSavedQuery(long id, Date scheduledTime) {
        return this.startSavedQueryV4(TDSavedQueryStartRequest.builder().name("").id(id).scheduledTime(scheduledTime).build());
    }

    @Override
    public String startSavedQuery(TDSavedQueryStartRequest request) {
        if (request.id().isPresent()) {
            return this.startSavedQueryV4(request);
        }
        return this.startSavedQueryV3(request);
    }

    private String startSavedQueryV4(TDSavedQueryStartRequest request) {
        if (request.num().isPresent() && (Integer)request.num().get() != 1) {
            throw new UnsupportedOperationException("num must be 1");
        }
        TDSavedQueryStartResultV4 result = this.doPost(TDClient.buildUrl("/v4/queries", Long.toString((Long)request.id().get()), "jobs"), (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.of((Object)this.toJson(TDSavedQueryStartRequestV4.from(request))), TDSavedQueryStartResultV4.class);
        return result.getId();
    }

    private String startSavedQueryV3(TDSavedQueryStartRequest request) {
        Optional<String> domainKey;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        Optional<Integer> num = request.num();
        if (num.isPresent()) {
            queryParams.put("num", Integer.toString((Integer)num.get()));
        }
        if ((domainKey = request.domainKey()).isPresent()) {
            queryParams.put("domain_key", (String)domainKey.get());
        }
        TDScheduleRunResult result = this.doPost(TDClient.buildUrl("/v3/schedule/run", request.name(), Long.toString(request.scheduledTime().getTime() / 1000L)), queryParams, TDScheduleRunResult.class);
        return result.getJobs().get(0).getJobId();
    }

    @Override
    public List<TDSavedQuery> listSavedQueries() {
        return this.doGet(TDClient.buildUrl("/v3/schedule/list", new String[0]), new TypeReference<List<TDSavedQuery>>(){});
    }

    @Override
    public TDSavedQueryHistory getSavedQueryHistory(String name) {
        return this.getSavedQueryHistory(name, 0L, 20L);
    }

    @Override
    public TDSavedQueryHistory getSavedQueryHistory(String name, Long from, Long to) {
        TDApiRequest.Builder builder = TDApiRequest.Builder.GET(TDClient.buildUrl("/v3/schedule/history", name));
        if (from != null) {
            builder.addQueryParam("from", String.valueOf(from));
        }
        if (to != null) {
            builder.addQueryParam("to", String.valueOf(to));
        }
        TDApiRequest request = builder.build();
        return this.httpClient.call(request, this.apiKeyCache, TDSavedQueryHistory.class);
    }

    protected String toJson(Object any) {
        try {
            return this.httpClient.getObjectMapper().writeValueAsString(any);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to produce json", (Throwable)e);
            throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, String.format("Failed to create JSON string from %s", any));
        }
    }

    @Override
    public TDSavedQuery saveQuery(TDSaveQueryRequest request) {
        String json = this.toJson(request);
        logger.debug("saveQuery request:" + json);
        TDSavedQuery result = this.doPost(TDClient.buildUrl("/v3/schedule/create", request.getName()), (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.of((Object)json), TDSavedQuery.class);
        return result;
    }

    @Override
    public TDSavedQuery updateSavedQuery(String name, TDSavedQueryUpdateRequest request) {
        String json = request.toJson();
        logger.debug("updateSaveQuery request:" + json);
        TDSavedQuery result = this.doPost(TDClient.buildUrl("/v3/schedule/update", name), (Map<String, String>)ImmutableMap.of(), (Optional<String>)Optional.of((Object)json), TDSavedQuery.class);
        return result;
    }

    @Override
    public TDSavedQuery deleteSavedQuery(String name) {
        TDSavedQuery result = this.doPost(TDClient.buildUrl("/v3/schedule/delete", name), TDSavedQuery.class);
        return result;
    }

    @Override
    public String submitExportJob(TDExportJobRequest jobRequest) throws TDClientException {
        Optional<String> domainKey;
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("from", Long.toString(jobRequest.getFrom().getTime() / 1000L));
        queryParam.put("to", Long.toString(jobRequest.getTo().getTime() / 1000L));
        queryParam.put("file_prefix", jobRequest.getFilePrefix());
        queryParam.put("file_format", jobRequest.getFileFormat().toString());
        queryParam.put("storage_type", "s3");
        queryParam.put("bucket", jobRequest.getBucketName());
        queryParam.put("access_key_id", jobRequest.getAccessKeyId());
        queryParam.put("secret_access_key", jobRequest.getSecretAccessKey());
        if (jobRequest.getPoolName().isPresent()) {
            queryParam.put("pool_name", (String)jobRequest.getPoolName().get());
        }
        if ((domainKey = jobRequest.getDomainKey()).isPresent()) {
            queryParam.put("domain_key", (String)domainKey.get());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("submit job: " + jobRequest);
        }
        TDJobSubmitResult result = this.doPost(TDClient.buildUrl("/v3/export/run", jobRequest.getDatabase(), jobRequest.getTable()), queryParam, TDJobSubmitResult.class);
        return result.getJobId();
    }

    @Override
    public TDBulkLoadSessionStartResult startBulkLoadSession(String name) {
        TDBulkLoadSessionStartRequest request = TDBulkLoadSessionStartRequest.builder().build();
        return this.startBulkLoadSession(name, request);
    }

    @Override
    public TDBulkLoadSessionStartResult startBulkLoadSession(String name, long scheduledTime) {
        TDBulkLoadSessionStartRequest request = TDBulkLoadSessionStartRequest.builder().setScheduledTime(String.valueOf(scheduledTime)).build();
        return this.startBulkLoadSession(name, request);
    }

    @Override
    public TDBulkLoadSessionStartResult startBulkLoadSession(String name, TDBulkLoadSessionStartRequest request) {
        ImmutableMap queryParams = ImmutableMap.of();
        String payload = null;
        try {
            payload = ObjectMappers.compactMapper().writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this.doPost(TDClient.buildUrl("/v3/bulk_loads", name, "jobs"), (Map<String, String>)queryParams, (Optional<String>)Optional.of((Object)payload), TDBulkLoadSessionStartResult.class);
    }

    @Override
    public long lookupConnection(String name) {
        return this.doGet(TDClient.buildUrl("/v3/connections/lookup?name=" + UrlEscapers.urlPathSegmentEscaper().escape(name), new String[0]), TDConnectionLookupResult.class).getId();
    }

    @Override
    public String submitResultExportJob(TDExportResultJobRequest jobRequest) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (!jobRequest.getResultConnectionId().isEmpty() && !jobRequest.getResultConnectionSettings().isEmpty()) {
            queryParam.put("result_connection_id", jobRequest.getResultConnectionId());
            queryParam.put("result_connection_settings", jobRequest.getResultConnectionSettings());
        } else if (!jobRequest.getResultOutput().isEmpty()) {
            queryParam.put("result", jobRequest.getResultOutput());
        } else {
            throw new IllegalStateException("Either resultOutput or a pair of resultConnectionId and resultConnectionSettings is required");
        }
        TDJobSubmitResult result = this.doPost(TDClient.buildUrl("/v3/job/result_export", jobRequest.getJobId()), queryParam, TDJobSubmitResult.class);
        return result.getJobId();
    }

    @Override
    public Optional<TDTableDistribution> tableDistribution(String databaseName, String tableName) {
        try {
            TDTableDistribution distribution = this.doGet(TDClient.buildUrl(String.format("/v3/table/distribution/%s/%s", databaseName, tableName), new String[0]), TDTableDistribution.class);
            return Optional.of((Object)distribution);
        }
        catch (TDClientHttpNotFoundException e) {
            return Optional.absent();
        }
    }

    @Override
    public TDImportResult importFile(String databaseName, String tableName, File file) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import/%s/%s/%s", databaseName, tableName, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), file, TDImportResult.class);
    }

    @Override
    public TDImportResult importFile(String databaseName, String tableName, File file, String id) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import_with_id/%s/%s/%s/%s", databaseName, tableName, id, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), file, TDImportResult.class);
    }

    @Override
    public TDImportResult importBytes(String databaseName, String tableName, byte[] content) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import/%s/%s/%s", databaseName, tableName, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), content, 0, content.length, TDImportResult.class);
    }

    @Override
    public TDImportResult importBytes(String databaseName, String tableName, byte[] content, int offset, int length) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import/%s/%s/%s", databaseName, tableName, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), content, offset, length, TDImportResult.class);
    }

    @Override
    public TDImportResult importBytes(String databaseName, String tableName, byte[] content, String id) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import_with_id/%s/%s/%s/%s", databaseName, tableName, id, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), content, 0, content.length, TDImportResult.class);
    }

    @Override
    public TDImportResult importBytes(String databaseName, String tableName, byte[] content, int offset, int length, String id) {
        return this.doPut(TDClient.buildUrl(String.format("/v3/table/import_with_id/%s/%s/%s/%s", databaseName, tableName, id, "msgpack.gz"), new String[0]), (Map<String, String>)ImmutableMap.of(), content, offset, length, TDImportResult.class);
    }

    static {
        URL mavenProperties = TDClient.class.getResource("/META-INF/maven/com.treasuredata.client/td-client/pom.properties");
        version = TDClient.readMavenVersion(mavenProperties);
        logger.info("td-client version: " + version);
        acceptableNamePattern = Pattern.compile("^([a-z0-9_]+)$");
    }
}

