/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.BackOff;

abstract class AbstractBackOff
implements BackOff {
    protected final int baseIntervalMillis;
    protected final int maxIntervalMillis;
    protected final double multiplier;
    protected int executionCount;

    protected AbstractBackOff(int baseIntervalMillis, int maxIntervalMillis, double multiplier) {
        this.baseIntervalMillis = baseIntervalMillis;
        this.maxIntervalMillis = maxIntervalMillis;
        this.multiplier = multiplier;
        this.executionCount = 0;
        if (baseIntervalMillis < 0) {
            throw new IllegalArgumentException("baseIntervalMillis must be >= 0");
        }
        if (maxIntervalMillis < 0) {
            throw new IllegalArgumentException("maxIntervalMillis must be >= 0");
        }
        if (multiplier < 0.0) {
            throw new IllegalArgumentException("multiplier must be >= 0");
        }
    }

    protected double calculateExponential() {
        return Math.min((double)this.baseIntervalMillis * Math.pow(this.multiplier, this.executionCount), (double)this.maxIntervalMillis);
    }

    @Override
    public int getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public void incrementExecutionCount() {
        ++this.executionCount;
    }
}

