/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.treasuredata.client.TDHttpMethod;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDApiRequest {
    private static Logger logger = LoggerFactory.getLogger(TDApiRequest.class);
    private final TDHttpMethod method;
    private final String path;
    private final Map<String, String> queryParams;
    private final Map<String, Collection<String>> headerParams;
    private final Optional<String> postJson;
    private final Optional<File> putFile;
    private final Optional<byte[]> content;
    private final Optional<Boolean> followRedirects;
    private final int contentOffset;
    private final int contentLength;

    TDApiRequest(TDHttpMethod method, String path, Map<String, String> queryParams, Map<String, Collection<String>> headerParams, Optional<String> postJson, Optional<File> putFile, Optional<byte[]> content, int contentOffset, int contentLength, Optional<Boolean> followRedirects) {
        this.method = Objects.requireNonNull(method, "method is null");
        this.path = Objects.requireNonNull(path, "uri is null");
        this.queryParams = Objects.requireNonNull(queryParams, "queryParms is null");
        this.headerParams = Objects.requireNonNull(headerParams, "headerParams is null");
        this.postJson = Objects.requireNonNull(postJson, "postJson is null");
        this.putFile = Objects.requireNonNull(putFile, "putFile is null");
        this.content = Objects.requireNonNull(content, "content is null");
        this.contentOffset = contentOffset;
        this.contentLength = contentLength;
        this.followRedirects = Objects.requireNonNull(followRedirects, "followRedirects is null");
    }

    public TDApiRequest withUri(String uri) {
        return new TDApiRequest(this.method, uri, Collections.unmodifiableMap(new HashMap<String, String>(this.queryParams)), Collections.unmodifiableMap(new HashMap<String, Collection<String>>(this.headerParams)), this.postJson, this.putFile, this.content, this.contentOffset, this.contentLength, this.followRedirects);
    }

    public String getPath() {
        return this.path;
    }

    public TDHttpMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Deprecated
    public Multimap<String, String> getHeaderParams() {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        for (Map.Entry<String, Collection<String>> e : this.headerParams.entrySet()) {
            builder.putAll((Object)e.getKey(), (Iterable)e.getValue());
        }
        return builder.build();
    }

    public Map<String, Collection<String>> getAllHeaders() {
        return this.headerParams;
    }

    public Optional<String> getPostJson() {
        return this.postJson;
    }

    public Optional<File> getPutFile() {
        return this.putFile;
    }

    public Optional<byte[]> getContent() {
        return this.content;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Optional<Boolean> getFollowRedirects() {
        return this.followRedirects;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
        private static final Map<String, Collection<String>> EMPTY_HEADERS = Collections.emptyMap();
        private TDHttpMethod method;
        private String path;
        private Map<String, String> queryParams;
        private HashMap<String, Collection<String>> headerParams;
        private Optional<String> postJson = Optional.empty();
        private Optional<File> file = Optional.empty();
        private Optional<byte[]> content = Optional.empty();
        private int contentOffset;
        private int contentLength;
        private Optional<Boolean> followRedirects = Optional.empty();

        Builder(TDHttpMethod method, String path) {
            this.method = method;
            this.path = path;
        }

        public static Builder GET(String uri) {
            return new Builder(TDHttpMethod.GET, uri);
        }

        public static Builder POST(String uri) {
            return new Builder(TDHttpMethod.POST, uri);
        }

        public static Builder PUT(String uri) {
            return new Builder(TDHttpMethod.PUT, uri);
        }

        public static Builder DELETE(String uri) {
            return new Builder(TDHttpMethod.DELETE, uri);
        }

        public Builder addHeader(String key, String value) {
            return this.addHeaders(key, Collections.singletonList(value));
        }

        @Deprecated
        public Builder addHeaders(Multimap<String, String> headers) {
            return this.addHeaders(headers.asMap());
        }

        public Builder addHeaders(String key, Collection<String> values) {
            if (this.headerParams == null) {
                this.headerParams = new HashMap();
            }
            this.addHeaderValues(key, values);
            return this;
        }

        public Builder addHeaders(Map<String, ? extends Collection<String>> headers) {
            if (this.headerParams == null) {
                this.headerParams = new HashMap();
            }
            for (Map.Entry<String, ? extends Collection<String>> e : headers.entrySet()) {
                this.addHeaderValues(e.getKey(), e.getValue());
            }
            return this;
        }

        private void addHeaderValues(String key, Collection<String> values) {
            this.headerParams.compute(key, (unused, list) -> {
                if (list == null) {
                    return new ArrayList(values);
                }
                list.addAll(values);
                return list;
            });
        }

        public Builder addQueryParam(String key, String value) {
            if (this.queryParams == null) {
                this.queryParams = new HashMap<String, String>();
            }
            this.queryParams.put(key, value);
            return this;
        }

        public Builder setPostJson(String json) {
            this.postJson = Optional.of(json);
            return this;
        }

        public Builder setFile(File file) {
            this.file = Optional.of(file);
            return this;
        }

        public Builder setContent(byte[] content, int offset, int length) {
            this.content = Optional.of(content);
            this.contentOffset = offset;
            this.contentLength = length;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = Optional.of(followRedirects);
            return this;
        }

        public TDApiRequest build() {
            return new TDApiRequest(this.method, this.path, this.queryParams != null ? this.queryParams : EMPTY_MAP, this.headerParams != null ? Collections.unmodifiableMap(new HashMap<String, Collection<String>>(this.headerParams)) : EMPTY_HEADERS, this.postJson, this.file, this.content, this.contentOffset, this.contentLength, this.followRedirects);
        }
    }
}

