/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.treasuredata.client.BackOffStrategy;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDClientException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDClientConfig {
    public static final String ENV_TD_CLIENT_APIKEY = "TD_API_KEY";
    public final String endpoint;
    public final Optional<Integer> port;
    public final Optional<String> apiKey;
    public final Optional<String> user;
    public final Optional<String> password;
    public final Optional<ProxyConfig> proxy;
    public final boolean useSSL;
    public final BackOffStrategy retryStrategy;
    public final int retryLimit;
    public final int retryInitialIntervalMillis;
    public final int retryMaxIntervalMillis;
    public final double retryMultiplier;
    public final int connectTimeoutMillis;
    public final int readTimeoutMillis;
    public final int connectionPoolSize;
    @Deprecated
    public final Multimap<String, String> headers;
    public final Map<String, Collection<String>> headersV2;
    private static Logger logger = LoggerFactory.getLogger(TDClientConfig.class);
    private static Properties tdConf;

    public static List<Type> knownProperties() {
        return Arrays.asList(Type.values());
    }

    @JsonCreator
    TDClientConfig(Optional<String> endpoint, Optional<Integer> port, boolean useSSL, Optional<String> apiKey, Optional<String> user, Optional<String> password, Optional<ProxyConfig> proxy, BackOffStrategy retryStrategy, int retryLimit, int retryInitialIntervalMillis, int retryMaxIntervalMillis, double retryMultiplier, int connectTimeoutMillis, int readTimeoutMillis, int connectionPoolSize, Map<String, Collection<String>> headers) {
        this.endpoint = endpoint.orElse("api.treasuredata.com");
        this.port = port;
        this.useSSL = useSSL;
        this.apiKey = apiKey;
        this.user = user;
        this.password = password;
        this.proxy = proxy;
        this.retryStrategy = retryStrategy;
        this.retryLimit = retryLimit;
        this.retryInitialIntervalMillis = retryInitialIntervalMillis;
        this.retryMaxIntervalMillis = retryMaxIntervalMillis;
        this.retryMultiplier = retryMultiplier;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.connectionPoolSize = connectionPoolSize;
        this.headersV2 = headers;
        ImmutableMultimap.Builder headersBuilder = ImmutableMultimap.builder();
        for (Map.Entry<String, Collection<String>> e : headers.entrySet()) {
            headersBuilder.putAll((Object)e.getKey(), (Iterable)e.getValue());
        }
        this.headers = headersBuilder.build();
    }

    public TDClientConfig withApiKey(String apikey) {
        return this.withApiKey(Optional.of(apikey));
    }

    public TDClientConfig withApiKey(Optional<String> apikey) {
        return new TDClientConfig(Optional.of(this.endpoint), this.port, this.useSSL, apikey, this.user, this.password, this.proxy, this.retryStrategy, this.retryLimit, this.retryInitialIntervalMillis, this.retryMaxIntervalMillis, this.retryMultiplier, this.connectTimeoutMillis, this.readTimeoutMillis, this.connectionPoolSize, this.headersV2);
    }

    private static <V> void saveProperty(Properties p, Type config, V value) {
        if (value == null) {
            return;
        }
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (opt.isPresent()) {
                Object v = opt.get();
                TDClientConfig.saveProperty(p, config, v);
            }
        } else {
            p.setProperty(config.key, value.toString());
        }
    }

    public Properties toProperties() {
        Properties p = new Properties();
        TDClientConfig.saveProperty(p, Type.API_ENDPOINT, this.endpoint);
        TDClientConfig.saveProperty(p, Type.API_PORT, this.port);
        TDClientConfig.saveProperty(p, Type.USESSL, this.useSSL);
        TDClientConfig.saveProperty(p, Type.APIKEY, this.apiKey);
        TDClientConfig.saveProperty(p, Type.USER, this.user);
        TDClientConfig.saveProperty(p, Type.PASSOWRD, this.password);
        if (this.proxy.isPresent()) {
            ProxyConfig pc = this.proxy.get();
            TDClientConfig.saveProperty(p, Type.PROXY_HOST, pc.getHost());
            TDClientConfig.saveProperty(p, Type.PROXY_PORT, pc.getPort());
            TDClientConfig.saveProperty(p, Type.PROXY_USER, pc.getUser());
            TDClientConfig.saveProperty(p, Type.PROXY_PASSWORD, pc.getPassword());
            TDClientConfig.saveProperty(p, Type.PROXY_USESSL, pc.useSSL());
        }
        TDClientConfig.saveProperty(p, Type.RETRY_LIMIT, this.retryLimit);
        TDClientConfig.saveProperty(p, Type.RETRY_INITIAL_INTERVAL_MILLIS, this.retryInitialIntervalMillis);
        TDClientConfig.saveProperty(p, Type.RETRY_MAX_INTERVAL_MILLIS, this.retryMaxIntervalMillis);
        TDClientConfig.saveProperty(p, Type.RETRY_MULTIPLIER, this.retryMultiplier);
        TDClientConfig.saveProperty(p, Type.CONNECT_TIMEOUT_MILLIS, this.connectTimeoutMillis);
        TDClientConfig.saveProperty(p, Type.CONNECTION_POOL_SIZE, this.connectionPoolSize);
        return p;
    }

    static Properties getTDConfProperties() {
        if (tdConf == null) {
            tdConf = TDClientConfig.readTDConf();
        }
        return tdConf;
    }

    public static Properties readTDConf() {
        Properties p = new Properties();
        File file = new File(System.getProperty("user.home", "./"), String.format(".td/td.conf", new Object[0]));
        if (!file.exists()) {
            logger.warn(String.format("config file %s is not found", file));
            return p;
        }
        return TDClientConfig.readTDConf(file);
    }

    public static Properties readTDConf(File file) {
        Properties p = new Properties();
        logger.info(String.format("Reading configuration file: %s", file));
        try {
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            StringBuilder extracted = new StringBuilder();
            for (String line : lines) {
                String trimmed = line.trim();
                if (trimmed.startsWith("[") || trimmed.startsWith("#")) continue;
                extracted.append(line.trim());
                extracted.append("\n");
            }
            String props = extracted.toString();
            p.load(new StringReader(props));
            if (p.containsKey("endpoint")) {
                TDClientConfig.parseEndpoint(p);
            }
            return p;
        }
        catch (IOException e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_CONFIGURATION, String.format("Failed to read config file: %s", file), e);
        }
    }

    private static void parseEndpoint(Properties p) {
        boolean useSsl;
        int defaultPort;
        URI uri;
        String endpoint = p.getProperty("endpoint");
        try {
            uri = new URI(endpoint);
        }
        catch (URISyntaxException ignore) {
            return;
        }
        switch (uri.getScheme()) {
            case "http": {
                defaultPort = 80;
                useSsl = false;
                break;
            }
            case "https": {
                defaultPort = 443;
                useSsl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid endpoint scheme: " + uri.getScheme());
            }
        }
        p.setProperty("endpoint", uri.getHost());
        if (!p.containsKey("port")) {
            int port = uri.getPort() == -1 ? defaultPort : uri.getPort();
            p.setProperty("port", Integer.toString(port));
        }
        if (!p.contains("usessl")) {
            p.setProperty("usessl", Boolean.toString(useSsl));
        }
    }

    public static enum Type {
        APIKEY("td.client.apikey", "API key to access Treasure Data."),
        USER("td.client.user", "Account e-mail address (unnecessary if apikey is set)"),
        PASSOWRD("td.client.password", "Account password (unnecessary if apikey is set"),
        USESSL("td.client.usessl", "Use SSL encryption"),
        API_ENDPOINT("td.client.endpoint", "TD API end point (e.g., api.treasuredata.com"),
        API_PORT("td.client.port", "TD API port number"),
        RETRY_LIMIT("td.client.retry.limit", "The maximum nubmer of API request retry"),
        RETRY_INITIAL_INTERVAL_MILLIS("td.client.retry.initial-interval", "backoff retry interval = (interval) * (multiplier) ^ (retry count)"),
        RETRY_MAX_INTERVAL_MILLIS("td.client.retry.max-interval", "max retry interval"),
        RETRY_MULTIPLIER("td.client.retry.multiplier", "retry interval multiplier"),
        CONNECT_TIMEOUT_MILLIS("td.client.connect-timeout", "connection timeout before reaching the API"),
        READ_TIMEOUT_MILLIS("td.client.read-timeout", "connection read timeout from API"),
        CONNECTION_POOL_SIZE("td.client.connection-pool-size", "connection pool size"),
        PROXY_HOST("td.client.proxy.host", "Proxy host (e.g., myproxy.com)"),
        PROXY_PORT("td.client.proxy.port", "Proxy port number"),
        PROXY_USER("td.client.proxy.user", "Proxy user name"),
        PROXY_PASSWORD("td.client.proxy.password", "Proxy paassword"),
        PROXY_USESSL("td.client.proxy.usessl", "Use SSL for proxy");

        public final String key;
        public final String description;

        private Type(String key, String description) {
            this.key = key;
            this.description = description;
        }
    }
}

