/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.TDClientException;
import java.util.Date;
import java.util.Optional;

public class TDClientHttpException
extends TDClientException {
    private final int statusCode;
    private final long retryAfter;

    public TDClientHttpException(TDClientException.ErrorType errorType, String message, int statusCode, Date retryAfter) {
        super(errorType, message);
        this.statusCode = statusCode;
        this.retryAfter = retryAfter == null ? -1L : retryAfter.getTime();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Optional<Date> getRetryAfter() {
        if (this.retryAfter == -1L) {
            return Optional.empty();
        }
        return Optional.of(new Date(this.retryAfter));
    }
}

